/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.DrwgrpStsEnum;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.service.impl.DcDrawInfoServiceImpl;
import com.ejianc.business.dc.service.impl.DcDrwgrpInfoServiceImpl;
import com.ejianc.business.dc.service.impl.DcSendFileServiceImpl;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileImportVo;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excelImportService"})
public class ExcelDemoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private IExcelItemService service;
    @Autowired
    private DcDrwgrpInfoServiceImpl dcDrwgrpInfoService;
    @Autowired
    private DcDrawInfoServiceImpl dcDrawInfoService;
    @Autowired
    private DcSendFileServiceImpl dcSendFileService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRefApi iRefApi;
    @Autowired
    private IDefdocApi iDefdocApi;

    @RequestMapping(value={"/downloadDcDrwgrpInfo"})
    @ResponseBody
    public void downloadDcDrwgrpInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"drwgrp-import.xlsx", (String)"\u5377\u518c\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadDcDrawInfo"})
    @ResponseBody
    public void downloadDcDrawInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-import.xlsx", (String)"\u56fe\u7eb8\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelDcDrwgrpInfoImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelDcDrwgrpInfoImport(request);
        return response;
    }

    @RequestMapping(value={"/excelDcDrawInfoImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelDcDrawInfoImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelDcDrwgrpInfoItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrwgrpInfoItem(@RequestBody List<DcDrwgrpInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        ArrayList drawInfoList = Lists.newArrayList();
        importVos.forEach(importVO -> {
            DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)((Object)BeanMapper.map((Object)importVO, DcDrwgrpInfoEntity.class)));
            entity.setId(IdWorker.getId());
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(this.sessionManager.getUserContext().getTenantid());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setDrwgrpSts(DrwgrpStsEnum.N.getCode());
            entity.setIssueSts("0");
            entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
            list.add(entity);
            DcDrawInfoEntity drawInfo = new DcDrawInfoEntity();
            drawInfo.setDrwgrpId(entity.getId());
            drawInfo.setDrwgrpCode(entity.getDrwgrpCode());
            drawInfo.setDrwgrpVsn(entity.getDrwgrpVsn());
            drawInfo.setDrawCode(entity.getDrwgrpCode());
            drawInfo.setDrawName(entity.getDrwgrpName());
            drawInfo.setDrawVsn(entity.getDrwgrpVsn());
            drawInfo.setProjectId(entity.getProjectId());
            drawInfo.setProjectCode(entity.getProjectCode());
            drawInfo.setProjectName(entity.getProjectName());
            CommonResponse defdocDetailList = this.iDefdocApi.getDefDocByDefCode("draw_type");
            if (defdocDetailList.isSuccess() && ToolUtil.isNotEmpty(defdocDetailList.getData())) {
                Long defdocDetailId = ((List)defdocDetailList.getData()).stream().filter(a -> "A".equals(a.getCode())).map(BaseVO::getId).findFirst().orElse(null);
                drawInfo.setDrawType(defdocDetailId);
            }
            try {
                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(entity.getEngineeringTypeId() + ""), (String)"support-defdoc");
                if ("\u706b\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name"))) {
                    drawInfo.setPaperFlag("Y");
                } else if ("\u6838\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name"))) {
                    drawInfo.setPaperFlag("N");
                }
            }
            catch (Exception e) {
                return;
            }
            drawInfo.setDrawArriveDate(entity.getDrawArriveDate());
            drawInfo.setIssueSts(IssueStsEnum.ISSUE.getCode());
            drawInfo.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            drawInfo.setCheckState("N");
            drawInfoList.add(drawInfo);
        });
        this.dcDrwgrpInfoService.saveBatch(list, list.size());
        this.dcDrawInfoService.saveBatch(drawInfoList, drawInfoList.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveImportExcelDcDrawInfoItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrawInfoItem(@RequestBody List<DcDrawInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            DcDrawInfoEntity entity = (DcDrawInfoEntity)((Object)((Object)BeanMapper.map((Object)importVO, DcDrawInfoEntity.class)));
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(this.sessionManager.getUserContext().getTenantid());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setSyncEsFlag(0);
            entity.setIssueSts("0");
            list.add(entity);
        });
        this.dcDrawInfoService.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadDcSendFile"})
    @ResponseBody
    public void downloadDcSendFile(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"sendFile-import.xlsx", (String)"\u53d1\u6587\u7ba1\u7406\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelSendFileImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelSendFileImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelSendFileImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelDcSendFileItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcSendFileItem(@RequestBody List<DcSendFileImportVo> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            DcSendFileEntity entity = (DcSendFileEntity)((Object)((Object)BeanMapper.map((Object)importVO, DcSendFileEntity.class)));
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(this.sessionManager.getUserContext().getTenantid());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setSyncEsFlag(0);
            list.add(entity);
        });
        this.dcSendFileService.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

