/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller.bpm;

import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bpm"})
public class BpmController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBpmApi iBpmApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value={"/batchSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> batchSubmit(@RequestBody BatchSubmitVO vo) {
        if (ToolUtil.isEmpty(vo) || ToolUtil.isEmpty(vo.getDetailList()) || ToolUtil.isEmpty(vo.getBillTypeCode())) {
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u53c2\u6570\u9519\u8bef");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                HashMap submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", this.baseHost + "/ejc-ztpcdc-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "\u56fe\u7eb8\u7b7e\u53d1" + detail.getId() + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse result = this.iBpmApi.doSubmit((Map)submitParam);
                if (result.isSuccess()) continue;
                return CommonResponse.error((String)result.getMsg());
            }
            return CommonResponse.success((String)"\u6279\u91cf\u63d0\u4ea4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }
}

