/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.enumUtils.PaperFlagEnum;
import com.ejianc.business.dc.enumUtils.PrintStatusEnum;
import com.ejianc.business.dc.mapper.DcExcelMapper;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.util.DetailIndexExcelReader;
import com.ejianc.business.dc.util.EJCDateUtil;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileImportVo;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="labsubItemService")
public class ExcelItemServiceImpl
implements IExcelItemService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRefApi iRefApi;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DcExcelMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IDcFiledistributeCenterService dcFiledistributeCenterService;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    public String formatDate(String inputDate) {
        String[] formats;
        for (String format : formats = new String[]{"yyyy-MM-dd", "yy-MM-dd", "yy-M-d", "yyyy/MM/dd", "yy/MM/dd", "yy/M/d", "yyyy.MM.dd", "yy.MM.dd", "yy.M.d"}) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            try {
                Date date = sdf.parse(inputDate);
                if (!date.after(new Date(0L)) || !date.before(new Date(Long.MAX_VALUE))) continue;
                SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
                return outputFormat.format(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<DcDrwgrpInfoImportVO> errorList = new ArrayList<DcDrwgrpInfoImportVO>();
        List<Object> rtErrorList = new ArrayList();
        ArrayList<DcDrwgrpInfoImportVO> success500TmpList = new ArrayList<DcDrwgrpInfoImportVO>(500);
        HashMap<String, String> dictionaryQueryMap = new HashMap<String, String>();
        HashMap selfCheckDcDrwgrp = new HashMap();
        HashMap<String, Integer> selfCheck = new HashMap<String, Integer>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            Map sourceUnitnameDataMap = this.mapper.queryMapSource().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                String drwgrpCode;
                Boolean flag = true;
                List datas = (List)result.get(i);
                DcDrwgrpInfoImportVO dcDrwgrpInfoVO = new DcDrwgrpInfoImportVO();
                StringBuilder errorMessage = new StringBuilder("");
                dcDrwgrpInfoVO.setId(IdWorker.getId());
                String projectName = (String)datas.get(0);
                if (ToolUtil.isNotEmpty(projectName)) {
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (ToolUtil.isNotEmpty(projectNameMap)) {
                        dcDrwgrpInfoVO.setProjectName((String)projectNameMap.get("name"));
                        dcDrwgrpInfoVO.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            dcDrwgrpInfoVO.setProjectId(Long.parseLong((String)id));
                        } else {
                            dcDrwgrpInfoVO.setProjectId((Long)id);
                        }
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            dcDrwgrpInfoVO.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                        } else {
                            dcDrwgrpInfoVO.setEngineeringTypeId((Long)engineeringTypeId);
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]" + projectName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                }
                if (ToolUtil.isEmpty(drwgrpCode = (String)datas.get(1))) {
                    errorMessage.append("[\u5377\u518c\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpCode(drwgrpCode);
                String drwgrpName = (String)datas.get(2);
                if (ToolUtil.isEmpty(drwgrpName)) {
                    errorMessage.append("[\u5377\u518c\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpName(drwgrpName);
                String drwgrpVsn = (String)datas.get(3);
                if (ToolUtil.isEmpty(drwgrpVsn)) {
                    errorMessage.append("[\u5377\u518c\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrwgrpInfoVO.setDrwgrpVsn(drwgrpVsn);
                String drwgrpTypeName = (String)datas.get(4);
                CommonResponse drwgrpTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("dc_drwgrp_type");
                if (StringUtils.isBlank((CharSequence)drwgrpTypeName)) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u522b]").append(drwgrpTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else if (!drwgrpTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)drwgrpTypeDefdoc.getData()))) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u522b]").append(drwgrpTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)drwgrpTypeDefdoc.getData()).stream().filter(a -> drwgrpTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    dcDrwgrpInfoVO.setDrwgrpType(defdocDetailId);
                }
                dcDrwgrpInfoVO.setTransferCode((String)datas.get(5));
                String drawArriveDateStr = (String)datas.get(6);
                if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                    Date parse = EJCDateUtil.parseDate(drawArriveDateStr = this.formatDate(drawArriveDateStr), "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcDrwgrpInfoVO.setDrawArriveDate(parse);
                    } else {
                        errorMessage.append("[\u5230\u56fe\u65e5\u671f]" + drawArriveDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u5230\u56fe\u65e5\u671f]\u4e3a\u7a7a;");
                    flag = false;
                }
                String sourceUnitname = (String)datas.get(7);
                if (ToolUtil.isNotEmpty(sourceUnitname)) {
                    Map sourceUnitnameMap = (Map)sourceUnitnameDataMap.get(sourceUnitname);
                    if (ToolUtil.isNotEmpty(sourceUnitnameMap)) {
                        dcDrwgrpInfoVO.setSourceUnitname((String)sourceUnitnameMap.get("name"));
                        Object id = sourceUnitnameMap.get("id");
                        if (id instanceof String) {
                            dcDrwgrpInfoVO.setSourceUnitid(Long.parseLong((String)sourceUnitnameMap.get("id")));
                        } else {
                            dcDrwgrpInfoVO.setSourceUnitid((Long)sourceUnitnameMap.get("id"));
                        }
                    } else {
                        errorMessage.append("[\u8bbe\u8ba1\u5355\u4f4d]" + sourceUnitname + ":\u53c2\u7167\u9519\u8bef;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u8bbe\u8ba1\u5355\u4f4d]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drwgrpNum = (String)datas.get(8);
                try {
                    JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue((String)(dcDrwgrpInfoVO.getEngineeringTypeId() + ""), (String)"support-defdoc");
                    if ("\u706b\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name")) && ToolUtil.isNotEmpty(drwgrpNum)) {
                        int i1 = Integer.parseInt(drwgrpNum);
                        dcDrwgrpInfoVO.setDrwgrpNum(i1);
                        dcDrwgrpInfoVO.setSurplusNum(i1);
                    } else if ("\u6838\u7535".equals(((JSONObject)specialtyReferValue.get(0)).get((Object)"name"))) {
                        dcDrwgrpInfoVO.setDrwgrpNum(0);
                        dcDrwgrpInfoVO.setSurplusNum(0);
                    }
                }
                catch (Exception e3) {
                    errorMessage.append("[\u5377\u518c\u5957\u6570]").append(sourceUnitname).append(":\u6821\u9a8c\u662f\u5426\u706b\u7535\u6216\u6838\u7535 \u53c2\u7167\u9519\u8bef;");
                }
                dcDrwgrpInfoVO.setRemarks((String)datas.get(9));
                String specialtyName = (String)datas.get(10);
                if (StringUtils.isBlank((CharSequence)specialtyName)) {
                    // empty if block
                }
                if (ToolUtil.isNotEmpty(specialtyName)) {
                    List data;
                    dictionaryQueryMap.put("projectId", dcDrwgrpInfoVO.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "specialty");
                    CommonResponse specialtyCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (specialtyCommonResponse.isSuccess() && (data = (List)specialtyCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u4e13\u4e1a]").append(specialtyName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            dcDrwgrpInfoVO.setSpecialty(dataDictionaryVO.getId());
                        }
                    }
                }
                dcDrwgrpInfoVO.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(dcDrwgrpInfoVO.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                dcDrwgrpInfoVO.setOrgId((Long)stringStringMap.get("orgId"));
                dcDrwgrpInfoVO.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                dcDrwgrpInfoVO.setOrgName(((OrgVO)orgVO.getData()).getName());
                dcDrwgrpInfoVO.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                dcDrwgrpInfoVO.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                Integer integer = (Integer)selfCheck.get(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn());
                if (ToolUtil.isNotEmpty(integer)) {
                    errorMessage.append("excel\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e\u4e0e\u7b2c" + integer + "\u884c\u91cd\u590d;");
                    flag = false;
                } else {
                    selfCheck.put(dcDrwgrpInfoVO.getProjectId() + dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn(), i + 2);
                }
                if (flag.booleanValue()) {
                    success500TmpList.add(dcDrwgrpInfoVO);
                    if (success500TmpList.size() != 500) continue;
                    List dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                    List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = this.dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                        dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                            DcDrwgrpInfoImportVO map = (DcDrwgrpInfoImportVO)BeanMapper.map((Object)el, DcDrwgrpInfoImportVO.class);
                            selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                        });
                    }
                    success500TmpList.stream().forEach(el -> {
                        DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = (DcDrwgrpInfoImportVO)selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                        if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                            errorMessage.append("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                            el.setErrorMessage(errorMessage.toString());
                            errorList.add((DcDrwgrpInfoImportVO)el);
                        } else {
                            successList.add(el);
                        }
                    });
                    success500TmpList = new ArrayList(500);
                    continue;
                }
                dcDrwgrpInfoVO.setErrorMessage(errorMessage.toString());
                errorList.add(dcDrwgrpInfoVO);
            }
            if (ToolUtil.isNotEmpty(success500TmpList)) {
                List dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = this.dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)) {
                    dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                        DcDrwgrpInfoImportVO map = (DcDrwgrpInfoImportVO)BeanMapper.map((Object)el, DcDrwgrpInfoImportVO.class);
                        selfCheckDcDrwgrp.put(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                    });
                }
                success500TmpList.stream().forEach(el -> {
                    DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = (DcDrwgrpInfoImportVO)selfCheckDcDrwgrp.get(el.getProjectId() + el.getDrwgrpCode() + el.getDrwgrpVsn());
                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)) {
                        el.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                        errorList.add((DcDrwgrpInfoImportVO)el);
                    } else {
                        successList.add(el);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrwgrpInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        return success;
    }

    @Override
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<DcDrawInfoImportVO> errorList = new ArrayList<DcDrawInfoImportVO>();
        List<Object> rtErrorList = new ArrayList();
        ArrayList<DcDrawInfoImportVO> success500TmpList = new ArrayList<DcDrawInfoImportVO>(500);
        HashMap<String, Integer> selfCheck = new HashMap<String, Integer>();
        HashMap<String, DcDrwgrpInfoEntity> selfCheckDb = new HashMap<String, DcDrwgrpInfoEntity>();
        ArrayList<DcDrwgrpInfoEntity> selfCheckDbList = new ArrayList<DcDrwgrpInfoEntity>();
        HashMap dcDrwgrpMap = new HashMap();
        StringBuilder comStr = new StringBuilder();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                Integer integer;
                DcDrwgrpInfoEntity dcDrwgrpInfoEntity;
                Boolean flag = true;
                List datas = (List)result.get(i);
                DcDrawInfoImportVO dcDrawInfoVO = new DcDrawInfoImportVO();
                StringBuilder errorMessage = new StringBuilder("");
                dcDrawInfoVO.setId(IdWorker.getId());
                dcDrawInfoVO.setPrintStatus(PrintStatusEnum.PRINT.getCode());
                dcDrawInfoVO.setCheckState("N");
                String projectName = (String)datas.get(0);
                if (ToolUtil.isNotEmpty(projectName)) {
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (ToolUtil.isNotEmpty(projectNameMap)) {
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            dcDrawInfoVO.setProjectId(Long.parseLong((String)id));
                        } else {
                            dcDrawInfoVO.setProjectId((Long)id);
                        }
                        dcDrawInfoVO.setProjectCode((String)projectNameMap.get("code"));
                        dcDrawInfoVO.setProjectName((String)projectNameMap.get("name"));
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]" + projectName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u9879\u76ee\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drawCode = (String)datas.get(1);
                if (ToolUtil.isEmpty(drawCode)) {
                    errorMessage.append("[\u56fe\u7eb8\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawCode(drawCode);
                String drawName = (String)datas.get(2);
                if (ToolUtil.isEmpty(drawName)) {
                    errorMessage.append("[\u56fe\u7eb8\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawName(drawName);
                String drawVsn = (String)datas.get(3);
                if (ToolUtil.isEmpty(drawVsn)) {
                    errorMessage.append("[\u56fe\u7eb8\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrawVsn(drawVsn);
                String drwgrpCode = (String)datas.get(4);
                if (ToolUtil.isEmpty(drwgrpCode)) {
                    errorMessage.append("[\u5377\u518c\u7f16\u53f7]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrwgrpCode(drwgrpCode);
                String drwgrpVsn = (String)datas.get(5);
                if (ToolUtil.isEmpty(drwgrpVsn)) {
                    errorMessage.append("[\u5377\u518c\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                }
                dcDrawInfoVO.setDrwgrpVsn(drwgrpVsn);
                dcDrawInfoVO.setTransferCode((String)datas.get(6));
                String paperFlag = (String)datas.get(7);
                if (ToolUtil.isEmpty(paperFlag)) {
                    errorMessage.append("[\u662f\u5426\u7eb8\u8d28\u7248]\u4e3a\u7a7a;");
                    flag = false;
                } else if (ToolUtil.isEmpty((Object)PaperFlagEnum.getEnumByName(paperFlag))) {
                    errorMessage.append("[\u662f\u5426\u7eb8\u8d28\u7248]\u5fc5\u987b\u4e3a\u201c\u662f\u201d\u6216\u201c\u5426\u201d;");
                    flag = false;
                }
                dcDrawInfoVO.setPaperFlag(PaperFlagEnum.getEnumByName(paperFlag).getCode());
                String drawArriveDateStr = (String)datas.get(8);
                if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                    Date parse = EJCDateUtil.parseDate(drawArriveDateStr = this.formatDate(drawArriveDateStr), "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcDrawInfoVO.setDrawArriveDate(parse);
                    } else {
                        errorMessage.append("[\u5230\u56fe\u65e5\u671f]" + drawArriveDateStr + ":\u683c\u5f0f\u9519\u8bef;");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u5230\u56fe\u65e5\u671f]\u4e3a\u7a7a;");
                    flag = false;
                }
                String drawTypeName = (String)datas.get(9);
                CommonResponse drawTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("draw_type");
                if (StringUtils.isBlank((CharSequence)drawTypeName)) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u578b]").append(drawTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else if (!drawTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)drawTypeDefdoc.getData()))) {
                    errorMessage.append("[\u56fe\u7eb8\u7c7b\u578b]").append(drawTypeName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)drawTypeDefdoc.getData()).stream().filter(a -> drawTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    dcDrawInfoVO.setDrawType(defdocDetailId);
                }
                dcDrawInfoVO.setRowIndex(i + 2);
                if (ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpCode()) && ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpVsn()) && ToolUtil.isEmpty((Object)(dcDrwgrpInfoEntity = (DcDrwgrpInfoEntity)((Object)selfCheckDb.get(dcDrawInfoVO.getProjectId() + dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn()))))) {
                    DcDrwgrpInfoEntity dcDrwgrpInfoEntityTemp = new DcDrwgrpInfoEntity();
                    dcDrwgrpInfoEntityTemp.setProjectId(dcDrawInfoVO.getProjectId());
                    dcDrwgrpInfoEntityTemp.setDrwgrpCode(dcDrawInfoVO.getDrwgrpCode());
                    dcDrwgrpInfoEntityTemp.setDrwgrpVsn(dcDrawInfoVO.getDrwgrpVsn());
                    selfCheckDb.put(dcDrawInfoVO.getProjectId() + dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(), dcDrwgrpInfoEntityTemp);
                    selfCheckDbList.add(dcDrwgrpInfoEntityTemp);
                }
                if (ToolUtil.isNotEmpty(integer = (Integer)selfCheck.get(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn()))) {
                    errorMessage.append("excel\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e\u4e0e\u7b2c" + integer + "\u884c\u91cd\u590d;");
                    flag = false;
                } else {
                    selfCheck.put(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn(), i + 2);
                }
                if (flag.booleanValue()) {
                    success500TmpList.add(dcDrawInfoVO);
                    if (success500TmpList.size() != 500) continue;
                    HashMap dcDrawExist = new HashMap();
                    if (ToolUtil.isNotEmpty(selfCheckDbList)) {
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = this.dcDrwgrpInfoService.checkExist(selfCheckDbList);
                        selfCheckDbList = new ArrayList();
                        dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId()));
                    }
                    ArrayList<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                    success500TmpList.stream().forEach(es -> {
                        Long aLong = (Long)dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(aLong)) {
                            es.setErrorMessage("\u8be5\u56fe\u7eb8\u65e0\u5377\u518c\u4fe1\u606f;");
                        } else {
                            es.setDrwgrpId(aLong);
                            Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(es.getProjectId()));
                            es.setOrgId((Long)stringStringMap.get("orgId"));
                            es.setOrgName((String)stringStringMap.get("orgName"));
                            es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                            es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                            dcDrawInfoEntityList.add((DcDrawInfoEntity)((Object)BeanMapper.map((Object)es, DcDrawInfoEntity.class)));
                        }
                    });
                    if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                        List<DcDrawInfoEntity> dcDrawInfoEntityListDb = this.dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                        dcDrawInfoEntityListDb.stream().forEach(ce -> dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1));
                    }
                    success500TmpList.stream().forEach(ce -> {
                        if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                            if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                                ce.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                                errorList.add((DcDrawInfoImportVO)ce);
                            } else {
                                successList.add(ce);
                            }
                        } else {
                            errorList.add((DcDrawInfoImportVO)ce);
                        }
                    });
                    success500TmpList = new ArrayList(500);
                    continue;
                }
                dcDrawInfoVO.setErrorMessage(errorMessage.toString());
                errorList.add(dcDrawInfoVO);
            }
            if (ToolUtil.isNotEmpty(success500TmpList)) {
                HashMap dcDrawExist = new HashMap();
                if (ToolUtil.isNotEmpty(selfCheckDbList)) {
                    List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = this.dcDrwgrpInfoService.checkExist(selfCheckDbList);
                    dcDrwgrpInfoEntitiesDb.stream().forEach(ce -> dcDrwgrpMap.put(ce.getProjectId() + ce.getDrwgrpCode() + ce.getDrwgrpVsn(), ce.getId()));
                }
                ArrayList<DcDrawInfoEntity> dcDrawInfoEntityList = new ArrayList<DcDrawInfoEntity>();
                success500TmpList.stream().forEach(es -> {
                    Long aLong = (Long)dcDrwgrpMap.get(es.getProjectId() + es.getDrwgrpCode() + es.getDrwgrpVsn());
                    if (ToolUtil.isEmpty(aLong)) {
                        es.setErrorMessage("\u8be5\u56fe\u7eb8\u65e0\u5377\u518c\u4fe1\u606f;");
                    } else {
                        es.setDrwgrpId(aLong);
                        Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(es.getProjectId()));
                        es.setOrgId((Long)stringStringMap.get("orgId"));
                        es.setOrgCode((String)stringStringMap.get("orgCode"));
                        es.setOrgName((String)stringStringMap.get("orgName"));
                        es.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                        es.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                        es.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                        dcDrawInfoEntityList.add((DcDrawInfoEntity)((Object)BeanMapper.map((Object)es, DcDrawInfoEntity.class)));
                    }
                });
                if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
                    List<DcDrawInfoEntity> dcDrawInfoEntityListDb = this.dcDrawInfoService.checkExist(dcDrawInfoEntityList);
                    dcDrawInfoEntityListDb.stream().forEach(ce -> dcDrawExist.put(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn(), 1));
                }
                success500TmpList.stream().forEach(ce -> {
                    if (ToolUtil.isEmpty(ce.getErrorMessage())) {
                        if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpId() + ce.getDrawCode() + ce.getDrawVsn()))) {
                            ce.setErrorMessage("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u6570\u636e;");
                            errorList.add((DcDrawInfoImportVO)ce);
                        } else {
                            successList.add(ce);
                        }
                    } else {
                        errorList.add((DcDrawInfoImportVO)ce);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcDrawInfoImportVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        success.setMsg(comStr.toString());
        return success;
    }

    @Override
    public CommonResponse<JSONObject> excelSendFileImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ArrayList<DcSendFileImportVo> successList = new ArrayList<DcSendFileImportVo>();
        ArrayList<DcSendFileImportVo> errorList = new ArrayList<DcSendFileImportVo>();
        List<Object> rtErrorList = new ArrayList();
        boolean isFailed = false;
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u53d1\u6587\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            List centerList = this.dcFiledistributeCenterService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(DcFiledistributeCenterEntity::getFileSts, (Object)"Y")).eq(DcFiledistributeCenterEntity::getAttribute, (Object)"1474197986685751304"));
            Map centerDataMap = centerList.stream().collect(Collectors.toMap(e -> e.getFileCode(), Function.identity(), (e1, e2) -> e2));
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            Map sourceUnitnameDataMap = this.mapper.queryMapSource().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List employeeList = Lists.newArrayList();
            CommonResponse employeeResponse = this.iExternalApi.getMapAllEmployee();
            if (employeeResponse.isSuccess() && ListUtil.isNotEmpty((List)((List)employeeResponse.getData()))) {
                employeeList = (List)employeeResponse.getData();
            }
            Map employee = employeeList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List allDept = Lists.newArrayList();
            CommonResponse allDeptResponse = this.iExternalApi.queryAllDept();
            if (allDeptResponse.isSuccess()) {
                allDept = (List)allDeptResponse.getData();
            }
            Map allDeptMap = allDept.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")) + String.valueOf(e.get("org_id")), Function.identity(), (e1, e2) -> e2));
            this.logger.info("\u6240\u6709\u90e8\u95e8\u4fe1\u606f:" + JSON.toJSONString(allDeptMap));
            for (int i = 0; i < result.size(); ++i) {
                String principalItemName;
                Object data;
                String subentryActivitiesName;
                String mainActivitiesName;
                String sectionName;
                Object data2;
                String jobCodeName;
                String centerCode;
                String costFlag;
                String copyOrgName;
                String mgrpName;
                List data3;
                boolean[] flag = new boolean[]{true};
                List datas = (List)result.get(i);
                DcSendFileImportVo dcSendFileImportVo = new DcSendFileImportVo();
                StringBuilder errorMessage = new StringBuilder("");
                dcSendFileImportVo.setId(IdWorker.getId());
                String projectName = (String)datas.get(0);
                if (ToolUtil.isNotEmpty(projectName)) {
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (ToolUtil.isNotEmpty(projectNameMap)) {
                        dcSendFileImportVo.setProjectName((String)projectNameMap.get("name"));
                        dcSendFileImportVo.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            dcSendFileImportVo.setProjectId(Long.parseLong((String)id));
                        } else {
                            dcSendFileImportVo.setProjectId((Long)id);
                        }
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            dcSendFileImportVo.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                        } else {
                            dcSendFileImportVo.setEngineeringTypeId((Long)engineeringTypeId);
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]" + projectName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag[0] = false;
                    }
                }
                if (ToolUtil.isNotEmpty(dcSendFileImportVo.getProjectId())) {
                    Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(dcSendFileImportVo.getProjectId()));
                    CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                    if (!orgVO.isSuccess()) {
                        errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                        flag[0] = false;
                    }
                    dcSendFileImportVo.setOrgId((Long)stringStringMap.get("orgId"));
                    dcSendFileImportVo.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                    dcSendFileImportVo.setOrgName(((OrgVO)orgVO.getData()).getName());
                    dcSendFileImportVo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                    dcSendFileImportVo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                }
                dcSendFileImportVo.setFileCode((String)datas.get(1));
                dcSendFileImportVo.setFileInternalCode((String)datas.get(2));
                String fileName = (String)datas.get(3);
                if (ToolUtil.isEmpty(fileName)) {
                    errorMessage.append("[\u6587\u4ef6\u540d\u79f0]\u4e3a\u7a7a;");
                    flag[0] = false;
                }
                dcSendFileImportVo.setFileName(fileName);
                String fileVsn = (String)datas.get(4);
                if (ToolUtil.isEmpty(fileVsn)) {
                    errorMessage.append("[\u7248\u672c]\u4e3a\u7a7a;");
                    flag[0] = false;
                }
                dcSendFileImportVo.setFileVsn(fileVsn);
                String sendDateStr = (String)datas.get(5);
                if (ToolUtil.isNotEmpty(sendDateStr)) {
                    Date parse = EJCDateUtil.parseDate(sendDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcSendFileImportVo.setSendDate(parse);
                    } else {
                        errorMessage.append("[\u53d1\u6587\u65e5\u671f]" + sendDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag[0] = false;
                    }
                } else {
                    errorMessage.append("[\u53d1\u6587\u65e5\u671f]\u4e3a\u7a7a;");
                    flag[0] = false;
                }
                String submitType = (String)datas.get(6);
                CommonResponse drwgrpTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("SUBMIT_TYPE");
                if (StringUtils.isBlank((CharSequence)submitType)) {
                    errorMessage.append("[\u62a5\u9001\u7c7b\u578b]").append(submitType).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag[0] = false;
                } else if (!drwgrpTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)drwgrpTypeDefdoc.getData()))) {
                    errorMessage.append("[\u62a5\u9001\u7c7b\u578b]").append(submitType).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                    flag[0] = false;
                } else {
                    Long defdocDetailId = ((List)drwgrpTypeDefdoc.getData()).stream().filter(a -> submitType.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    String defdocDetailCode = ((List)drwgrpTypeDefdoc.getData()).stream().filter(a -> submitType.equals(a.getName())).map(DefdocDetailVO::getCode).findFirst().orElse(null);
                    dcSendFileImportVo.setSubmitType(defdocDetailId);
                    dcSendFileImportVo.setSubmitTypeCode(defdocDetailCode);
                }
                String attribute = (String)datas.get(7);
                List<Map> maps = this.dcFiledistributeCenterService.selectAttributeByPid("1474197986685751299");
                if (StringUtils.isBlank((CharSequence)attribute)) {
                    errorMessage.append("[\u6587\u4ef6\u5c5e\u6027]").append(attribute).append(":\u9519\u8bef;");
                    flag[0] = false;
                } else if (ToolUtil.isEmpty(maps)) {
                    errorMessage.append("[\u6587\u4ef6\u5c5e\u6027]").append(attribute).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                    flag[0] = false;
                } else {
                    Map attributeMap = maps.stream().filter(a -> attribute.equals(a.get("category_name"))).findFirst().orElse(null);
                    if (attributeMap == null) {
                        errorMessage.append("[\u6587\u4ef6\u5c5e\u6027]").append(attribute).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    } else {
                        dcSendFileImportVo.setAttribute((Long)attributeMap.get("id"));
                    }
                }
                String filetype = (String)datas.get(8);
                if (dcSendFileImportVo.getAttribute() != null && dcSendFileImportVo.getAttribute() != 0L) {
                    List<Map> maps1 = this.dcFiledistributeCenterService.selectAttributeByPid(dcSendFileImportVo.getAttribute() + "");
                    if (StringUtils.isBlank((CharSequence)filetype)) {
                        errorMessage.append("[\u6587\u4ef6\u7c7b\u578b]").append(filetype).append(":\u9519\u8bef;");
                        flag[0] = false;
                    } else if (ToolUtil.isEmpty(maps1)) {
                        errorMessage.append("[\u6587\u4ef6\u7c7b\u578b]").append(filetype).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    } else {
                        Map filetypeMap = maps1.stream().filter(a -> filetype.equals(a.get("category_name"))).findFirst().orElse(null);
                        if (filetypeMap == null) {
                            errorMessage.append("[\u6587\u4ef6\u7c7b\u578b]").append(filetype).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        } else {
                            dcSendFileImportVo.setFiletype((Long)filetypeMap.get("id"));
                        }
                    }
                } else {
                    errorMessage.append("[\u6587\u4ef6\u7c7b\u578b]").append(attribute).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                    flag[0] = false;
                }
                String unitProjCodeName = (String)datas.get(9);
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("projectId", dcSendFileImportVo.getProjectId() + "");
                queryMap.put("categoryCode", "gcdm");
                CommonResponse unitProjCodeIdResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                if (unitProjCodeIdResponse.isSuccess() && (data3 = (List)unitProjCodeIdResponse.getData()) != null) {
                    DataDictionaryVO dataDictionaryVO = data3.stream().filter(a -> unitProjCodeName.equals(a.getDictionaryName())).findFirst().orElse(new DataDictionaryVO());
                    dcSendFileImportVo.setUnitProjCodeId(dataDictionaryVO.getId());
                    dcSendFileImportVo.setUnitProjCode(dataDictionaryVO.getDictionaryName());
                    dcSendFileImportVo.setUnitProjCode(dataDictionaryVO.getDictionaryCode());
                }
                if (ToolUtil.isEmpty(mgrpName = (String)datas.get(10))) {
                    errorMessage.append("[\u673a\u7ec4]\u4e3a\u7a7a;");
                    flag[0] = false;
                } else {
                    queryMap.put("categoryCode", "mgrp");
                    CommonResponse mgrpResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (mgrpResponse.isSuccess()) {
                        List data4 = (List)mgrpResponse.getData();
                        if (data4 != null) {
                            DataDictionaryVO dataDictionaryVO = data4.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u673a\u7ec4]").append(mgrpName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setMgrp(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u673a\u7ec4]").append(mgrpName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String submitOrgName = (String)datas.get(11);
                if (ToolUtil.isNotEmpty(submitOrgName)) {
                    String[] split = submitOrgName.split(",");
                    List submitOrgMapList = Arrays.stream(split).map(a -> {
                        Map submitOrgMap = (Map)sourceUnitnameDataMap.get(a);
                        if (submitOrgMap == null) {
                            errorMessage.append("[\u4e3b\u9001\u5355\u4f4d/\u90e8\u95e8]").append((String)a).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        return submitOrgMap;
                    }).collect(Collectors.toList());
                    String ids = StringUtils.join((Iterable)submitOrgMapList.stream().map(a -> a.get("id")).collect(Collectors.toList()), (String)",");
                    String names = StringUtils.join((Iterable)submitOrgMapList.stream().map(a -> a.get("name")).collect(Collectors.toList()), (String)",");
                    dcSendFileImportVo.setSubmitOrgId(ids);
                    dcSendFileImportVo.setSubmitOrgName(names);
                    dcSendFileImportVo.setSubmitOrgCode(ids);
                }
                if (ToolUtil.isNotEmpty(copyOrgName = (String)datas.get(12))) {
                    String[] split = copyOrgName.split(",");
                    List copyOrgMapList = Arrays.stream(split).map(a -> {
                        Map copyOrgMap = (Map)sourceUnitnameDataMap.get(a);
                        if (copyOrgMap == null) {
                            errorMessage.append("[\u6284\u9001\u5355\u4f4d/\u90e8\u95e8]").append((String)a).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        return copyOrgMap;
                    }).collect(Collectors.toList());
                    String ids = StringUtils.join((Iterable)copyOrgMapList.stream().map(a -> a.get("id")).collect(Collectors.toList()), (String)",");
                    String names = StringUtils.join((Iterable)copyOrgMapList.stream().map(a -> a.get("name")).collect(Collectors.toList()), (String)",");
                    dcSendFileImportVo.setCopyOrgId(ids);
                    dcSendFileImportVo.setCopyOrgName(names);
                    dcSendFileImportVo.setCopyOrgCode(ids);
                }
                String upgradeStateName = (String)datas.get(13);
                CommonResponse upgradeStateDefdoc = this.iDefdocApi.getDefDocByDefCode("dc_fw_upgrade_state");
                if (!StringUtils.isBlank((CharSequence)upgradeStateName)) {
                    if (!upgradeStateDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)upgradeStateDefdoc.getData()))) {
                        errorMessage.append("[\u5347\u7248\u72b6\u6001]").append(upgradeStateName).append(":\u81ea\u5b9a\u4e49\u6863\u6848\u9519\u8bef;");
                        flag[0] = false;
                    } else {
                        Long defdocDetailId = ((List)upgradeStateDefdoc.getData()).stream().filter(a -> upgradeStateName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                        dcSendFileImportVo.setUpgradeState(defdocDetailId);
                    }
                }
                if (ToolUtil.isNotEmpty(costFlag = (String)datas.get(14)) && "\u662f".equals(costFlag)) {
                    dcSendFileImportVo.setCostFlag(true);
                } else if (ToolUtil.isNotEmpty(costFlag) && "\u5426".equals(costFlag)) {
                    dcSendFileImportVo.setCostFlag(false);
                }
                String secretFlag = (String)datas.get(15);
                if (ToolUtil.isNotEmpty(secretFlag) && "\u662f".equals(secretFlag)) {
                    dcSendFileImportVo.setSecretFlag(true);
                } else if (ToolUtil.isNotEmpty(secretFlag) && "\u5426".equals(secretFlag)) {
                    dcSendFileImportVo.setSecretFlag(false);
                }
                String needReplyFlag = (String)datas.get(16);
                if (ToolUtil.isNotEmpty(needReplyFlag) && "\u662f".equals(needReplyFlag)) {
                    dcSendFileImportVo.setSecretFlag(true);
                } else if (ToolUtil.isNotEmpty(needReplyFlag) && "\u5426".equals(needReplyFlag)) {
                    dcSendFileImportVo.setSecretFlag(false);
                }
                String needReplyDate = (String)datas.get(17);
                if (ToolUtil.isNotEmpty(needReplyDate)) {
                    Date parse = EJCDateUtil.parseDate(needReplyDate, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        dcSendFileImportVo.setNeedReplyDate(parse);
                    } else {
                        errorMessage.append("[\u9700\u56de\u590d\u65e5\u671f]" + needReplyDate + ":\u683c\u5f0f\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                if (ToolUtil.isNotEmpty(centerCode = (String)datas.get(18))) {
                    DcFiledistributeCenterEntity dcFiledistributeCenterEntity = (DcFiledistributeCenterEntity)((Object)centerDataMap.get(centerCode));
                    if (dcFiledistributeCenterEntity == null) {
                        errorMessage.append("[\u56de\u590d\u6536\u6587\u7f16\u53f7]" + needReplyDate + ":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    } else {
                        dcSendFileImportVo.setCenterId(dcFiledistributeCenterEntity.getId());
                        dcSendFileImportVo.setReceiveFileCode(dcFiledistributeCenterEntity.getFileCode());
                    }
                }
                if (ToolUtil.isNotEmpty(jobCodeName = (String)datas.get(19))) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("categoryName", jobCodeName);
                    CommonResponse mapCommonResponse = this.billCodeRuleApi.materialClassificationTree(map);
                    if (mapCommonResponse.isSuccess() && ToolUtil.isNotEmpty(data2 = (Map)mapCommonResponse.getData())) {
                        Long id = (Long)data2.get("name");
                        dcSendFileImportVo.setJobCode(id);
                    }
                }
                if (!ToolUtil.isEmpty(sectionName = (String)datas.get(20))) {
                    queryMap.put("categoryCode", "bidsection");
                    CommonResponse sectionResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (sectionResponse.isSuccess()) {
                        data2 = (List)sectionResponse.getData();
                        if (data2 != null) {
                            DataDictionaryVO dataDictionaryVO = data2.stream().filter(a -> sectionName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u6807\u6bb5]").append(sectionName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setBidsection(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u6807\u6bb5]").append(sectionName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String specialtyName = (String)datas.get(21);
                if (!ToolUtil.isEmpty(specialtyName)) {
                    queryMap.put("categoryCode", "specialty");
                    CommonResponse specialtyResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (specialtyResponse.isSuccess()) {
                        List data5 = (List)specialtyResponse.getData();
                        if (data5 != null) {
                            DataDictionaryVO dataDictionaryVO = data5.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u4e13\u4e1a]").append(specialtyName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setSpecialty(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u4e13\u4e1a]").append(specialtyName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String sysName = (String)datas.get(22);
                if (!ToolUtil.isEmpty(sysName)) {
                    queryMap.put("categoryCode", "sys");
                    CommonResponse sysResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (sysResponse.isSuccess()) {
                        List data6 = (List)sysResponse.getData();
                        if (data6 != null) {
                            DataDictionaryVO dataDictionaryVO = data6.stream().filter(a -> sysName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u7cfb\u7edf]").append(sysName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setSys(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u7cfb\u7edf]").append(sysName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String subItemName = (String)datas.get(23);
                if (!ToolUtil.isEmpty(subItemName)) {
                    queryMap.put("categoryCode", "subItem");
                    CommonResponse subItemResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (subItemResponse.isSuccess()) {
                        List data7 = (List)subItemResponse.getData();
                        if (data7 != null) {
                            DataDictionaryVO dataDictionaryVO = data7.stream().filter(a -> subItemName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u5b50\u9879]").append(subItemName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setSubItem(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u5b50\u9879]").append(subItemName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String materialTypeName = (String)datas.get(24);
                if (!ToolUtil.isEmpty(materialTypeName)) {
                    queryMap.put("categoryCode", "materialType");
                    CommonResponse materialTypeResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (materialTypeResponse.isSuccess()) {
                        List data8 = (List)materialTypeResponse.getData();
                        if (data8 != null) {
                            DataDictionaryVO dataDictionaryVO = data8.stream().filter(a -> materialTypeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u6750\u6599\u7c7b\u578b]").append(materialTypeName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u6750\u6599\u7c7b\u578b]").append(materialTypeName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String deptName = (String)datas.get(25);
                if (!ToolUtil.isEmpty(deptName)) {
                    if (allDeptMap == null) {
                        errorMessage.append("[\u90e8\u95e8]").append(deptName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    } else {
                        Map stringObjectMap = (Map)allDeptMap.get(deptName + InvocationInfoProxy.getOrgId());
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u90e8\u95e8]").append(deptName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        } else {
                            dcSendFileImportVo.setDeptId(Long.parseLong(String.valueOf(stringObjectMap.get("id"))));
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(mainActivitiesName = (String)datas.get(26))) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("categoryName", mainActivitiesName);
                    CommonResponse mapCommonResponse = this.billCodeRuleApi.materialClassificationTree(map);
                    if (mapCommonResponse.isSuccess()) {
                        Map data9 = (Map)mapCommonResponse.getData();
                        if (ToolUtil.isNotEmpty(data9)) {
                            Long id = (Long)data9.get("name");
                            dcSendFileImportVo.setMainActivities(id);
                        } else {
                            errorMessage.append("[\u4e3b\u8981\u6d3b\u52a8]").append(mainActivitiesName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    } else {
                        errorMessage.append("[\u4e3b\u8981\u6d3b\u52a8]").append(mainActivitiesName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                if (ToolUtil.isNotEmpty(subentryActivitiesName = (String)datas.get(27))) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("categoryName", subentryActivitiesName);
                    CommonResponse mapCommonResponse = this.billCodeRuleApi.materialClassificationTree(map);
                    if (mapCommonResponse.isSuccess()) {
                        data = (Map)mapCommonResponse.getData();
                        if (ToolUtil.isNotEmpty(data)) {
                            Long id = (Long)data.get("name");
                            dcSendFileImportVo.setSubentryActivities(id);
                        } else {
                            errorMessage.append("[\u5206\u9879\u6d3b\u52a8]").append(subentryActivitiesName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    } else {
                        errorMessage.append("[\u5206\u9879\u6d3b\u52a8]").append(subentryActivitiesName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                if (!ToolUtil.isEmpty(principalItemName = (String)datas.get(28))) {
                    queryMap.put("categoryCode", "principalItem");
                    CommonResponse principalItemResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (principalItemResponse.isSuccess()) {
                        data = (List)principalItemResponse.getData();
                        if (data != null) {
                            DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> principalItemName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u4e3b\u8981\u79cd\u7c7b]").append(principalItemName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u4e3b\u8981\u79cd\u7c7b]").append(principalItemName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String cmitTypeCodeName = (String)datas.get(29);
                if (!ToolUtil.isEmpty(cmitTypeCodeName)) {
                    queryMap.put("categoryCode", "cmitTypeCode");
                    CommonResponse cmitTypeCodeResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (cmitTypeCodeResponse.isSuccess()) {
                        List data10 = (List)cmitTypeCodeResponse.getData();
                        if (data10 != null) {
                            DataDictionaryVO dataDictionaryVO = data10.stream().filter(a -> cmitTypeCodeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u901a\u8baf\u7c7b\u578b\u4ee3\u7801]").append(cmitTypeCodeName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u901a\u8baf\u7c7b\u578b\u4ee3\u7801]").append(cmitTypeCodeName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String receiverCmitCodeName = (String)datas.get(30);
                if (!ToolUtil.isEmpty(receiverCmitCodeName)) {
                    queryMap.put("categoryCode", "receiverCmitCode");
                    CommonResponse receiverCmitCodeResponse = this.billCodeRuleApi.queryUnitBumber(queryMap);
                    if (receiverCmitCodeResponse.isSuccess()) {
                        List data11 = (List)receiverCmitCodeResponse.getData();
                        if (data11 != null) {
                            DataDictionaryVO dataDictionaryVO = data11.stream().filter(a -> receiverCmitCodeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                            if (dataDictionaryVO == null) {
                                errorMessage.append("[\u6536\u6587\u65b9\u901a\u8baf\u4ee3\u7801]").append(receiverCmitCodeName).append(":\u83b7\u53d6\u5bf9\u5e94\u53c2\u7167\u9519\u8bef;");
                                flag[0] = false;
                            } else {
                                dcSendFileImportVo.setMaterialType(dataDictionaryVO.getId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u6536\u6587\u65b9\u901a\u8baf\u4ee3\u7801]").append(receiverCmitCodeName).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                        flag[0] = false;
                    }
                }
                String deptDirectorName = (String)datas.get(31);
                if (!ToolUtil.isEmpty(deptDirectorName)) {
                    String[] deptDirectorNameArray = deptDirectorName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : deptDirectorNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u90e8\u95e8\u4e3b\u4efb\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e3) {
                            this.logger.info(e3.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u90e8\u95e8\u4e3b\u4efb\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setDeptDirector(ids.toString());
                }
                String skillDirectorName = (String)datas.get(32);
                if (!ToolUtil.isEmpty(deptDirectorName)) {
                    String[] skillDirectorNameArray = skillDirectorName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : skillDirectorNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u6280\u672f\u7ec4\u957f]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e4) {
                            this.logger.info(e4.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u6280\u672f\u7ec4\u957f]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setSkillDirector(ids.toString());
                }
                String countersignName = (String)datas.get(33);
                if (!ToolUtil.isEmpty(countersignName)) {
                    String[] countersignNameArray = countersignName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : countersignNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u5ba1\u6838\uff08\u4f1a\u7b7e\uff09]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e5) {
                            this.logger.info(e5.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u5ba1\u6838\uff08\u4f1a\u7b7e\uff09]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setCountersign(ids.toString());
                }
                String branchDirectorName = (String)datas.get(34);
                if (!ToolUtil.isEmpty(branchDirectorName)) {
                    String[] branchDirectorNameArray = branchDirectorName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : branchDirectorNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u5206\u7ba1\u9886\u5bfc\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e6) {
                            this.logger.info(e6.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u5206\u7ba1\u9886\u5bfc\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setBranchDirector(ids.toString());
                }
                String projectDirectorName = (String)datas.get(35);
                if (!ToolUtil.isEmpty(projectDirectorName)) {
                    String[] projectDirectorNameArray = projectDirectorName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : projectDirectorNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u9879\u76ee\u7ecf\u7406]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e7) {
                            this.logger.info(e7.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u9879\u76ee\u7ecf\u7406]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setProjectDirector(ids.toString());
                }
                String documentName = (String)datas.get(36);
                if (!ToolUtil.isEmpty(documentName)) {
                    String[] documentNameArray = documentName.split(",");
                    StringBuilder ids = new StringBuilder("");
                    for (String s : documentNameArray) {
                        Map stringObjectMap = (Map)employee.get(s);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u6587\u6863\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                        try {
                            long id = Long.parseLong(stringObjectMap.get("id").toString());
                            if (ids.length() == 0) {
                                ids.append(id);
                                continue;
                            }
                            ids.append("," + id);
                        }
                        catch (Exception e8) {
                            this.logger.info(e8.getMessage(), (Object)s, (Object)JSONObject.toJSONString((Object)stringObjectMap));
                            errorMessage.append("[\u6587\u6863\u5ba1\u6838]").append(s).append(":\u83b7\u53d6\u53c2\u7167\u9519\u8bef;");
                            flag[0] = false;
                        }
                    }
                    dcSendFileImportVo.setDocument(ids.toString());
                }
                dcSendFileImportVo.setErrorMessage(errorMessage.toString());
                dcSendFileImportVo.setRowIndex(i + 2);
                if (flag[0]) {
                    successList.add(dcSendFileImportVo);
                    continue;
                }
                errorList.add(dcSendFileImportVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(DcSendFileImportVo::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        return success;
    }
}

