package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcDrwgrpInfoController;
import com.ejianc.business.dc.enumUtils.*;
import com.ejianc.business.dc.mapper.DcDrawdistributeInfoMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForDrwgrpMapper;
import com.ejianc.business.dc.mapper.DcDrawingApplyForMapper;
import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.service.*;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrawrecycleInfoVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoVO;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 卷册信息
 *
 * @author generator
 */
@Service("dcDrwgrpInfoService")
public class DcDrwgrpInfoServiceImpl extends BaseServiceImpl<DcDrwgrpInfoMapper, DcDrwgrpInfoEntity> implements IDcDrwgrpInfoService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private DcDrwgrpInfoController dcDrwgrpInfoController;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private DcDrawdistributeInfoMapper dcDrawdistributeInfoMapper;
    @Autowired
    private IDcDrawingApplyForService dcDrawingApplyForService;
    @Autowired
    private DcDrawingApplyForMapper dcDrawingApplyForMapper;
    @Autowired
    private IDcDrawingApplyForDrwgrpService dcDrawingApplyForDrwgrpService;
    @Autowired
    private DcDrawingApplyForDrwgrpMapper dcDrawingApplyForDrwgrpMapper;
    @Autowired
    private IDcDrawingApplyForDrwgrpDrawService dcDrawingApplyForDrwgrpDrawService;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private DcDrwgrpInfoMapper mapper;

    public List<DcDrwgrpInfoEntity> queryIdsDr(String drwgrp_code,String draw_code){
        return mapper.queryIdsDr(drwgrp_code,draw_code);
    }

    public IPage<DcDrwgrpInfoEntity> queryPage(List<String> ids, QueryParam param){
        Page<DcDrwgrpInfoEntity> pageParam = new Page<>(param.getPageIndex(), param.getPageSize());
        List<DcDrwgrpInfoEntity> list =
                mapper.page(ids,pageParam);

        // 将返回结果封装加分页参数中并返回
        pageParam.setRecords(list);
        return pageParam;
    }

    /**
     * 升版
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean upgrade(DcDrwgrpInfoEntity data) {
        //获取卷册数据   如果有签发信息  则生成回收单
        Long oldId = data.getId();

//        //查询旧的图册信息
        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.baseMapper.selectById(oldId);

        List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                .eq(DcDrawInfoEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                .eq(DcDrawInfoEntity::getDr, 0));
        /*
         * 新版数据添加
         */
        List<DcDrawInfoEntity> newDcDrawInfoList = data.getDcDrawInfoEntityList().stream().filter(
                a -> dcDrawInfoEntityList.stream().noneMatch(b -> b.getDrawCode().equals(a.getDrawCode()) && b.getDrawVsn().equals(a.getDrawVsn()))
        ).peek(a -> a.setPrintStatus(PrintStatusEnum.PRINT.getCode())).collect(Collectors.toList());
        List<DcDrawInfoEntity> oldDcDrawInfoList = data.getDcDrawInfoEntityList().stream().filter(
                a -> dcDrawInfoEntityList.stream().anyMatch(b -> b.getDrawCode().equals(a.getDrawCode()) && b.getDrawVsn().equals(a.getDrawVsn()))
        ).collect(Collectors.toList());
        newDcDrawInfoList.addAll(oldDcDrawInfoList);

        data.setCreateDeptId(sessionManager.getUserContext().getDeptId());
        data.setCreateUserCode(sessionManager.getUserContext().getUserCode());
        data.setIssueSts("0");
        data.setIssueUserCode(null);
        data.setIssueUserName(null);
        data.setDrwgrpSts(DrwgrpStsEnum.N.getCode());
        data.setId(null);
        data.setDcDrawInfoEntityList(newDcDrawInfoList);
        data.setUpgradeId(null);
        data.setUpgradeInnerCode(StringUtils.isEmpty(dcDrwgrpInfoEntity.getUpgradeInnerCode()) ? oldId+"" : dcDrwgrpInfoEntity.getUpgradeInnerCode()+"|"+oldId);
        DcDrwgrpInfoVO vo = BeanMapper.map(data, DcDrwgrpInfoVO.class);
        vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());

        //校验同一个项目下卷册名称，卷册编号，卷册版本不能重复
        QueryWrapper<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityQueryWrapper = new QueryWrapper();
        dcDrwgrpInfoEntityQueryWrapper.lambda().eq(ToolUtil.isNotEmpty(data.getProjectId()), DcDrwgrpInfoEntity::getProjectId, data.getProjectId())
                .eq(DcDrwgrpInfoEntity::getDr, 0)
                .eq(DcDrwgrpInfoEntity::getDrwgrpCode, data.getDrwgrpCode())
                .eq(DcDrwgrpInfoEntity::getDrwgrpName, data.getDrwgrpName())
                .eq(DcDrwgrpInfoEntity::getDrwgrpVsn, data.getDrwgrpVsn());
        List<DcDrwgrpInfoEntity> list = baseMapper.selectList(dcDrwgrpInfoEntityQueryWrapper);
        if (list.size() > 0) {
            throw new BusinessException("该卷册已添加");
        }
        vo.getDcDrawInfoEntityList().forEach(dcDrawInfoVO -> dcDrawInfoVO.setId(null));
        vo.getDcDrawdistributeRecordList().forEach(dcDrawdistributeRecordVO -> dcDrawdistributeRecordVO.setId(null));
        CommonResponse<DcDrwgrpInfoVO> response = dcDrwgrpInfoController.saveOrUpdate(vo);
        long newDrwgrpId = -1;
        if (response.isSuccess()) {
            newDrwgrpId = response.getData().getId();
            List<DcDrawInfoEntity> dcDrawInfoList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                    .eq(DcDrawInfoEntity::getDrwgrpId, oldId));
            Map<String, Long> collect = dcDrawInfoList.stream().collect(Collectors.toMap(dcDrawInfoEntity -> dcDrawInfoEntity.getDrawCode() + "_" + dcDrawInfoEntity.getDrawVsn(), DcDrawInfoEntity::getId));
            response.getData().getDcDrawInfoEntityList().forEach(dcDrawInfoVO -> {
                Long billId = collect.get(dcDrawInfoVO.getDrawCode() + "_" + dcDrawInfoVO.getDrawVsn());
                if (billId != null) {
                    iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                            String.valueOf(billId),
                            "BT230602000000005",
                            "otherAttachment",
                            String.valueOf(dcDrawInfoVO.getId()),
                            "BT230602000000005",
                            "otherAttachment");
                }
            });
        }
        //更新旧版本
        UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, oldId)
                .set(DcDrwgrpInfoEntity::getDrwgrpSts, DrwgrpStsEnum.N.getCode())
                .set(DcDrwgrpInfoEntity::getUpgradeTime, new Date())
                .set(DcDrwgrpInfoEntity::getUpgradeId, newDrwgrpId);
        int update = this.baseMapper.update(null, updateWrapper);
        if (update != 1) {
            throw new BusinessException("更新旧版数据失败!");
        }
        //更新旧版本的图纸签发数据
        UpdateWrapper<DcDrawdistributeInfoEntity> drawdistributeWrapper = new UpdateWrapper<>();
        drawdistributeWrapper.lambda()
                .eq(DcDrawdistributeInfoEntity::getDrwgrpId, oldId)
                .set(DcDrawdistributeInfoEntity::getDrwgrpSts, DrwgrpStsEnum.N.getCode());
        dcDrawdistributeInfoMapper.update(null, drawdistributeWrapper);

        /*
         * 图纸信息回收
         */
        // 获取新的图纸库-图纸信息
        List<DcDrawInfoEntity> newDcDrawInfoEntityList = data.getDcDrawInfoEntityList();

        //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
        List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList =
                dcDrawdistributeRecordService.list(
                        new QueryWrapper<DcDrawdistributeRecordEntity>()
                                .lambda()
                                .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId())
                                .eq(DcDrawdistributeRecordEntity::getDr, 0)
                );
        // 图纸回收的图纸申请信息
        List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = dcDrawingApplyForMapper.selectListByDrwgrpId(dcDrwgrpInfoEntity.getId());
        if (dcDrawdistributeRecordEntityList.size() > 0) {
            // 图纸回收-回收信息
            for (DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity : dcDrawdistributeRecordEntityList) {
                if (RecycleEnum.N.getCode().equals(dcDrawdistributeRecordEntity.getRecycleSts())) {
                    DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = BeanMapper.map(dcDrawdistributeRecordEntity, DcDrawrecycleDrwgrpinfoEntity.class);
                    dcDrawrecycleDrwgrpinfoEntity.setId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setDrawdistributeDrwgrpinfoId(dcDrawdistributeRecordEntity.getId());
                    dcDrawrecycleDrwgrpinfoEntity.setTenantId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateTime(null);
                    dcDrawrecycleDrwgrpinfoEntity.setCreateUserCode(null);
                    dcDrawrecycleDrwgrpinfoEntity.setUpdateTime(null);
                    dcDrawrecycleDrwgrpinfoEntity.setUpdateUserCode(null);
                    dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
                }
            }
        }
        // 回收信息（回收人信息）为空，不予回收
        if (ToolUtil.isEmpty(dcDrawrecycleDrwgrpinfoEntityList)) {
            return true;
        }
        // 图纸回收-图纸信息
        List<DcDrawrecycleDrawinfoEntity> dcDrawrecycleDrawinfoEntityList = new ArrayList<>();
        // 只回收更新图纸版本的图纸信息
        List<DcDrawInfoEntity> recycleDcDrawInfoEntityList = dcDrawInfoEntityList.stream()
                .filter(
                        a -> newDcDrawInfoEntityList.stream().noneMatch(b -> {
                            try {
                                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                                return
                                        a.getDrawCode().equals(b.getDrawCode())
                                                && a.getDrawVsn().equals(b.getDrawVsn())
                                                || DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"));
                            } catch (Exception e) {
                                return false;
                            }
                        })
                ).collect(Collectors.toList());
        /*
         * 循环设置回收的图纸信息数据值
         */
        for (DcDrawInfoEntity dcDrawInfoEntity : recycleDcDrawInfoEntityList) {
            DcDrawrecycleDrawinfoEntity dcDrawrecycleDrawinfoEntity = BeanMapper.map(dcDrawInfoEntity, DcDrawrecycleDrawinfoEntity.class);
            dcDrawrecycleDrawinfoEntity.setId(null);
            dcDrawrecycleDrawinfoEntity.setTenantId(null);
            dcDrawrecycleDrawinfoEntity.setCreateDeptId(null);
            dcDrawrecycleDrawinfoEntity.setCreateTime(null);
            dcDrawrecycleDrawinfoEntity.setCreateUserCode(null);
            dcDrawrecycleDrawinfoEntity.setUpdateTime(null);
            dcDrawrecycleDrawinfoEntity.setUpdateUserCode(null);
            dcDrawrecycleDrawinfoEntityList.add(dcDrawrecycleDrawinfoEntity);
        }
        // 设置图纸回收数据值
        DcDrawrecycleInfoEntity dcDrawrecycleInfoEntity = new DcDrawrecycleInfoEntity();
        dcDrawrecycleInfoEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        dcDrawrecycleInfoEntity.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
        dcDrawrecycleInfoEntity.setDrwgrpName(dcDrwgrpInfoEntity.getDrwgrpName());
        dcDrawrecycleInfoEntity.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
        dcDrawrecycleInfoEntity.setDrwgrpType(dcDrwgrpInfoEntity.getDrwgrpType());
        dcDrawrecycleInfoEntity.setSourceUnitid(dcDrwgrpInfoEntity.getSourceUnitid());
        dcDrawrecycleInfoEntity.setSourceUnitname(dcDrwgrpInfoEntity.getSourceUnitname());
        dcDrawrecycleInfoEntity.setMgrp(dcDrwgrpInfoEntity.getMgrp());
        dcDrawrecycleInfoEntity.setSpecialty(dcDrwgrpInfoEntity.getSpecialty());
        dcDrawrecycleInfoEntity.setSys(dcDrwgrpInfoEntity.getSys());
        dcDrawrecycleInfoEntity.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
        dcDrawrecycleInfoEntity.setIssueUserCode(dcDrwgrpInfoEntity.getIssueUserCode());
        dcDrawrecycleInfoEntity.setIssueUserName(dcDrwgrpInfoEntity.getIssueUserName());
        dcDrawrecycleInfoEntity.setIssueDate(dcDrwgrpInfoEntity.getIssueDate());
        dcDrawrecycleInfoEntity.setOrgCode(dcDrwgrpInfoEntity.getOrgCode());
        dcDrawrecycleInfoEntity.setOrgId(dcDrwgrpInfoEntity.getOrgId());
        dcDrawrecycleInfoEntity.setOrgName(dcDrwgrpInfoEntity.getOrgName());
        dcDrawrecycleInfoEntity.setParentOrgId(dcDrwgrpInfoEntity.getParentOrgId());
        dcDrawrecycleInfoEntity.setParentOrgCode(dcDrwgrpInfoEntity.getParentOrgCode());
        dcDrawrecycleInfoEntity.setParentOrgName(dcDrwgrpInfoEntity.getParentOrgName());
        dcDrawrecycleInfoEntity.setProjectCode(dcDrwgrpInfoEntity.getProjectCode());
        dcDrawrecycleInfoEntity.setProjectId(dcDrwgrpInfoEntity.getProjectId());
        dcDrawrecycleInfoEntity.setProjectName(dcDrwgrpInfoEntity.getProjectName());
        dcDrawrecycleInfoEntity.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
        dcDrawrecycleInfoEntity.setDcDrawrecycleDrawinfoList(dcDrawrecycleDrawinfoEntityList);
        dcDrawrecycleInfoEntity.setTenantId(null);
        dcDrawrecycleInfoEntity.setCreateDeptId(null);
        dcDrawrecycleInfoEntity.setCreateTime(null);
        dcDrawrecycleInfoEntity.setCreateUserCode(null);
        dcDrawrecycleInfoEntity.setUpdateTime(null);
        dcDrawrecycleInfoEntity.setUpdateUserCode(null);
        dcDrawrecycleInfoEntity.setDrwgrpId(newDrwgrpId);
        dcDrawrecycleInfoEntity.setEngineeringTypeId(dcDrwgrpInfoEntity.getEngineeringTypeId());
        // 转换对象类型
        DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(dcDrawrecycleInfoEntity, DcDrawrecycleInfoVO.class);
        // 保存
        dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
        // 循环更新图纸库-图纸签发信息的是否回收字段为“已回收”
        dcDrawrecycleDrwgrpinfoEntityList.forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                .eq(DcDrawdistributeRecordEntity::getId, dcDrawrecycleDrwgrpinfoEntity.getDrawdistributeDrwgrpinfoId())
                .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode())));
        return true;
    }

    /**
     * 图纸回收
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean annul(List<DcDrwgrpInfoEntity> entities) {
        //图纸库生成回收单
        entities.forEach(f -> {
            /*
             * 图纸信息回收
             */
            //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
            List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList =
                    dcDrawdistributeRecordService.list(
                            new QueryWrapper<DcDrawdistributeRecordEntity>()
                                    .lambda()
                                    .eq(DcDrawdistributeRecordEntity::getDrwgrpId, f.getId())
                                    .eq(DcDrawdistributeRecordEntity::getDr, 0)
                    );
            // 图纸回收的图纸申请信息
            List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = dcDrawingApplyForMapper.selectListByDrwgrpId(f.getId());
            if (dcDrawdistributeRecordEntityList.size() > 0) {
                // 图纸回收-回收信息
                for (DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity : dcDrawdistributeRecordEntityList) {
                    if (RecycleEnum.N.getCode().equals(dcDrawdistributeRecordEntity.getRecycleSts())) {
                        DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = BeanMapper.map(dcDrawdistributeRecordEntity, DcDrawrecycleDrwgrpinfoEntity.class);
                        dcDrawrecycleDrwgrpinfoEntity.setId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setDrawdistributeDrwgrpinfoId(dcDrawdistributeRecordEntity.getId());
                        dcDrawrecycleDrwgrpinfoEntity.setTenantId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateDeptId(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setCreateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateTime(null);
                        dcDrawrecycleDrwgrpinfoEntity.setUpdateUserCode(null);
                        dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
                    }
                }
            }
            // 回收信息（回收人信息）为空，不予回收
            if (ToolUtil.isEmpty(dcDrawrecycleDrwgrpinfoEntityList)) {
                return;
            }
            // 图纸回收-图纸信息
            List<DcDrawrecycleDrawinfoEntity> dcDrawrecycleDrawinfoEntityList = new ArrayList<>();
            // 图纸库图纸信息
            List<DcDrawInfoEntity> recycleDcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrwgrpId, f.getId())
                        .eq(DcDrawInfoEntity::getDr, 0));
            /*
             * 循环设置回收的图纸信息数据值
             */
            for (DcDrawInfoEntity dcDrawInfoEntity : recycleDcDrawInfoEntityList) {
                DcDrawrecycleDrawinfoEntity dcDrawrecycleDrawinfoEntity = BeanMapper.map(dcDrawInfoEntity, DcDrawrecycleDrawinfoEntity.class);
                dcDrawrecycleDrawinfoEntity.setId(null);
                dcDrawrecycleDrawinfoEntity.setTenantId(null);
                dcDrawrecycleDrawinfoEntity.setCreateDeptId(null);
                dcDrawrecycleDrawinfoEntity.setCreateTime(null);
                dcDrawrecycleDrawinfoEntity.setCreateUserCode(null);
                dcDrawrecycleDrawinfoEntity.setUpdateTime(null);
                dcDrawrecycleDrawinfoEntity.setUpdateUserCode(null);
                dcDrawrecycleDrawinfoEntityList.add(dcDrawrecycleDrawinfoEntity);
            }
            // 设置图纸回收数据值
            DcDrawrecycleInfoEntity dcDrawrecycleInfoEntity = new DcDrawrecycleInfoEntity();
            dcDrawrecycleInfoEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            dcDrawrecycleInfoEntity.setDrwgrpCode(f.getDrwgrpCode());
            dcDrawrecycleInfoEntity.setDrwgrpName(f.getDrwgrpName());
            dcDrawrecycleInfoEntity.setDrwgrpVsn(f.getDrwgrpVsn());
            dcDrawrecycleInfoEntity.setDrwgrpType(f.getDrwgrpType());
            dcDrawrecycleInfoEntity.setSourceUnitid(f.getSourceUnitid());
            dcDrawrecycleInfoEntity.setSourceUnitname(f.getSourceUnitname());
            dcDrawrecycleInfoEntity.setMgrp(f.getMgrp());
            dcDrawrecycleInfoEntity.setSpecialty(f.getSpecialty());
            dcDrawrecycleInfoEntity.setSys(f.getSys());
            dcDrawrecycleInfoEntity.setDrawArriveDate(f.getDrawArriveDate());
            dcDrawrecycleInfoEntity.setIssueUserCode(f.getIssueUserCode());
            dcDrawrecycleInfoEntity.setIssueUserName(f.getIssueUserName());
            dcDrawrecycleInfoEntity.setIssueDate(f.getIssueDate());
            dcDrawrecycleInfoEntity.setOrgCode(f.getOrgCode());
            dcDrawrecycleInfoEntity.setOrgId(f.getOrgId());
            dcDrawrecycleInfoEntity.setOrgName(f.getOrgName());
            dcDrawrecycleInfoEntity.setParentOrgId(f.getParentOrgId());
            dcDrawrecycleInfoEntity.setParentOrgCode(f.getParentOrgCode());
            dcDrawrecycleInfoEntity.setParentOrgName(f.getParentOrgName());
            dcDrawrecycleInfoEntity.setProjectCode(f.getProjectCode());
            dcDrawrecycleInfoEntity.setProjectId(f.getProjectId());
            dcDrawrecycleInfoEntity.setProjectName(f.getProjectName());
            dcDrawrecycleInfoEntity.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
            dcDrawrecycleInfoEntity.setDcDrawrecycleDrawinfoList(dcDrawrecycleDrawinfoEntityList);
            dcDrawrecycleInfoEntity.setTenantId(null);
            dcDrawrecycleInfoEntity.setCreateDeptId(null);
            dcDrawrecycleInfoEntity.setCreateTime(null);
            dcDrawrecycleInfoEntity.setCreateUserCode(null);
            dcDrawrecycleInfoEntity.setUpdateTime(null);
            dcDrawrecycleInfoEntity.setUpdateUserCode(null);
            dcDrawrecycleInfoEntity.setDrwgrpId(f.getId());
            dcDrawrecycleInfoEntity.setEngineeringTypeId(f.getEngineeringTypeId());
            // 转换对象类型
            DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(dcDrawrecycleInfoEntity, DcDrawrecycleInfoVO.class);
            // 保存
            dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
            // 循环更新图纸库-图纸签发信息的是否回收字段为“已回收”
            dcDrawrecycleDrwgrpinfoEntityList.forEach(dcDrawrecycleDrwgrpinfoEntity -> dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                    .eq(DcDrawdistributeRecordEntity::getId, dcDrawrecycleDrwgrpinfoEntity.getDrawdistributeDrwgrpinfoId())
                    .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode())));
            // 图纸库 修改卷册状态为“作废”
            update(
                    new UpdateWrapper<DcDrwgrpInfoEntity>()
                            .lambda()
                            .set(DcDrwgrpInfoEntity::getDrwgrpSts, DrwgrpStsEnum.S.getCode())
                            .eq(DcDrwgrpInfoEntity::getDr, 0)
                            .eq(DcDrwgrpInfoEntity::getId, f.getId())
            );
            // 图纸签发 修改卷册状态为“作废”
            dcDrawdistributeInfoService.update(
                    new UpdateWrapper<DcDrawdistributeInfoEntity>()
                            .lambda()
                            .set(DcDrawdistributeInfoEntity::getDrwgrpSts, DrwgrpStsEnum.S.getCode())
                            .eq(DcDrawdistributeInfoEntity::getDr, 0)
                            .eq(DcDrawdistributeInfoEntity::getDrwgrpId, f.getId())
            );
        });
        return true;
    }

    @Override
    public List<DcDrwgrpInfoEntity> checkExist(List<DcDrwgrpInfoEntity> entities) {

//            "excel数据与数据库对比存在重复的行"
            return baseMapper.checkDcDrwgrpInfoEntityList(entities);


    }

    @Override
    public List<BatchSubmitVO.BatchSubmitDetailVO> drawingIssuanceSave(List<Long> ids,String leaderShip) {
//        List<Map<String, Object>> roles = mapper.selectRoleByRoleName("领导审核-文档",false);
//        if (roles.size() == 0){
//            throw new BusinessException("角色参照错误");
//        }
//        long roleId = Long.parseLong(roles.get(0).get("id").toString());
//        logger.info("role:"+roleId);
        CommonResponse<List<RoleUserRelationVO>> roleUser = roleApi.getRoleUser(Arrays.asList(759117826224037952L,759093852077310032L), null);
        List<RoleUserRelationVO> user;
        if(roleUser.isSuccess()){
            user = roleUser.getData();
            logger.info(JSON.toJSONString(user));
        }else {
            throw new BusinessException("未找到签发角色用户");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitieList = queryList(param);
        List<BatchSubmitVO.BatchSubmitDetailVO> batchSubmitDetailList = Lists.newArrayList();
        for (DcDrwgrpInfoEntity entity : dcDrwgrpInfoEntitieList) {
            List<RoleUserRelationVO> collect = user.stream().filter(item -> item.getAuthOrgId().equals(entity.getParentOrgId()) || item.getAuthOrgId().equals(entity.getOrgId())).collect(Collectors.toList());
            String leaderShipIds = collect.stream()
                    .map(RoleUserRelationVO::getUserId)
                    .map(String::valueOf)
                    .collect(Collectors.joining(","));
            // 数据库中是否有该图纸签发信息
            StringBuilder sign = new StringBuilder();
            // 获取未打印的图纸签发信息ID
            Long disposeId = getDisposeId(sign, entity.getId());

            DcDrawdistributeInfoEntity dcDrawdistributeInfoSave;
            if (ToolUtil.isEmpty(disposeId)){
                // 设置新的图纸签发信息
                dcDrawdistributeInfoSave = setNewDcDrawdistributeInfo(sign.toString(), entity);
            } else {
                // 设置旧的图纸签发信息
                dcDrawdistributeInfoSave = setOldDcDrawdistributeInfo(entity.getId(), disposeId);
            }
            if (StringUtils.isNotEmpty(leaderShip)){
                dcDrawdistributeInfoSave.setLeadership(leaderShip);
            }else {
                if (StringUtils.isEmpty(leaderShipIds)){
                    leaderShipIds = null;
                    throw new BusinessException("未找到项目有权限用户");
                }
                dcDrawdistributeInfoSave.setLeadership(leaderShipIds);
            }
            // 保存
            dcDrawdistributeInfoService.saveOrUpdate(dcDrawdistributeInfoSave, false);
            // 更新图纸库子表的图纸信息对应数据为“已签发”
            dcDrawInfoService.update(new UpdateWrapper<DcDrawInfoEntity>().lambda()
                    .eq(DcDrawInfoEntity::getDrwgrpId, entity.getId())
                    .set(DcDrawInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode()));
            BatchSubmitVO.BatchSubmitDetailVO batchSubmitDetail = new BatchSubmitVO.BatchSubmitDetailVO();
            batchSubmitDetail.setId(dcDrawdistributeInfoSave.getId());
            batchSubmitDetail.setOrgId(entity.getOrgId());
            batchSubmitDetailList.add(batchSubmitDetail);
        }
        return batchSubmitDetailList;
    }

    @Override
    public void saveDrawInfo(Long drwgrpId, List<DcDrawInfoVO> dcDrawInfoList) {
        if (ToolUtil.isEmpty(drwgrpId) || ToolUtil.isEmpty(dcDrawInfoList)) {
            throw new RuntimeException("添加图纸失败！");
        }
        DcDrwgrpInfoEntity drwgrpInfo = getById(drwgrpId);
        dcDrawInfoList.forEach(a -> {
            a.setId(IdWorker.getId());
            a.setDrwgrpId(drwgrpId);
            a.setDrwgrpCode(drwgrpInfo.getDrwgrpCode());
            a.setDrwgrpVsn(drwgrpInfo.getDrwgrpVsn());
            a.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            a.setCheckState("N");
            a.setIssueSts(IssueStsEnum.ISSUE.getCode());
            a.setProjectId(drwgrpInfo.getProjectId());
            a.setProjectCode(drwgrpInfo.getProjectCode());
            a.setProjectName(drwgrpInfo.getProjectName());
            List<String> fileIds = Arrays.asList(a.getOtherAttachment().split(","));
            for (String fileId : fileIds) {
                CommonResponse<AttachmentVO> attachmentResponse = iAttachmentApi.queryDetail(fileId);
                if (!attachmentResponse.isSuccess()) {
                    continue;
                }
                AttachmentVO attachment = attachmentResponse.getData();
                attachment.setSourceId(a.getId());
                iAttachmentApi.updateFileInfo(attachment);
            }
        });
        List<DcDrawInfoEntity> dcDrawInfoEntityList = BeanMapper.mapList(dcDrawInfoList, DcDrawInfoEntity.class);
        boolean saveBoo = dcDrawInfoService.saveBatch(dcDrawInfoEntityList);
        if (!saveBoo) {
            throw new RuntimeException("添加图纸失败！");
        }
        List<DcDrawingApplyForDrwgrpEntity> dcDrawingApplyForDrwgrpList = dcDrawingApplyForDrwgrpMapper.selectList(
                new QueryWrapper<DcDrawingApplyForDrwgrpEntity>()
                        .lambda()
                        .eq(DcDrawingApplyForDrwgrpEntity::getDr, 0)
                        .eq(DcDrawingApplyForDrwgrpEntity::getDrwgrpId, drwgrpId)
        );
        if (ToolUtil.isEmpty(dcDrawingApplyForDrwgrpList)) {
            return;
        }
        Map<Long, DcDrawingApplyForDrwgrpEntity> drwgrpMap = dcDrawingApplyForDrwgrpList.stream().collect(Collectors.groupingBy(DcDrawingApplyForDrwgrpEntity::getPid, Collectors.collectingAndThen(Collectors.toList(), value -> value.get(0))));
        List<Long> applyForIdList = dcDrawingApplyForDrwgrpList.stream().map(DcDrawingApplyForDrwgrpEntity::getPid).collect(Collectors.toList());
        List<DcDrawingApplyForEntity> dcDrawingApplyForList = dcDrawingApplyForMapper.selectList(
                new QueryWrapper<DcDrawingApplyForEntity>()
                        .lambda()
                        .eq(DcDrawingApplyForEntity::getDr, 0)
                        .in(DcDrawingApplyForEntity::getId, applyForIdList)
        );
        if (ToolUtil.isEmpty(dcDrawingApplyForList)) {
            return;
        }
        dcDrawingApplyForList = dcDrawingApplyForList.stream().collect(
                Collectors.collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(DcDrawingApplyForEntity::getApplyForUserId))),
                        ArrayList::new)
        );
        for (DcDrawingApplyForEntity dcDrawingApplyFor : dcDrawingApplyForList) {
            DcDrawingApplyForDrwgrpEntity drwgrp = drwgrpMap.get(dcDrawingApplyFor.getId());
            List<DcDrawingApplyForDrwgrpDrawEntity> drawList = BeanMapper.mapList(dcDrawInfoList, DcDrawingApplyForDrwgrpDrawEntity.class);
            if (ToolUtil.isEmpty(dcDrawingApplyFor.getDistCode())) {
                drawList.forEach(a -> a.setPid(drwgrp.getId()));
                dcDrawingApplyForDrwgrpDrawService.saveBatch(drawList);
            } else {
                drwgrp.setId(IdWorker.getId());
                dcDrawingApplyFor.setId(null);
                dcDrawingApplyFor.setDcDrawingApplyForDrwgrpList(Collections.singletonList(drwgrp));
                dcDrawingApplyFor.setDistCode(null);
                dcDrawingApplyFor.setDistUserCode(null);
                dcDrawingApplyFor.setDistUserName(null);
                dcDrawingApplyFor.setCreateUserCode(null);
                dcDrawingApplyFor.setCreateTime(null);
                dcDrawingApplyForService.saveOrUpdate(dcDrawingApplyFor, false);
                drawList.forEach(a -> a.setPid(drwgrp.getId()));
                dcDrawingApplyForDrwgrpDrawService.saveBatch(drawList);
            }
        }
    }

    /**
     * 设置旧的图纸签发信息
     *
     * @param id        卷册ID
     * @param disposeId 图纸签发ID
     * @return 旧的图纸签发信息
     */
    private DcDrawdistributeInfoEntity setOldDcDrawdistributeInfo(Long id, Long disposeId) {
        DcDrawdistributeInfoEntity dcDrawdistributeInfoSave = dcDrawdistributeInfoService.getById(disposeId);
        List<DcDrawdistributeDrawinfoEntity> oldDcDrawdistributeDrawinfoList = dcDrawdistributeDrawinfoService.list(new QueryWrapper<DcDrawdistributeDrawinfoEntity>().lambda().eq(DcDrawdistributeDrawinfoEntity::getPid, dcDrawdistributeInfoSave.getId()));
        List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda().eq(DcDrawInfoEntity::getDrwgrpId, id).eq(DcDrawInfoEntity::getIssueSts, IssueStsEnum.ISSUE.getCode()));
        if (ToolUtil.isEmpty(dcDrawInfoEntityList)) {
            throw new RuntimeException("图纸信息已签发，请勿重复签发！卷册名称:" + dcDrawdistributeInfoSave.getDrwgrpName());
        }
        List<DcDrawdistributeDrawinfoEntity> newDcDrawdistributeDrawinfoList = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawdistributeDrawinfoEntity.class);
        for (DcDrawdistributeDrawinfoEntity newDcDrawdistributeDrawinfo : newDcDrawdistributeDrawinfoList) {
            Long oId = newDcDrawdistributeDrawinfo.getId();
            newDcDrawdistributeDrawinfo.setId(IdWorker.getId());
            iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(oId), "BT230602000000005", "otherAttachment",
                    String.valueOf(newDcDrawdistributeDrawinfo.getId()), "BT230602000000002", "otherAttachment"
            );
        }
        oldDcDrawdistributeDrawinfoList.addAll(newDcDrawdistributeDrawinfoList);
        dcDrawdistributeInfoSave.setDcDrawdistributeDrawinfoList(oldDcDrawdistributeDrawinfoList);
        return dcDrawdistributeInfoSave;
    }

    /**
     * 设置新的图纸签发信息
     *
     * @param sign   数据库中是否存在该签发信息
     * @param entity 图纸签发信息数据来源
     * @return 新的图纸签发信息
     */
    private DcDrawdistributeInfoEntity setNewDcDrawdistributeInfo(String sign, DcDrwgrpInfoEntity entity) {
        /*
         * 图纸签发（生成图纸签发信息）
         */
        // 主表
        DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity = BeanMapper.map(entity, DcDrawdistributeInfoEntity.class);
        dcDrawdistributeInfoEntity.setId(null);
        dcDrawdistributeInfoEntity.setCreateTime(null);
        dcDrawdistributeInfoEntity.setUpdateUserCode(null);
        dcDrawdistributeInfoEntity.setUpdateTime(null);
        dcDrawdistributeInfoEntity.setDr(null);
        dcDrawdistributeInfoEntity.setTenantId(null);
        dcDrawdistributeInfoEntity.setSyncEsFlag(null);
        dcDrawdistributeInfoEntity.setBillState(null);
        dcDrawdistributeInfoEntity.setVersion(null);
        dcDrawdistributeInfoEntity.setDrwgrpId(entity.getId());
        dcDrawdistributeInfoEntity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
        dcDrawdistributeInfoEntity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
        dcDrawdistributeInfoEntity.setDrwgrpSts(DrwgrpStsEnum.Y.getCode());
        dcDrawdistributeInfoEntity.setFlowState(TzFlowStateEnum.TWO.getCode());
        dcDrawdistributeInfoEntity.setFlowStateName(TzFlowStateEnum.TWO.getName());
        // 对应的图纸签发记录已存在，则把单据状态设置为审批通过
        if(ToolUtil.isNotEmpty(sign)){
            dcDrawdistributeInfoEntity.setBillState(3);
            dcDrawdistributeInfoEntity.setFlowState(TzFlowStateEnum.FIVE.getCode());
            dcDrawdistributeInfoEntity.setFlowStateName(TzFlowStateEnum.FIVE.getName());
        }
        // 图纸信息表-子表
        List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda().eq(DcDrawInfoEntity::getDrwgrpId, entity.getId()));
        List<DcDrawInfoEntity> newDcDrawInfo = Lists.newArrayList();
        /*
         * 1.每条数据的ID设置为空，并且把创建部门设置为主表的创建部门
         * 2.获取未打印的图纸信息
         */
        if (ToolUtil.isNotEmpty(dcDrawInfoEntityList)) {
            for (DcDrawInfoEntity dcDrawInfoEntity : dcDrawInfoEntityList) {
                Long oId = dcDrawInfoEntity.getId();
                dcDrawInfoEntity.setId(IdWorker.getId());
                dcDrawInfoEntity.setCreateDeptId(entity.getCreateDeptId());
                // 未打印判断
                if (PrintStatusEnum.PRINT.getCode().equals(dcDrawInfoEntity.getPrintStatus())) {
                    newDcDrawInfo.add(dcDrawInfoEntity);
                    iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                            String.valueOf(oId), "BT230602000000005", "otherAttachment",
                            String.valueOf(dcDrawInfoEntity.getId()), "BT230602000000002", "otherAttachment"
                    );
                }
            }
        }
        /*
         * 1.图纸库的图纸信息为空，并且有对应的图纸签发，则报错
         * 2.图纸库的图纸信息不为空，并且没有未打印的图纸信息，则报错
         */
        if ((ToolUtil.isEmpty(dcDrawInfoEntityList) && ToolUtil.isNotEmpty(sign)) || ToolUtil.isEmpty(newDcDrawInfo)) {
            throw new RuntimeException("图纸信息已签发，请勿重复签发！卷册名称:" + entity.getDrwgrpName());
        }
        List<DcDrawdistributeDrawinfoEntity> dcDrawdistributeDrawinfoEntitieList = BeanMapper.mapList(newDcDrawInfo, DcDrawdistributeDrawinfoEntity.class);
        dcDrawdistributeInfoEntity.setDcDrawdistributeDrawinfoList(dcDrawdistributeDrawinfoEntitieList);
        // 签发信息表-子表
        List<DcDrawdistributeRecordEntity> dcDrawdistributeRecordEntityList = dcDrawdistributeRecordService.list(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda().eq(DcDrawdistributeRecordEntity::getDrwgrpId, entity.getId()));
        List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = BeanMapper.mapList(dcDrawdistributeRecordEntityList, DcDrawdistributeDrwgrpinfoEntity.class);
        if (ToolUtil.isNotEmpty(dcDrawdistributeDrwgrpinfoEntityList)) {
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : dcDrawdistributeDrwgrpinfoEntityList) {
                dcDrawdistributeDrwgrpinfoEntity.setId(null);
                dcDrawdistributeDrwgrpinfoEntity.setPid(dcDrawdistributeInfoEntity.getId());
            }
            dcDrawdistributeInfoEntity.setDcDrawdistributeDrwgrpinfoEntityList(dcDrawdistributeDrwgrpinfoEntityList);
        }
        return dcDrawdistributeInfoEntity;
    }

    /**
     * 获取未打印的图纸签发信息ID
     *
     * @param sign     数据库中是否存在该签发信息
     * @param drwgrpId 卷册id
     * @return 图纸签发ID
     */
    private Long getDisposeId(StringBuilder sign, Long drwgrpId) {
        Long disposeId = null;
        List<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityList = dcDrawdistributeInfoService.list(
                new QueryWrapper<DcDrawdistributeInfoEntity>().lambda().eq(DcDrawdistributeInfoEntity::getDrwgrpId, drwgrpId)
                        .eq(DcDrawdistributeInfoEntity::getDr, "0")
        );
        if (ToolUtil.isEmpty(dcDrawdistributeInfoEntityList)) {
            dcDrawdistributeInfoEntityList = Lists.newArrayList();
        } else {
            sign.append("true");
        }
        for (DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity : dcDrawdistributeInfoEntityList) {
            if (ToolUtil.isEmpty(dcDrawdistributeInfoEntity.getDistCode())) {
                disposeId = dcDrawdistributeInfoEntity.getId();
            }
        }
        return disposeId;
    }
}
