package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.enumUtils.*;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.service.impl.DcDrawInfoServiceImpl;
import com.ejianc.business.dc.service.impl.DcDrwgrpInfoServiceImpl;
import com.ejianc.business.dc.service.impl.DcSendFileServiceImpl;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileImportVo;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 劳务分包档案
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("/excelImportService")
public class ExcelDemoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private IExcelItemService service;

    @Autowired
    private DcDrwgrpInfoServiceImpl dcDrwgrpInfoService;

    @Autowired
    private DcDrawInfoServiceImpl dcDrawInfoService;

    @Autowired
    private DcSendFileServiceImpl dcSendFileService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRefApi iRefApi;

    @Autowired
    private IDefdocApi iDefdocApi;

//    @Autowired
//    private IShareSubjectOrgApi subjectOrgApi;

    /**
     * 卷册信息导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDcDrwgrpInfo")
    @ResponseBody
    public void downloadDcDrwgrpInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "drwgrp-import.xlsx", "卷册信息导入模板");
    }

    /**
     * 图纸信息导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDcDrawInfo")
    @ResponseBody
    public void downloadDcDrawInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-import.xlsx", "图纸信息导入模板");
    }


    /**
     * TODO 校验
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     *     卷册
     */
    @RequestMapping(value = "/excelDcDrwgrpInfoImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {

        CommonResponse<JSONObject> response= service.excelDcDrwgrpInfoImport(request);
        return  response;

    }

    /**
     * TODO 校验
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     *     图纸
     */
    @RequestMapping(value = "/excelDcDrawInfoImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response= service.excelDcDrawInfoImport(request);
        return  response;
    }


    /**
     * TODO  保存
     * @param importVos
     * @return
     */
    @RequestMapping(value = "/saveImportExcelDcDrwgrpInfoItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrwgrpInfoItem(@RequestBody List<DcDrwgrpInfoImportVO> importVos) {

        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<DcDrwgrpInfoEntity> list = new ArrayList<>();
        List<DcDrawInfoEntity> drawInfoList = Lists.newArrayList();
        importVos.forEach(importVO -> {
            DcDrwgrpInfoEntity entity = BeanMapper.map(importVO, DcDrwgrpInfoEntity.class);
            entity.setId(IdWorker.getId());
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(sessionManager.getUserContext().getTenantid());
//            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            entity.setDrwgrpSts(DrwgrpStsEnum.N.getCode());
            entity.setIssueSts("0");
            entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
            entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
            list.add(entity);
            /*
             * 生成卷册默认的目录图纸信息
             */
            DcDrawInfoEntity drawInfo = new DcDrawInfoEntity();
            drawInfo.setDrwgrpId(entity.getId());
            drawInfo.setDrwgrpCode(entity.getDrwgrpCode());
            drawInfo.setDrwgrpVsn(entity.getDrwgrpVsn());
            drawInfo.setDrawCode(entity.getDrwgrpCode());
            drawInfo.setDrawName(entity.getDrwgrpName());
            drawInfo.setDrawVsn(entity.getDrwgrpVsn());
            drawInfo.setProjectId(entity.getProjectId());
            drawInfo.setProjectCode(entity.getProjectCode());
            drawInfo.setProjectName(entity.getProjectName());
            CommonResponse<List<DefdocDetailVO>> defdocDetailList = iDefdocApi.getDefDocByDefCode("draw_type");
            if (defdocDetailList.isSuccess() && ToolUtil.isNotEmpty(defdocDetailList.getData())) {
                Long defdocDetailId = defdocDetailList.getData().stream().filter(a -> "A".equals(a.getCode())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                drawInfo.setDrawType(defdocDetailId);
            }
            try {
                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(entity.getEngineeringTypeId() + "", "support-defdoc");
                if ("火电".equals(((JSONObject) specialtyReferValue.get(0)).get("name"))) {
                    drawInfo.setPaperFlag("Y");
                } else if ("核电".equals(((JSONObject) specialtyReferValue.get(0)).get("name"))) {
                    drawInfo.setPaperFlag("N");
                }
            } catch (Exception e) {
                return;
            }
            drawInfo.setDrawArriveDate(entity.getDrawArriveDate());
            drawInfo.setIssueSts(IssueStsEnum.ISSUE.getCode());
            drawInfo.setPrintStatus(PrintStatusEnum.PRINT.getCode());
            drawInfo.setCheckState("N");
            drawInfoList.add(drawInfo);
        });


        dcDrwgrpInfoService.saveBatch(list,list.size());
        // 保存卷册对应的目录图纸信息
        dcDrawInfoService.saveBatch(drawInfoList, drawInfoList.size());
        return CommonResponse.success("保存成功！");
    }





    /**
     * TODO  保存
     * @param importVos
     * @return
     */
    @RequestMapping(value = "/saveImportExcelDcDrawInfoItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrawInfoItem(@RequestBody List<DcDrawInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<DcDrawInfoEntity> list = new ArrayList<>();
        importVos.forEach(importVO -> {
            DcDrawInfoEntity entity = BeanMapper.map(importVO, DcDrawInfoEntity.class);
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(sessionManager.getUserContext().getTenantid());
            entity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            entity.setSyncEsFlag(0);
            entity.setIssueSts("0");
            list.add(entity);
        });
        dcDrawInfoService.saveBatch(list,list.size());
        return CommonResponse.success("保存成功！");
    }


    /**
     * 卷册信息导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDcSendFile")
    @ResponseBody
    public void downloadDcSendFile(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "sendFile-import.xlsx", "发文管理导入模板");
    }

    /**
     * 发文管理导入校验
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelSendFileImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelSendFileImport(HttpServletRequest request){
        CommonResponse<JSONObject> response = service.excelSendFileImport(request);
        return response;
    }

    /**
     * TODO  保存
     * @param importVos
     * @return
     */
    @RequestMapping(value = "/saveImportExcelDcSendFileItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcSendFileItem(@RequestBody List<DcSendFileImportVo> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<DcSendFileEntity> list = new ArrayList<>();
        importVos.forEach(importVO -> {
            DcSendFileEntity entity = BeanMapper.map(importVO, DcSendFileEntity.class);
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(sessionManager.getUserContext().getTenantid());
            entity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            entity.setSyncEsFlag(0);
            list.add(entity);
        });
        dcSendFileService.saveBatch(list,list.size());
        return CommonResponse.success("保存成功！");
    }
}
