package com.ejianc.business.dc.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 文件分发中心
 * 
 * @author generator
 * 
 */
@Mapper
public interface DcFiledistributeCenterMapper extends BaseCrudMapper<DcFiledistributeCenterEntity> {
    @Select("select id,category_name from `ejc-conbase`.ejc_conbase_contract_template_category a where a.pid = #{pid} and enable_status=1 and belong_org_id in('1502571152583692289',#{orgId})   order by sequence asc" )
    List<Map> selectAttributeByPid(@Param("pid") String pid,@Param("orgId")String orgId);
    @Select({"<script>",
            "select id,category_name from `ejc-conbase`.ejc_conbase_other_template_category a " +
            " where a.pid = #{pid} and a.enable_status = 1 " +
            "    and a.belong_org_id  in " +
            " <foreach collection='orgList' index='key' item='item'  open='(' close=')'  separator=','>" +
            "     #{item}" +
            " </foreach>" +
            " order by sequence asc "
            ," </script> "})
    List<Map> selectOtherAttributeByPid(@Param("pid") String pid,@Param("orgList")List<Long> orgList);
    @Select("select file_name,file_id from `ejc-conbase`.ejc_conbase_contract_template where category_id=#{id} and enable_status=1 and belong_org_id = #{orgId}" )
    List<Map> selectTemplateByCategoryId(@Param("id") String id,@Param("orgId")String orgId);
    @Select("select file_name,file_id from `ejc-conbase`.ejc_conbase_contract_template where pid='1474197986685751299' and enable_status=1 and belong_org_id = #{orgId}" )
    List<Map> selectAttribute(@Param("orgId")String orgId);

    @Select({"<script>",
            "select parent_org_code as projectCode,sum(security_number) as securityNum,sum(quality_number) as qualityNum from dc_filedistribute_center " +
                    "where dr = 0 and submit_type_code = 'D' " +
            "    and parent_org_code  in " +
                    " <foreach collection='codeList' index='key' item='item'  open='(' close=')'  separator=','>" +
                    "     #{item}" +
                    " </foreach>" +
                    " group by parent_org_code"
            ,"</script>"})
    List<Map> selectNumberByParentOrgCodes(@Param("codeList") List<String> codeList);
}
