package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcFiledistributeCenterMapper;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 文件分发中心
 *
 * @author generator
 */
@Service("dcFiledistributeCenterService")
public class DcFiledistributeCenterServiceImpl extends BaseServiceImpl<DcFiledistributeCenterMapper, DcFiledistributeCenterEntity> implements IDcFiledistributeCenterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DcFiledistributeCenterMapper dcFiledistributeCenterMapper;
    @Autowired
    IDcSendFileService iDcSendFileService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<Map> selectAttributeByPid(String pid) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Map> maps = dcFiledistributeCenterMapper.selectAttributeByPid(pid, String.valueOf(orgId));
        List<Long> orgList = new ArrayList<>();
        orgList.add(orgId);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {

        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return new ArrayList<>();
            }
            List<Long> list = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            if (list != null){
                orgList.addAll(list);
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<Map> maps1 = dcFiledistributeCenterMapper.selectOtherAttributeByPid(pid, orgList);
        maps.addAll(maps1);
        return maps;
    }

    @Override
    public List<Map> selectTemplateByCategoryId(String id) {
        Long orgId = InvocationInfoProxy.getOrgId();
        //查到的该项目模版数据
        List<Map> templateList = dcFiledistributeCenterMapper.selectTemplateByCategoryId(id, String.valueOf(orgId));
        if (ValidateUtil.isNotEmpty(templateList)) {
            return templateList;
        } else {
            //这里的orgId为主组织id
            return dcFiledistributeCenterMapper.selectTemplateByCategoryId(id, "1502571152583692289");
        }
    }

    @Override
    public List<Map> selectAttribute() {
        Long orgId = InvocationInfoProxy.getOrgId();
        //查到的该项目数据
        List<Map> templateList = dcFiledistributeCenterMapper.selectAttribute(String.valueOf(orgId));
        if (ValidateUtil.isNotEmpty(templateList)) {
            return templateList;
        } else {
            new BusinessException("未查到数据！！！");
        }
        return null;
    }

    /**
     * @description: 文件状态file_sts改为作废即可，同时将发文管理对应数据的文件状态file_sts改为作废
     * @author: chengminggao
     * @date: 2023/6/1 15:15
     * @param: [entity]
     * @return: boolean
     **/
    @Override
    public boolean cancel(DcFiledistributeCenterEntity entity) {
            this.update(new UpdateWrapper<DcFiledistributeCenterEntity>().lambda()
                    .eq(DcFiledistributeCenterEntity::getId,entity.getId())
                    .set(DcFiledistributeCenterEntity::getFileSts,"S"));
            if (ValidateUtil.isNotEmpty(entity.getSourceTable())&&ValidateUtil.isNotEmpty(entity.getSourceId())){
                if (entity.getSourceTable().equals("dc_send_file")){
                    iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
                            .eq(DcSendFileEntity::getId,entity.getId())
                            .set(DcSendFileEntity::getFileSts,"S"));
                }
            }else {
                new BusinessException("没有来源表");
            }
        return false;
    }

    /**
     * 将file_sts改为无效
     * @param entity
     * @return
     */
    public boolean expire(DcFiledistributeCenterEntity entity) {
        boolean b = this.update(new UpdateWrapper<DcFiledistributeCenterEntity>().lambda()
                .eq(DcFiledistributeCenterEntity::getId, entity.getId())
                .set(DcFiledistributeCenterEntity::getFileSts, "N"));
        return b;
    }

    @Override
    public List<Map> selectNumberByParentOrgCodes(List<String> codeList) {
        return dcFiledistributeCenterMapper.selectNumberByParentOrgCodes(codeList);
    }
}
