package com.ejianc.business.dc.util;

import com.ejianc.foundation.message.vo.PushMsgParameter;

/**
 * @ClassName MessageUtil
 * @Description 消息工具类
 * @Author WC
 * @Date 2023/8/1 10:56
 * @Version 1.0
 **/
public class MessageUtil {
    /**
     * 构造消息发送对象
     *
     * @param channel    消息通道
     * @param receivers  接收人IDs
     * @param msgType    消息类型：task(任务(旧))，notice(提醒(旧))，earlywarning(预警) bpmtask(审批待办消息)，bpmurge(流程催办提醒消息)，bpmpass(审批通过提醒消息)，bpmstop(流程终止提醒消息)，bpmunapprove(流程弃审提醒消息)， bpmreject(流程驳回提醒消息)，bpmcc(审批抄送提醒消息)，commentcc(评论抄送提醒消息)，elecsignwithdrawal(电子签章撤回提醒消息)， contractsign(合同签署待办提醒消息)，ordershelf(订单上架提醒消息)
     * @param subject    消息标题
     * @param content    消息内容
     * @param pcUrl      消息标题对应的url
     * @param tenantId   租户ID
     * @param sendUserId 消息发送人Id
     * @return 消息发送对象
     */
    public static PushMsgParameter getPushMsgParameter(String[] channel, String[] receivers, String msgType, String subject, String content, String pcUrl, String tenantId, Long sendUserId) {
        PushMsgParameter msgParameter = new PushMsgParameter();
        // 消息通道
        msgParameter.setChannel(channel);
        // 接收人IDs
        msgParameter.setReceivers(receivers);
        // 消息类型：task(任务(旧))，notice(提醒(旧))，earlywarning(预警) bpmtask(审批待办消息)，bpmurge(流程催办提醒消息)，bpmpass(审批通过提醒消息)，bpmstop(流程终止提醒消息)，bpmunapprove(流程弃审提醒消息)， bpmreject(流程驳回提醒消息)，bpmcc(审批抄送提醒消息)，commentcc(评论抄送提醒消息)，elecsignwithdrawal(电子签章撤回提醒消息)， contractsign(合同签署待办提醒消息)，ordershelf(订单上架提醒消息)
        msgParameter.setMsgType(msgType);
        // 消息标题
        msgParameter.setSubject(subject);
        // 消息内容
        msgParameter.setContent(content);
        // 消息标题对应的url
        msgParameter.setPcUrl(pcUrl);
        // 租户ID
        msgParameter.setTenantId(tenantId);
        // 消息发送人Id
        msgParameter.setSendUserId(sendUserId);
        // 是否保存消息，发送用户消息时有效
        msgParameter.setSaveFlag(true);
        return msgParameter;
    }
}
