package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawingApplyForDrwgrpDrawEntity;
import com.ejianc.business.dc.bean.DcDrawingApplyForEntity;
import com.ejianc.business.dc.enumUtils.TzFlowStateEnum;
import com.ejianc.business.dc.service.IDcDrawingApplyForDrwgrpDrawService;
import com.ejianc.business.dc.service.IDcDrawingApplyForService;
import com.ejianc.business.dc.vo.DcDrawingApplyForVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 图纸申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcDrawingApplyFor")
public class DcDrawingApplyForController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    public static final String BILL_CODE = "DC_DRAWAPPLY_DIST_CODE";//此处需要根据实际修改

    @Autowired
    private IDcDrawingApplyForService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDcDrawingApplyForDrwgrpDrawService dcDrawingApplyForDrwgrpDrawService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawingApplyForVO> saveOrUpdate(@RequestBody DcDrawingApplyForVO saveOrUpdateVO) {
    	DcDrawingApplyForEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrawingApplyForEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (ToolUtil.isEmpty(entity.getFlowState())) {
                entity.setFlowState(TzFlowStateEnum.ZERO.getCode());
                entity.setFlowStateName(TzFlowStateEnum.ZERO.getName());
            }
            List<DcDrawingApplyForDrwgrpDrawEntity> dcDrawingApplyForDrwgrpDrawList = Lists.newArrayList();
            entity.getDcDrawingApplyForDrwgrpList().forEach(item -> {
                item.setId(IdWorker.getId());
                item.getDcDrawingApplyForDrwgrpDrawList().forEach(itemSon -> {
                    itemSon.setId(null);
                    itemSon.setPid(item.getId());
                    dcDrawingApplyForDrwgrpDrawList.add(itemSon);
                });
            });
            dcDrawingApplyForDrwgrpDrawService.saveBatch(dcDrawingApplyForDrwgrpDrawList);
        }
    	service.saveOrUpdate(entity, false);
    	DcDrawingApplyForVO vo = BeanMapper.map(entity, DcDrawingApplyForVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcDrawingApplyForVO> queryDetail(Long id) {
    	DcDrawingApplyForEntity entity = service.selectById(id);
    	if (ToolUtil.isNotEmpty(entity) && ToolUtil.isNotEmpty(entity.getDcDrawingApplyForDrwgrpList())) {
            entity.getDcDrawingApplyForDrwgrpList().forEach(item -> {
                QueryParam param = new QueryParam();
                param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
                param.getParams().put("pid", new Parameter(QueryParam.EQ, item.getId()));
                item.setDcDrawingApplyForDrwgrpDrawList(dcDrawingApplyForDrwgrpDrawService.queryList(param));
            });
        }
    	DcDrawingApplyForVO vo = BeanMapper.map(entity, DcDrawingApplyForVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrawingApplyForVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DcDrawingApplyForVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DcDrawingApplyForVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcDrawingApplyForVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcDrawingApplyForEntity> page = service.queryPage(param,false);
        IPage<DcDrawingApplyForVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawingApplyForVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcDrawingApplyForEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrawingApplyFor-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDcDrawingApplyForData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcDrawingApplyForVO>> refDcDrawingApplyForData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcDrawingApplyForEntity> page = service.queryPage(param,false);
        IPage<DcDrawingApplyForVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawingApplyForVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 打印数据处理
     *
     * @param ids 主键ID
     * @return 返回对象
     */
    @RequestMapping(value = "/printDataDispose", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> printDataDispose(@RequestBody List<Long> ids) {
        try {
            service.printDataDispose(ids);
        } catch (RuntimeException e) {
            logger.error("图纸申请-打印数据处理失败，错误信息:", e);
            return CommonResponse.error(e.getMessage());
        }
        return CommonResponse.success();
    }
}
