package com.ejianc.business.dc.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.dc.bean.DcSourceUnitnameEntity;
import com.ejianc.business.dc.service.IDcSourceUnitnameService;
import com.ejianc.business.dc.vo.DcSourceUnitnameVO;

/**
 * 文件来源
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcFiledistributeMenu")
public class DcFiledistributeMenuController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDcSourceUnitnameService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcSourceUnitnameVO> saveOrUpdate(@RequestBody DcSourceUnitnameVO saveOrUpdateVO) {
        DcSourceUnitnameEntity entity = BeanMapper.map(saveOrUpdateVO, DcSourceUnitnameEntity.class);
        //校验同一个项目，单位名称不能相同
        DcSourceUnitnameEntity dcSourceUnitnameEntity = service.getById(entity.getId());
        if (dcSourceUnitnameEntity == null || !(
                dcSourceUnitnameEntity.getSourceUnitname().equals(entity.getSourceUnitname())
                        && dcSourceUnitnameEntity.getSourceType().equals(entity.getSourceType())
                        && dcSourceUnitnameEntity.getProjectId().equals(entity.getProjectId())
        )) {
            QueryWrapper<DcSourceUnitnameEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda()
                    .eq(DcSourceUnitnameEntity::getProjectId, entity.getProjectId())
                    .eq(DcSourceUnitnameEntity::getDr, 0)
                    .eq(DcSourceUnitnameEntity::getSourceUnitname, entity.getSourceUnitname())
                    .eq(DcSourceUnitnameEntity::getSourceType, entity.getSourceType());
            List<DcSourceUnitnameEntity> list = service.list(queryWrapper);
            if (list.size() > 0) {
                throw new BusinessException("该单位名称已添加");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
        }
        service.saveOrUpdate(entity, false);
        DcSourceUnitnameVO vo = BeanMapper.map(entity, DcSourceUnitnameVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcSourceUnitnameVO> queryDetail(Long id) {
        DcSourceUnitnameEntity entity = service.selectById(id);
        DcSourceUnitnameVO vo = BeanMapper.map(entity, DcSourceUnitnameVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcSourceUnitnameVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DcSourceUnitnameVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DcSourceUnitnameVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcSourceUnitnameVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("sourceUnitname");
        param.getFuzzyFields().add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcSourceUnitnameEntity> page = service.queryPage(param,false);
        IPage<DcSourceUnitnameVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcSourceUnitnameVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcSourceUnitnameEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcSourceUnitname-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDcSourceUnitnameData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcSourceUnitnameVO>> refDcSourceUnitnameData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.parseLong(_con.getString("projectId"))));
        }

        IPage<DcSourceUnitnameEntity> page = service.queryPage(param,false);
        IPage<DcSourceUnitnameVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcSourceUnitnameVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/queryUnitTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryUnitTree(@RequestParam(required = false) String searchText, @RequestParam(required = false) String condition, @RequestParam(required = false) Long pid) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            param.getParams().put("sourceType", new Parameter(QueryParam.EQ, _con.getString("sourceType")));
        }
        List<DcSourceUnitnameEntity> entityList = service.queryList(param,false);
        List<DcSourceUnitnameVO> voList = BeanMapper.mapList(entityList, DcSourceUnitnameVO.class);
        voList.forEach(dcSourceUnitnameVO -> dcSourceUnitnameVO.setName(dcSourceUnitnameVO.getSourceUnitname()));
        return ResultAsTree.createTreeData(BeanMapper.mapList(voList, Map.class));
    }
}
