package com.ejianc.business.dc.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.ztpc.billcode.bean.DcDrawInfoVO;
import com.ejianc.business.dc.vo.bpm.BatchSubmitVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 卷册信息
 * 
 * @author generator
 * 
 */
public interface IDcDrwgrpInfoService extends IBaseService<DcDrwgrpInfoEntity> {
    boolean upgrade(DcDrwgrpInfoEntity entitie);
    boolean annul(List<DcDrwgrpInfoEntity> entities);

    List<DcDrwgrpInfoEntity> checkExist(List<DcDrwgrpInfoEntity> entities);

    IPage<DcDrwgrpInfoEntity> queryPage(List<String> ids, QueryParam param);

    List<DcDrwgrpInfoEntity> queryIdsDr(String drwgrp_code,String draw_code);

    /**
     * 图纸签发
     *
     * @param ids 图纸库信息ID
     * @return 图纸签发ID
     */
    List<BatchSubmitVO.BatchSubmitDetailVO> drawingIssuanceSave(List<Long> ids,String leaderShip);

    /**
     * 添加图纸
     *
     * @param drwgrpId       卷册ID
     * @param dcDrawInfoList 图纸信息
     */
    void saveDrawInfo(Long drwgrpId, List<DcDrawInfoVO> dcDrawInfoList);

    List<DcDrwgrpInfoEntity> queryListByProjectAndCodes(Long projectId,List<String> codeList);
}
