package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.bean.ActRuTaskPo;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.controller.DcDrawdistributeRecordController;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcLssueAddressBookController;
import com.ejianc.business.dc.enumUtils.*;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.service.*;
import com.ejianc.business.dc.util.MessageUtil;
import com.ejianc.business.ztpc.billcode.bean.DcDrawdistributeRecordVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("dcDrawdistributeInfo")
public class DcDrawdistributeInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    ActRuTaskService actRuTaskService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private DcDrawdistributeRecordController dcDrawdistributeRecordController;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private DcLssueAddressBookController dcLssueAddressBookController;
    @Autowired
    private DcDrawdistributeDrwgrpinfoMapper dcDrawdistributeDrwgrpinfoMapper;

    @Value("${common.env.base-host}")
    private String baseHost;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交完回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        DcDrawdistributeInfoEntity dcDrawdistributeInfo = dcDrawdistributeInfoService.getById(billId);
        if (ToolUtil.isEmpty(dcDrawdistributeInfo)) {
            return CommonResponse.error("单据不存在！");
        }
        /*
         * 1.生成签发信息，根据项目和签发通讯录类型为“图纸签发”查询签发通讯录中的明细
         */
        /*
         * 1.2 查询签发通讯录信息，根据图纸签发信息的项目ID和签发通讯录类型为“图纸签发”
         */
        /*JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", dcDrawdistributeInfo.getProjectId());
        jsonObject.put("addressBookType", AddressBookTypeEnum.ONE.getCode());
        CommonResponse<IPage<DcLssueAddressBookVO>> commonResponse = dcLssueAddressBookController.refDcLssueAddressBookData(1, 1, jsonObject.toString(), null, null);
        *//*
         * 1.3 转换签发通讯录明细类型为图纸签发的签发信息类型
         *//*
        if (commonResponse.isSuccess() && ToolUtil.isNotEmpty(commonResponse.getData()) && ToolUtil.isNotEmpty(commonResponse.getData().getRecords())) {
            List<DcLssueAddressBookVO> dcLssueAddressBookList = commonResponse.getData().getRecords();
            List<DcLssueAddressBookDetailVO> dcLssueAddressBookDetailList = dcLssueAddressBookList.get(0).getDcLssueAddressBookDetailList();
            List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoList = BeanMapper.mapList(dcLssueAddressBookDetailList, DcDrawdistributeDrwgrpinfoEntity.class);

            *//*
             * 签发列表去重，根据数据库旧数据
             *//*
            List<DcDrawdistributeDrwgrpinfoEntity> oldDcDrawdistributeDrwgrpinfoList = dcDrawdistributeDrwgrpinfoMapper.selectList(
                    new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>()
                            .lambda()
                            .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, "0")
                            .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, dcDrawdistributeInfo.getId())
            );
            List<Long> receiveUserIdList = Lists.newArrayList();
            if (ToolUtil.isNotEmpty(oldDcDrawdistributeDrwgrpinfoList)) {
                receiveUserIdList = oldDcDrawdistributeDrwgrpinfoList.stream().map(DcDrawdistributeDrwgrpinfoEntity::getReceiveUserId).collect(Collectors.toList());
            }
            List<DcDrawdistributeDrwgrpinfoEntity> newDcDrawdistributeDrwgrpinfoList = Lists.newArrayList();
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfo : dcDrawdistributeDrwgrpinfoList) {
                if (receiveUserIdList.contains(dcDrawdistributeDrwgrpinfo.getReceiveUserId())) {
                    continue;
                }
                dcDrawdistributeDrwgrpinfo.setId(null);
                dcDrawdistributeDrwgrpinfo.setPid(dcDrawdistributeInfo.getId());
                dcDrawdistributeDrwgrpinfo.setDrwgrpId(dcDrawdistributeInfo.getDrwgrpId());
                dcDrawdistributeDrwgrpinfo.setOrgId(dcDrawdistributeInfo.getOrgId());
                dcDrawdistributeDrwgrpinfo.setOrgCode(dcDrawdistributeInfo.getOrgCode());
                dcDrawdistributeDrwgrpinfo.setOrgName(dcDrawdistributeInfo.getOrgName());
                dcDrawdistributeDrwgrpinfo.setParentOrgId(dcDrawdistributeInfo.getParentOrgId());
                dcDrawdistributeDrwgrpinfo.setParentOrgCode(dcDrawdistributeInfo.getParentOrgCode());
                dcDrawdistributeDrwgrpinfo.setParentOrgName(dcDrawdistributeInfo.getParentOrgName());
                dcDrawdistributeDrwgrpinfo.setProjectId(dcDrawdistributeInfo.getProjectId());
                dcDrawdistributeDrwgrpinfo.setProjectCode(dcDrawdistributeInfo.getProjectCode());
                dcDrawdistributeDrwgrpinfo.setProjectName(dcDrawdistributeInfo.getProjectName());
                dcDrawdistributeDrwgrpinfo.setDrwgrpCode(dcDrawdistributeInfo.getDrwgrpCode());
                dcDrawdistributeDrwgrpinfo.setDrwgrpName(dcDrawdistributeInfo.getDrwgrpName());
                dcDrawdistributeDrwgrpinfo.setDrwgrpVsn(dcDrawdistributeInfo.getDrwgrpVsn());
                dcDrawdistributeDrwgrpinfo.setDrwgrpType(dcDrawdistributeInfo.getDrwgrpType());
                dcDrawdistributeDrwgrpinfo.setMgrp(dcDrawdistributeInfo.getMgrp());
                dcDrawdistributeDrwgrpinfo.setSpecialty(dcDrawdistributeInfo.getSpecialty());
                newDcDrawdistributeDrwgrpinfoList.add(dcDrawdistributeDrwgrpinfo);
            }
            dcDrawdistributeInfo.setDcDrawdistributeDrwgrpinfoEntityList(newDcDrawdistributeDrwgrpinfoList);
        }*/
        // 修改图纸签发-流程状态为“待签发”
        dcDrawdistributeInfo.setFlowState(TzFlowStateEnum.THREE.getCode());
        dcDrawdistributeInfo.setFlowStateName(TzFlowStateEnum.THREE.getName());
        // 1.4 保存图纸签发的签发信息
        dcDrawdistributeInfoService.saveOrUpdate(dcDrawdistributeInfo, false);
        // 修改图纸库-流程状态为“待签发”
        dcDrwgrpInfoService.update(
                new UpdateWrapper<DcDrwgrpInfoEntity>()
                        .lambda()
                        .eq(DcDrwgrpInfoEntity::getId, dcDrawdistributeInfo.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.THREE.getCode())
                        .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.THREE.getName())
        );
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        logger.info("有审批流的撤回后回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        DcDrawdistributeInfoEntity dcDrawdistributeInfo = dcDrawdistributeInfoService.getById(billId);
        if (ToolUtil.isEmpty(dcDrawdistributeInfo)) {
            return CommonResponse.error("单据不存在！");
        }
        // 修改图纸库-流程状态为“待申请签发”
        dcDrwgrpInfoService.update(
                new UpdateWrapper<DcDrwgrpInfoEntity>()
                        .lambda()
                        .eq(DcDrwgrpInfoEntity::getId, dcDrawdistributeInfo.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        // 修改图纸签发-流程状态为“待申请签发”
        dcDrawdistributeInfoService.update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfo.getId())
                        .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
        String nodeType;
        if (ToolUtil.isNotEmpty(actRuTaskPos)) {
            nodeType = actRuTaskPos.get(0).getDescription();
        } else {
            nodeType = "ERROR";
        }
        logger.info("审批节点审批中时节点审批后回调-----------billId:{}, state:{}, billTypeCode:{}, taskId:{}, isEnd:{}, sign:{}, other:{}, nodeType:{}"
                , billId, state, billTypeCode, taskId, isEnd, sign, other, nodeType);
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_a".equals(nodeType)) {
                //更新图纸签发主表签发信息
                dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getIssueDate, new Date())
                        .set(DcDrawdistributeInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawdistributeInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
                //更新卷册签发信息
                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getIssueDate, new Date())
                        .set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
            }
            if ("3".equals(sign)) {
                // 修改图纸库-流程状态为“待分发”
                dcDrwgrpInfoService.update(
                        new UpdateWrapper<DcDrwgrpInfoEntity>()
                                .lambda()
                                .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                                .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.FOUR.getCode())
                                .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.FOUR.getName())
                );
                // 修改图纸签发-流程状态为“待分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, entity.getId())
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FOUR.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FOUR.getName())
                );
            } else if ("4".equals(sign)) {
                // 修改图纸库-流程状态为“已分发”
                dcDrwgrpInfoService.update(
                        new UpdateWrapper<DcDrwgrpInfoEntity>()
                                .lambda()
                                .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                                .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
                // 修改图纸签发-流程状态为“已分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, entity.getId())
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List<ActRuTaskPo> actRuTaskPos = actRuTaskService.getNodeTypes(String.valueOf(billId));
        String nodeType;
        if (ToolUtil.isNotEmpty(actRuTaskPos)) {
            nodeType = actRuTaskPos.get(0).getDescription();
        } else {
            nodeType = "ERROR";
        }
        logger.info("终审审核完回调-----------billId:{}, state:{}, billTypeCode:{}, nodeType:{}"
                , billId, state, billTypeCode, nodeType);
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_b".equals(nodeType)) {
                List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoService.list(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, billId)
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, 0));
                //签发流程结束后，数据添加到签发记录表（如果用户已持有该卷册，不增加数据。）
                //更新图纸签发主表分发信息
                dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getDistDate, new Date())
                        .set(DcDrawdistributeInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawdistributeInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName()));
                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode()));
                dcDrawdistributeDrwgrpinfoEntityList.forEach(dcDrawdistributeDrwgrpinfoEntity -> {
                    DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity = dcDrawdistributeRecordService.getOne(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                            .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrawdistributeDrwgrpinfoEntity.getDrwgrpId())
                            .eq(DcDrawdistributeRecordEntity::getReceiveUserCode, dcDrawdistributeDrwgrpinfoEntity.getReceiveUserCode())
                            .eq(DcDrawdistributeRecordEntity::getDr, 0));
                    if (dcDrawdistributeRecordEntity == null) {
                        DcDrawdistributeRecordEntity drawdistributeRecordEntity = BeanMapper.map(dcDrawdistributeDrwgrpinfoEntity, DcDrawdistributeRecordEntity.class);
                        drawdistributeRecordEntity.setId(null);
                        drawdistributeRecordEntity.setIssueDate(entity.getIssueDate());
                        drawdistributeRecordEntity.setIssueUserCode(entity.getIssueUserCode());
                        drawdistributeRecordEntity.setIssueUserName(entity.getIssueUserName());
                        drawdistributeRecordEntity.setSourceUnitid(entity.getSourceUnitid());
                        drawdistributeRecordEntity.setSourceUnitname(entity.getSourceUnitname());
                        drawdistributeRecordEntity.setSys(entity.getSys());
                        drawdistributeRecordEntity.setDrawArriveDate(entity.getDrawArriveDate());
                        drawdistributeRecordEntity.setTenantId(null);
                        drawdistributeRecordEntity.setCreateTime(null);
                        drawdistributeRecordEntity.setCreateUserCode(null);
                        drawdistributeRecordEntity.setUpdateTime(null);
                        drawdistributeRecordEntity.setUpdateUserCode(null);
                        drawdistributeRecordEntity.setRecycleSts(RecycleEnum.N.getCode());
                        dcDrawdistributeRecordController.saveOrUpdate(BeanMapper.map(drawdistributeRecordEntity, DcDrawdistributeRecordVO.class));
                    }
                });
                // 修改图纸库-流程状态为“已分发”
                dcDrwgrpInfoService.update(
                        new UpdateWrapper<DcDrwgrpInfoEntity>()
                                .lambda()
                                .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                                .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
                // 修改图纸签发-流程状态为“已分发”
                dcDrawdistributeInfoService.update(
                        new UpdateWrapper<DcDrawdistributeInfoEntity>()
                                .lambda()
                                .eq(DcDrawdistributeInfoEntity::getId, entity.getId())
                                .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.FIVE.getCode())
                                .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.FIVE.getName())
                );
                /*
                 * 对签发信息中的人员信息发送系统消息
                 */
                String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};
                String[] receivers = dcDrawdistributeDrwgrpinfoEntityList.stream().map(a -> a.getReceiveUserId().toString()).toArray(String[]::new);
                String msgType = "bpmcc";
                String subject = "【图纸签发----卷册编号：" + entity.getDrwgrpCode() + "，卷册名称：" + entity.getDrwgrpName() + "，卷册版本：" + entity.getDrwgrpVsn() + "】，已分发";
                String content = "【图纸签发----卷册编号：" + entity.getDrwgrpCode() + "，卷册名称：" + entity.getDrwgrpName() + "，卷册版本：" + entity.getDrwgrpVsn() + "】，已分发";
                String pcUrl = baseHost + "ejc-ztpcdc-frontend/#/dcDrawdistributeInfo/card?id=" + entity.getId();
                String tenantId = InvocationInfoProxy.getTenantid().toString();
                Long sendUserId = InvocationInfoProxy.getUserid();
                PushMsgParameter msgParameter = MessageUtil.getPushMsgParameter(channel, receivers, msgType, subject, content, pcUrl, tenantId, sendUserId);
                pushMessageApi.pushMessage(msgParameter);
            }
        }

        /*
         * modify by XXX start 补充图纸签发-图纸信息没有的图纸信息
         */
        /*
         * 获取图纸签发-图纸信息数据
         */
        List<DcDrawdistributeDrawinfoEntity> dcDrawdistributeDrawinfoList = dcDrawdistributeDrawinfoService.list(new QueryWrapper<DcDrawdistributeDrawinfoEntity>()
                .lambda()
                .eq(DcDrawdistributeDrawinfoEntity::getDr, "0")
                .eq(DcDrawdistributeDrawinfoEntity::getPid, billId));
        /*
         * 获取图纸库-图纸信息数据
         */
        List<DcDrawInfoEntity> dcDrawInfoList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>()
                .lambda()
                .eq(DcDrawInfoEntity::getDr, "0")
                .eq(DcDrawInfoEntity::getDrwgrpId, entity.getDrwgrpId()));
        // 把图纸库-图纸信息对象类型转换为图纸签发-图纸信息对象类型
        List<DcDrawdistributeDrawinfoEntity> allDcDrawdistributeDrawinfoList = BeanMapper.mapList(dcDrawInfoList, DcDrawdistributeDrawinfoEntity.class);
        /*
         * 获取图纸库-图纸信息在图纸签发-图纸信息中没有的图纸信息
         */
        List<DcDrawdistributeDrawinfoEntity> newDcDrawdistributeDrawinfoList = allDcDrawdistributeDrawinfoList.stream().filter(
                a -> dcDrawdistributeDrawinfoList.stream().noneMatch(
                        b -> a.getDrawCode().equals(b.getDrawCode())
                )
        ).peek(a -> {
            a.setId(null);
            a.setPid(billId);
        }).collect(Collectors.toList());
        // 保存到图纸签发-图纸信息表中
        dcDrawdistributeDrawinfoService.saveBatch(newDcDrawdistributeDrawinfoList);
        /*
         * modify by XXX end
         */

        /*
         * modify by XXX start 图纸为电子版，签发后增加卷册套数
         */
        // 图纸签发-图纸信息数据是否为电子版
        boolean paperFlag = dcDrawdistributeDrawinfoList.stream().anyMatch(a -> {
            try {
                JSONArray specialtyReferValue = ReferObjectUtil.getReferEntityValue(a.getDrawType() + "", "support-defdoc");
                return
                        DrawTypeEnum.CATALOGUE.getCode().equals(((JSONObject) specialtyReferValue.get(0)).get("code"))
                                && PaperFlagEnum.NO.getCode().equals(a.getPaperFlag());
            } catch (Exception e) {
                return false;
            }
        });
        // 图纸为电子版（paperFlag）
        if (paperFlag) {
            // 图纸库信息
            DcDrwgrpInfoEntity dcDrwgrpInfo = dcDrwgrpInfoService.getOne(
                    new QueryWrapper<DcDrwgrpInfoEntity>().lambda()
                            .eq(DcDrwgrpInfoEntity::getDr, 0)
                            .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                            .last("LIMIT 1")
            );
            // 图纸签发-签发信息（一共签发的份数从这个里面计算）
            List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoList = dcDrawdistributeDrwgrpinfoMapper.selectList(
                    new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>()
                            .lambda()
                            .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, 0)
                            .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, billId)
            );
            // 签发份数
            int num = dcDrawdistributeDrwgrpinfoList.stream().mapToInt(DcDrawdistributeDrwgrpinfoEntity::getNum).sum();
            // 之前的卷册套数
            int drwgrpNum = ToolUtil.isNotEmpty(dcDrwgrpInfo.getDrwgrpNum()) ? dcDrwgrpInfo.getDrwgrpNum() : 0;
            // 卷册套数=之前的卷册套数-签发份数
            drwgrpNum = drwgrpNum + num;
            // 更新图纸库的卷册套数
            dcDrwgrpInfoService.update(
                    new UpdateWrapper<DcDrwgrpInfoEntity>()
                            .lambda()
                            .set(DcDrwgrpInfoEntity::getDrwgrpNum, drwgrpNum)
                            .eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfo.getId())
                            .eq(DcDrwgrpInfoEntity::getDr, 0)
            );
            // 更新图纸签发的卷册套数
            dcDrawdistributeInfoService.update(
                    new UpdateWrapper<DcDrawdistributeInfoEntity>()
                            .lambda()
                            .set(DcDrawdistributeInfoEntity::getDrwgrpNum, drwgrpNum)
                                .eq(DcDrawdistributeInfoEntity::getId, billId)
                            .eq(DcDrawdistributeInfoEntity::getDr, 0)
            );
        }
        /*
         * modify by XXX end
         */
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        logger.info("弃审后事件回调-----------billId:{}, state:{}, billTypeCode:{}"
                , billId, state, billTypeCode);
        DcDrawdistributeInfoEntity dcDrawdistributeInfo = dcDrawdistributeInfoService.getById(billId);
        if (ToolUtil.isEmpty(dcDrawdistributeInfo)) {
            return CommonResponse.error("单据不存在！");
        }
        // 修改图纸库-流程状态为“待申请签发”
        dcDrwgrpInfoService.update(
                new UpdateWrapper<DcDrwgrpInfoEntity>()
                        .lambda()
                        .eq(DcDrwgrpInfoEntity::getId, dcDrawdistributeInfo.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrwgrpInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        // 修改图纸签发-流程状态为“待申请签发”
        dcDrawdistributeInfoService.update(
                new UpdateWrapper<DcDrawdistributeInfoEntity>()
                        .lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfo.getId())
                        .set(DcDrawdistributeInfoEntity::getFlowState, TzFlowStateEnum.TWO.getCode())
                        .set(DcDrawdistributeInfoEntity::getFlowStateName, TzFlowStateEnum.TWO.getName())
        );
        return CommonResponse.success();
    }

}
