package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.ProjectImplProtocolDetailEntity;
/**
 * 项目实施协议
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_cost_project_impl_protocol")
public class ProjectImplProtocolEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 发包单位名称
    @TableField(value="contract_unit_name")
    private String contractUnitName; // 承包单位名称
    @TableField(value="prjsale_cost")
    private BigDecimal prjsaleCost; // 销售费用
    @TableField(value="prjimpl_protocol_total")
    private BigDecimal prjimplProtocolTotal; // 实施协议金额
    @TableField(value="workload_cost")
    private BigDecimal workloadCost; // 工作量金额
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="end_date")
    private Date endDate; // 完工日期
    @TableField(value="contract_finish_date")
    private Date contractFinishDate; // 合同竣工日期
    @TableField(value="total_period")
    private Integer totalPeriod; // 总工期
    @TableField(value="establishment_org_id")
    private Long establishmentOrgId; // 编制单位ID
    @TableField(value="establishment_org_name")
    private String establishmentOrgName; // 编制单位名称
    @TableField(value="establishment_user_id")
    private Long establishmentUserId; // 编制人ID
    @TableField(value="establishment_user_name")
    private String establishmentUserName; // 编制人名称
    @TableField(value="establishment_date")
    private Date establishmentDate; // 编制日期
    @TableField(value="produce_content")
    private String produceContent; // 生产
    @TableField(value="quality_content")
    private String qualityContent; // 质量
    @TableField(value="safe_content")
    private String safeContent; // 安全
    @TableField(value="receive_pay_conent")
    private String receivePayConent; // 回款
    @TableField(value="remark")
    private String remark; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="projectImplProtocolDetailService", pidName="prjimplProtocolId")
    private List<ProjectImplProtocolDetailEntity> projectImplProtocolDetailList = new ArrayList<>(); // 项目实施协议明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public BigDecimal getPrjsaleCost() {
        return prjsaleCost;
    }

    public void setPrjsaleCost(BigDecimal prjsaleCost) {
        this.prjsaleCost = prjsaleCost;
    }
    public BigDecimal getPrjimplProtocolTotal() {
        return prjimplProtocolTotal;
    }

    public void setPrjimplProtocolTotal(BigDecimal prjimplProtocolTotal) {
        this.prjimplProtocolTotal = prjimplProtocolTotal;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTotalPeriod() {
        return totalPeriod;
    }

    public void setTotalPeriod(Integer totalPeriod) {
        this.totalPeriod = totalPeriod;
    }
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getProduceContent() {
        return produceContent;
    }

    public void setProduceContent(String produceContent) {
        this.produceContent = produceContent;
    }
    public String getQualityContent() {
        return qualityContent;
    }

    public void setQualityContent(String qualityContent) {
        this.qualityContent = qualityContent;
    }
    public String getSafeContent() {
        return safeContent;
    }

    public void setSafeContent(String safeContent) {
        this.safeContent = safeContent;
    }
    public String getReceivePayConent() {
        return receivePayConent;
    }

    public void setReceivePayConent(String receivePayConent) {
        this.receivePayConent = receivePayConent;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getWorkloadCost() {
        return workloadCost;
    }

    public void setWorkloadCost(BigDecimal workloadCost) {
        this.workloadCost = workloadCost;
    }

    public List<ProjectImplProtocolDetailEntity> getProjectImplProtocolDetailList() {
        return projectImplProtocolDetailList;
    }

    public void setProjectImplProtocolDetailList(List<ProjectImplProtocolDetailEntity> projectImplProtocolDetailList) {
        this.projectImplProtocolDetailList = projectImplProtocolDetailList;
    }

    public Date getContractFinishDate() {
        return contractFinishDate;
    }

    public void setContractFinishDate(Date contractFinishDate) {
        this.contractFinishDate = contractFinishDate;
    }
}
