package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.ProjectTargetcostDetailEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.mapper.ProjectTargetcostMapper;
import com.ejianc.business.cost.service.IProjectTargetcostDetailService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.vo.ProjectTargetcostDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 项目目标成本
 * 
 * @author generator
 * 
 */
@Service("projectTargetcostService")
public class ProjectTargetcostServiceImpl extends BaseServiceImpl<ProjectTargetcostMapper, ProjectTargetcostEntity> implements IProjectTargetcostService{

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IProjectTargetcostDetailService detailService;

    @Override
    public JSONObject queryDataByProjectId(Long projectId) {
        JSONObject json = new JSONObject();

        //获取子项目id
        List<Long> projectIds = new ArrayList<>();
        CommonResponse<List<ProjectRegisterVO>> listResponse = projectApi.queryProjectByPid(projectId);
        if(listResponse.isSuccess() && listResponse.getData()!=null && listResponse.getData().size()>0){
            for(ProjectRegisterVO vo : listResponse.getData()){
                projectIds.add(vo.getId());
            }
        }else{
            projectIds.add(projectId);
        }
        //获取项目目标成本
        QueryWrapper<ProjectTargetcostEntity> wrapper = new QueryWrapper<>();
        wrapper.in("project_id", projectIds);
        List<ProjectTargetcostEntity> list = this.list(wrapper);
        List<ProjectTargetcostVO> data = new ArrayList<>();
        List<ProjectTargetcostDetailVO> detailList = new ArrayList<>();
        if(list!=null && list.size()>0){
            data = BeanMapper.mapList(list, ProjectTargetcostVO.class);
            Map<Long, List<ProjectTargetcostDetailEntity>> detailMap = new HashMap<>();
            List<ProjectTargetcostDetailVO> allList = new ArrayList<>();
            List<Long> pids = new ArrayList<>();//保存pid，用于判断该节点是否是叶子节点
            Map<Long,Long> idMap = new HashMap<>();
            Map<Long,Long> subjectIdMap = new HashMap<>();
            Map<Long,List<ProjectTargetcostDetailVO>> subjectMap = new HashMap<>();//存放根据成本id的map数据，用于后面父节点合并，子节点处理
            for(ProjectTargetcostEntity entity : list){
                QueryWrapper<ProjectTargetcostDetailEntity> w = new QueryWrapper<>();
                w.eq("targetcost_id", entity.getId());
                List<ProjectTargetcostDetailEntity> dList = detailService.list(w);
                if(dList!=null && dList.size()>0){
                    detailMap.put(entity.getId(), dList);
                    for(ProjectTargetcostDetailEntity de : dList){
                        idMap.put(de.getId(), IdWorker.getId());
                        ProjectTargetcostDetailVO vo = BeanMapper.map(de, ProjectTargetcostDetailVO.class);
                        vo.setProjectId(entity.getProjectId());
                        vo.setProjectName(entity.getProjectName());
                        allList.add(vo);
                        if(de.getPid()!=null && !pids.contains(de.getPid())){
                            pids.add(de.getPid());
                        }
                        if(de.getAddState()!=null && de.getAddState()){
                            //本节点新增的，
                            detailList.add(vo);
                        }else{
                            subjectIdMap.put(de.getSubjectId(), IdWorker.getId());
                            if(subjectMap.get(de.getSubjectId())!=null){
                                List<ProjectTargetcostDetailVO> a = subjectMap.get(de.getSubjectId());
                                a.add(vo);
                                subjectMap.put(de.getSubjectId(), a);
                            }else{
                                List<ProjectTargetcostDetailVO> a = new ArrayList<>();
                                a.add(vo);
                                subjectMap.put(de.getSubjectId(), a);
                            }
                        }
                    }
                }
            }
            //对新id数据进行对照处理---先将所有的成本科目重复的数据进行id的合并，这样会导致叶子节点的数据id重复，但是后面叶子节点的id不从这里取
            for(ProjectTargetcostDetailVO en : allList){
                if(en.getSubjectId()!=null){
                    idMap.put(en.getId(), subjectIdMap.get(en.getSubjectId()));
                }
            }

            //构建子表数据
            //1、获取所有数据
            //2、将数据按照成本档案id进行map结构存储，然后循环遍历，若该成本档案id对应多个，且该数据为父节点，进行合并，若该数据为叶子节点，构建虚拟父级节点，
            for(Long key : subjectMap.keySet()){
                List<ProjectTargetcostDetailVO> subjectList = subjectMap.get(key);
                if(subjectList!=null  && subjectList.size()>0){
                    if(subjectList.size()>1){
                        //存在重复的数据
                        //1、判断该数据是否是父节点，是则合并,并清理
                        Boolean isParent = false;
                        String projectName = "";
                        for(ProjectTargetcostDetailVO entity : subjectList){
                            if(projectName.length()>0){
                                projectName += (","+entity.getProjectName());
                            }else{
                                projectName += (entity.getProjectName());
                            }
                            if(pids.contains(entity.getId())){
                                isParent = true;
                            }
                        }
                        if(isParent){
                            ProjectTargetcostDetailVO vo = BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class);
                            vo.setProjectName(projectName);
                            vo.setId(idMap.get(vo.getId()));
                            if(vo.getPid()!=null){
                                vo.setPid(idMap.get(vo.getId()));
                            }
                            detailList.add(vo);
                        }else{
                            ProjectTargetcostDetailVO vo1 = BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class);
                            //生成虚拟节点，
                            Long id = IdWorker.getId();
                            ProjectTargetcostDetailVO d = new ProjectTargetcostDetailVO();
                            d.setAddState(vo1.getAddState());
                            d.setFeeType(vo1.getFeeType());
                            d.setSubjectCode(vo1.getSubjectCode());
                            d.setSubjectId(vo1.getSubjectId());
                            d.setSubjectName(vo1.getSubjectName());
                            d.setSubjectInnerCode(vo1.getSubjectInnerCode());
                            d.setParentInnerCode(vo1.getParentInnerCode());
                            d.setProjectName(projectName);
                            d.setPid(idMap.get(vo1.getPid()));
                            d.setId(id);
                            detailList.add(d);
                            for(ProjectTargetcostDetailVO entity : subjectList){
                                ProjectTargetcostDetailVO vo = BeanMapper.map(entity, ProjectTargetcostDetailVO.class);
                                vo.setPid(id);
                                vo.setId(IdWorker.getId());
                                detailList.add(vo);
                            }
                        }
                    }else{
                        //成本档案数据就一条，
                        ProjectTargetcostDetailVO vo = BeanMapper.map(subjectList.get(0), ProjectTargetcostDetailVO.class);
                        if(vo.getPid()!=null){
                            vo.setPid(idMap.get(vo.getPid()));
                        }
                        vo.setId(idMap.get(vo.getId()));
                        detailList.add(vo);
                    }
                }
            }

            //根据pid重新构建innercode
            //1、先排序，顺序：成本档案subjectInnerCode，项目id，id(手动新增的)
            //2、根据pid构建成树，
            //3、根据树生成code,并计算合计值
            if(CollectionUtils.isNotEmpty(detailList)){
                detailList.sort(Comparator.comparing(ProjectTargetcostDetailVO::getSubjectInnerCode,Comparator.nullsLast(String::compareTo))
                        .thenComparing(ProjectTargetcostDetailVO::getProjectId,Comparator.nullsLast(Long::compare))
                        .thenComparing(ProjectTargetcostDetailVO::getId,Comparator.nullsLast(Long::compare)));

                detailList = createTreeData1(detailList);
                //然后得到的新的数据【树3】，汇总计算值，--并同时计算code值
                for(int i=0; i<detailList.size(); i++){
                    ProjectTargetcostDetailVO vo = detailList.get(i);
                    String code = String.valueOf(i + 1);
                    vo.setCode(code);
                    BigDecimal camount = addAllAmount(vo, code);
                    vo.setAmount(camount);
                }
            }

        }
        json.put("projectList", data);
        json.put("detailList", detailList);
        return json;
    }


    public List<ProjectTargetcostDetailVO> createTreeData1(List<ProjectTargetcostDetailVO> list) {
        List<ProjectTargetcostDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectTargetcostDetailVO> listMap = new HashMap<>();
        for(ProjectTargetcostDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectTargetcostDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectTargetcostDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectTargetcostDetailVO> child = (List<ProjectTargetcostDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectTargetcostDetailVO> children = new ArrayList<ProjectTargetcostDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private BigDecimal addAllAmount(ProjectTargetcostDetailVO vo, String pcode){
        BigDecimal amount = vo.getAmount()!=null ? vo.getAmount() : new BigDecimal(0);
        if(vo.getChildren()!=null && vo.getChildren().size()>0){
            vo.setProjectId(null);
//            vo.setProjectName(null);
            amount = new BigDecimal(0);
            for(int i=0; i<vo.getChildren().size(); i++){
                ProjectTargetcostDetailVO c = vo.getChildren().get(i);
                String code = null;
                if(StringUtils.isNotBlank(pcode)){
                    code = pcode +"." + (i+1);
                }else{
                    code = String.valueOf(i+1);
                }
                c.setCode(code);
                BigDecimal camount = addAllAmount(c, code);
                amount = amount.add(camount);
            }
            vo.setAmount(amount);
        }
        return amount;
    }
}
