package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 施工合同变更表-清单
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_zypms_income_change_detail")
public class ChangeDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 序号
     */
    @TableField("detail_index")
    private String detailIndex;

    /**
     * 清单编号
     */
    @TableField("code")
    private String code;

    /**
     * parent_id
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 综合单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 合计
     */
    @TableField("mny")
    private BigDecimal mny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    @TableField("change_type")
    private Integer changeType;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同子表主键
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 变更前工程量
     */
    @TableField("before_change_num")
    private BigDecimal beforeChangeNum;

    /**
     * 变更前综合单价
     */
    @TableField("before_change_price")
    private BigDecimal beforeChangePrice;

    /**
     * 变更前合计
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="spec")
    private String spec; // 特征描述

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public BigDecimal getBeforeChangeNum() {
        return beforeChangeNum;
    }

    public void setBeforeChangeNum(BigDecimal beforeChangeNum) {
        this.beforeChangeNum = beforeChangeNum;
    }
    public BigDecimal getBeforeChangePrice() {
        return beforeChangePrice;
    }

    public void setBeforeChangePrice(BigDecimal beforeChangePrice) {
        this.beforeChangePrice = beforeChangePrice;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    @Override
    public String toString() {
        return "ChangeDetailEntity{" +
            "changeId=" + changeId +
            ", detailIndex=" + detailIndex +
            ", code=" + code +
            ", parentId=" + parentId +
            ", name=" + name +
            ", unit=" + unit +
            ", num=" + num +
            ", price=" + price +
            ", mny=" + mny +
            ", memo=" + memo +
            ", leafFlag=" + leafFlag +
            ", changeType=" + changeType +
            ", contractId=" + contractId +
            ", contractDetailId=" + contractDetailId +
            ", beforeChangeNum=" + beforeChangeNum +
            ", beforeChangePrice=" + beforeChangePrice +
            ", beforeChangeMny=" + beforeChangeMny +
        "}";
    }
}
