package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetDisposeDetailEntity;
/**
 * 固定资产处置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_asset_dispose")
public class AssetDisposeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="depend_on_project")
    private Integer dependOnProject; // 是否属于项目: 默认为true
    @TableField(value="project_name")
    private String projectName; // 处置项目名称
    @TableField(value="project_code")
    private String projectCode; // 处置项目编码
    @TableField(value="project_id")
    private Long projectId; // 处置项目id
    @TableField(value="org_id")
    private Long orgId; // 处置组织id
    @TableField(value="org_name")
    private String orgName; // 处置组织名称
    @TableField(value="dispose_date")
    private Date disposeDate; // 处置日期
    @TableField(value="dispose_mny")
    private BigDecimal disposeMny; // 处置金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetDisposeDetailService", pidName = "assetDisposeId")
    private List<AssetDisposeDetailEntity> detailList = new ArrayList<>(); // 固定资产处置-子实体
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getDisposeDate() {
        return disposeDate;
    }

    public void setDisposeDate(Date disposeDate) {
        this.disposeDate = disposeDate;
    }
    public BigDecimal getDisposeMny() {
        return disposeMny;
    }

    public void setDisposeMny(BigDecimal disposeMny) {
        this.disposeMny = disposeMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public List<AssetDisposeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetDisposeDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
