package com.ejianc.business.income.controller;


import com.ejianc.business.income.history.ChangeHistoryVo;
import com.ejianc.business.income.service.IChangeService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ChangeVo;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 施工合同变更表 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/change")
public class ChangeController {
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    /**
     * 新增或编辑
     *
     * @param changeVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeVo> saveOrUpdate(@RequestBody ChangeVo changeVo) {
        CommonResponse<ChangeVo> response = changeService.saveOrUpdate(changeVo);
        return response;
    }

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVo> queryDetail(@RequestParam Long id) {
        ChangeVo changeVo = changeService.queryDetail(id);
        return CommonResponse.success(changeVo);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVo> vos) {
        changeService.deleteChange(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVo> queryDetailChange(@RequestParam Long id) {
        ContractVo vo=changeService.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeHistoryVo> queryChangeHistory(@RequestParam Long id) {
        ChangeHistoryVo vo = changeService.queryChangeHistory(id);

        return CommonResponse.success(vo);
    }

}
