/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.PreBidCostCalcDetailEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcDetailService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.cost.vo.PreBidCostCalcVO;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncService")
public class SyncServiceImpl
implements ISyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IPreBidCostCalcDetailService preBidCostCalcDetailService;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;

    /*
     * WARNING - void declaration
     */
    @Override
    public void syncProject(SyncProjectVO projectVO) {
        void var21_27;
        List<PreBidCostCalcDetailVO> detailList;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_id", (Object)projectVO.getProjectContractCode());
        List contractList = this.contractService.list((Wrapper)wrapper);
        ContractEntity contract = null;
        if (contractList != null && contractList.size() > 0) {
            contract = (ContractEntity)((Object)contractList.get(0));
            contract.setContractName(projectVO.getProjectContractName());
            contract.setSignDate(projectVO.getSignDate());
            contract.setContractMny(projectVO.getContractMny());
        } else {
            contract = new ContractEntity();
            contract.setId(IdWorker.getId());
            contract.setBillCode(projectVO.getProjectContractCode());
            contract.setContractName(projectVO.getProjectContractName());
            contract.setSignDate(projectVO.getSignDate());
            contract.setContractMny(projectVO.getContractMny());
        }
        CommonResponse defAssetTypeList = this.defdocApi.getDefDocByDefCode("zydx_project_type");
        HashMap<String, DefdocDetailVO> defdocMap = new HashMap<String, DefdocDetailVO>();
        if (defAssetTypeList.isSuccess() && defAssetTypeList.getData() != null && ((List)defAssetTypeList.getData()).size() > 0) {
            for (DefdocDetailVO datum : (List)defAssetTypeList.getData()) {
                defdocMap.put(datum.getName(), datum);
            }
        }
        CommonResponse orgResponse = this.iOrgApi.findBySourceId(projectVO.getProjectOrgId());
        OrgVO orgVO = null;
        if (!orgResponse.isSuccess() || orgResponse.getData() == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u5148\u786e\u8ba4\u7ec4\u7ec7\u662f\u5426\u540c\u6b65");
        }
        orgVO = (OrgVO)orgResponse.getData();
        ProjectRegisterVO project = new ProjectRegisterVO();
        project.setSourceId(projectVO.getProjectId());
        project.setOrgId(orgVO.getId());
        project.setOrgName(orgVO.getName());
        project.setCode(projectVO.getProjectCode());
        project.setName(projectVO.getProjectCode());
        project.setProjectType(defdocMap.get(projectVO.getProjectType()) != null ? ((DefdocDetailVO)defdocMap.get(projectVO.getProjectType())).getId() : null);
        project.setProjectTypeName(projectVO.getProjectType());
        project.setProjectSource(projectVO.getProjectSource());
        project.setInternalCooperationProject(projectVO.getInternalCooperationProject());
        project.setFirstBusiness(projectVO.getFirstBusiness());
        project.setSecondBusiness(projectVO.getSecondBusiness());
        project.setProjectOverview(projectVO.getProjectOverview());
        project.setAddress(projectVO.getProjectAddress());
        project.setIncomeArea(projectVO.getProjectAddress());
        project.setContractId(contract.getId());
        project.setSignDate(projectVO.getSignDate());
        project.setContractMny(projectVO.getContractMny());
        project.setStatus(projectVO.getState() != null ? projectVO.getState().toString() : "0");
        project.setBillState(Integer.valueOf(1));
        CommonResponse taxTypeList = this.defdocApi.getDefDocByDefCode("tax_payer_type");
        HashMap<String, DefdocDetailVO> taxTypecMap = new HashMap<String, DefdocDetailVO>();
        if (taxTypeList.isSuccess() && taxTypeList.getData() != null && ((List)taxTypeList.getData()).size() > 0) {
            for (DefdocDetailVO datum : (List)taxTypeList.getData()) {
                taxTypecMap.put(datum.getName(), datum);
            }
        }
        CustomerVO customerVO = new CustomerVO();
        customerVO.setSourceId(projectVO.getCustomerId());
        customerVO.setCode(projectVO.getCustomerCode());
        customerVO.setName(projectVO.getCustomerName());
        customerVO.setSocialCreditCode(projectVO.getSocialCreditCode());
        customerVO.setTaxPayerTypeName(projectVO.getTaxType());
        customerVO.setTaxPayerType(taxTypecMap.get(projectVO.getTaxType()) != null ? ((DefdocDetailVO)taxTypecMap.get(projectVO.getTaxType())).getId() : null);
        customerVO.setAddress(projectVO.getCustomerAddress());
        customerVO.setBankAccount(projectVO.getBankAccount());
        customerVO.setBankCode(projectVO.getBankCode());
        customerVO.setBankName(projectVO.getBankName());
        customerVO.setLegal(projectVO.getLinker());
        customerVO.setTelephone(projectVO.getCellphone());
        CommonResponse customerResponse = this.customerApi.syncCustomer(customerVO);
        if (customerResponse.isSuccess()) {
            customerVO = (CustomerVO)customerResponse.getData();
        } else {
            this.logger.info("\u540c\u6b65\u5ba2\u6237\u6570\u636e\u5931\u8d25\uff1a{}", (Object)customerResponse.getMsg());
        }
        project.setPubUnit(customerVO.getId());
        project.setPubUnitName(projectVO.getCustomerName());
        CommonResponse pro = this.projectApi.syncProject(project);
        if (!pro.isSuccess()) {
            throw new BusinessException(pro.getMsg());
        }
        contract.setProjectId(((ProjectRegisterVO)pro.getData()).getId());
        contract.setProjectName(((ProjectRegisterVO)pro.getData()).getName());
        contract.setOrgId(((ProjectRegisterVO)pro.getData()).getProjectDepartmentId());
        this.contractService.saveOrUpdate((Object)contract, false);
        QueryWrapper preBidCostCalcWrapper = new QueryWrapper();
        preBidCostCalcWrapper.eq((Object)"source_id", (Object)projectVO.getProjectId());
        PreBidCostCalcEntity preBidCostCalc = (PreBidCostCalcEntity)((Object)this.preBidCostCalcService.getOne((Wrapper)preBidCostCalcWrapper));
        if (preBidCostCalc == null) {
            preBidCostCalc = new PreBidCostCalcEntity();
            preBidCostCalc.setProjectName(project.getName());
            preBidCostCalc.setProjectId(project.getId());
            preBidCostCalc.setProjectDepartmentId(project.getProjectDepartmentId());
            preBidCostCalc.setOrgId(project.getOrgId());
            preBidCostCalc.setPubUnitName(projectVO.getCustomerName());
            preBidCostCalc.setSourceId(projectVO.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)"PreBidCostCalc", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)preBidCostCalc), PreBidCostCalcVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                preBidCostCalc.setBillCode((String)billCode.getData());
            }
            detailList = projectVO.getPreBidCostCalcDetailList();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                preBidCostCalcDetailVO.setRowState("add");
            }
            preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
        } else {
            QueryWrapper deWrapper = new QueryWrapper();
            deWrapper.eq((Object)"pid", (Object)preBidCostCalc.getId());
            List deList = this.preBidCostCalcDetailService.list((Wrapper)deWrapper);
            detailList = projectVO.getPreBidCostCalcDetailList();
            HashMap<String, PreBidCostCalcDetailVO> detailMap = new HashMap<String, PreBidCostCalcDetailVO>();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                detailMap.put(preBidCostCalcDetailVO.getCostCode(), preBidCostCalcDetailVO);
            }
            if (deList != null && deList.size() > 0) {
                ArrayList<PreBidCostCalcDetailEntity> arrayList = new ArrayList<PreBidCostCalcDetailEntity>();
                ArrayList<String> codeList = new ArrayList<String>();
                for (PreBidCostCalcDetailEntity en : deList) {
                    if (detailMap.get(en.getCostCode()) != null) {
                        PreBidCostCalcDetailVO d = (PreBidCostCalcDetailVO)((Object)detailMap.get(en.getCostCode()));
                        en.setCostCode(d.getCostCode());
                        en.setMemo(d.getMemo());
                        en.setMny(d.getMny());
                        en.setCostStructure(d.getCostStructure());
                        en.setCostType(d.getCostType());
                        en.setRevenueShare(d.getRevenueShare());
                        en.setRowState("edit");
                        codeList.add(d.getCostCode());
                        arrayList.add(en);
                        continue;
                    }
                    en.setRowState("del");
                    arrayList.add(en);
                }
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    if (codeList.contains(preBidCostCalcDetailVO.getCostCode())) continue;
                    preBidCostCalcDetailVO.setRowState("add");
                    arrayList.add((PreBidCostCalcDetailEntity)((Object)BeanMapper.map((Object)((Object)preBidCostCalcDetailVO), PreBidCostCalcDetailEntity.class)));
                }
                preBidCostCalc.setPreBidCostCalcDetailList(arrayList);
            } else {
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    preBidCostCalcDetailVO.setRowState("add");
                }
                preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
            }
        }
        List<PreBidCostCalcDetailEntity> detailList2 = preBidCostCalc.getPreBidCostCalcDetailList();
        HashMap m = new HashMap();
        BigDecimal costNotaxTotal = new BigDecimal(0);
        BigDecimal costTaxTotal = new BigDecimal(0);
        BigDecimal bigDecimal = new BigDecimal(0);
        BigDecimal projectProfitRate = new BigDecimal(0);
        for (PreBidCostCalcDetailEntity en : detailList2) {
            if ("del".equals(en.getRowState())) continue;
            if ("\u76f4\u63a5\u4eba\u5de5\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setLaborCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal2 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u76f4\u63a5\u6750\u6599\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setMaterialCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal3 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u673a\u68b0\u4f7f\u7528\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setEquipmentCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal4 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u5176\u4ed6\u76f4\u63a5\u8d39".equals(en.getCostType())) {
                preBidCostCalc.setDirectCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal5 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u5916\u534f\u6210\u672c".equals(en.getCostType())) {
                preBidCostCalc.setCoalitionCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal6 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u5176\u4ed6\u8d39\u7528\u652f\u51fa".equals(en.getCostType())) {
                preBidCostCalc.setOtherCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                costNotaxTotal = costNotaxTotal.add(en.getMny());
                BigDecimal bigDecimal7 = var21_27.add(en.getMny());
                continue;
            }
            if ("\u589e\u503c\u7a0e\u53ca\u9644\u52a0".equals(en.getCostType())) {
                preBidCostCalc.setTaxCost(en.getMny());
                if (en.getMny() == null) continue;
                costTaxTotal = costTaxTotal.add(en.getMny());
                continue;
            }
            if ("\u4e0d\u542b\u7a0e\u6536\u5165".equals(en.getCostType())) {
                preBidCostCalc.setIncomeNotax(en.getMny());
                continue;
            }
            if (!"capitalCost".equals(en.getCostType())) continue;
            preBidCostCalc.setCapitalCost(en.getMny());
            if (en.getMny() == null) continue;
            BigDecimal bigDecimal8 = var21_27.add(en.getMny());
        }
        if (preBidCostCalc.getIncomeNotax() == null) {
            preBidCostCalc.setIncomeNotax(new BigDecimal(0));
            preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
        } else {
            MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
            projectProfitRate = preBidCostCalc.getIncomeNotax().subtract((BigDecimal)var21_27).divide(preBidCostCalc.getIncomeNotax(), mc).multiply(new BigDecimal(100));
            preBidCostCalc.setProjectProfitRate(projectProfitRate);
        }
        preBidCostCalc.setBillState(1);
        this.preBidCostCalcService.saveOrUpdate((Object)preBidCostCalc);
    }
}

