package com.ejianc.business.cost.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unchecked")
@Component
public class ProjectUtils {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IProjectApi projectApi;

    public List<Long> getProjectList(Long projectId){
        List<Long> pIds = new ArrayList<>();
        pIds.add(projectId);
        CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(pIds);
        List<Long> projectIds = new ArrayList<>();
        if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0) {
            ProjectRegisterVO pvo = pvos.getData().get(0);
            //获取
            CommonResponse<List<ProjectRegisterVO>> listResponse = projectApi.queryProjectByPid(pvo.getParentId());
            if(listResponse.isSuccess() && listResponse.getData()!=null && listResponse.getData().size()>0){
                for(ProjectRegisterVO vo : listResponse.getData()){
                    if(!vo.getId().equals(projectId)){
                        projectIds.add(vo.getId());
                    }
                }
            }
        }
        return projectIds;
    }
}
