package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractDetailMapper;
import com.ejianc.business.other.bean.OtherContractDetailEntity;
import com.ejianc.business.other.service.IOtherContractDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 其他支出合同清单
 *
 * @author generator
 */
@Service("otherContractDetailService")
public class OtherContractDetailServiceImpl extends BaseServiceImpl<OtherContractDetailMapper, OtherContractDetailEntity> implements IOtherContractDetailService {

    @Override
    public void deleteByContractId(Long contractId) {
        QueryWrapper<OtherContractDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", contractId);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public List<OtherContractDetailVO> detailRef(Long contractId) {
        QueryWrapper<OtherContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.ne("change_type", 5);//中止不显示
        List<OtherContractDetailEntity> entities = baseMapper.selectList(wrapper);
        return BeanMapper.mapList(entities, OtherContractDetailVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<OtherContractDetailVO> detailVoList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OtherContractDetailVO vo = new OtherContractDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";
                    vo.setId(IdWorker.getId());

                    if(StringUtils.isEmpty(datas.get(0))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"[清单编码为空]";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"[清单名称为空]";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(1));
                    }

                    vo.setUnit(datas.get(2));//计量单位

                    if (StringUtils.isEmpty(datas.get(3))) {
                        vo.setDetailTaxRate(null);
                    } else {
                        try {
                            vo.setDetailTaxRate(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            vo.setDetailTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setNum(null);
//                        warnType = warnType+"[工程量为空]";
//                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setDetailPrice(null);
                    } else {
                        try {
                            vo.setDetailPrice(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setDetailPrice(null);
                            warnType = warnType+"[单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setDetailTaxPrice(null);
                    } else {
                        try {
                            vo.setDetailTaxPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setDetailTaxPrice(null);
                            warnType = warnType+"[单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setDetailMny(null);
                    } else {
                        try {
                            vo.setDetailMny(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setDetailMny(null);
                            warnType = warnType+"[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setDetailTaxMny(null);
                    } else {
                        try {
                            vo.setDetailTaxMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setDetailTaxMny(null);
                            warnType = warnType+"[合价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setDetailTax(null);
                    } else {
                        try {
                            vo.setDetailTax(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setDetailTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setDetailMemo(datas.get(10));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }
                new TaxCalculateUtil<OtherContractDetailVO>().calculate(detailVoList);
                List<OtherContractDetailVO> successList = new ArrayList<>();
                List<OtherContractDetailVO> errorList = new ArrayList<>();
                for(OtherContractDetailVO vo :detailVoList){
                    if(vo.getImportFlag()){
                        successList.add(vo);
                    }else{
                        errorList.add(vo);
                    }
                }
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",successList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

	@Override
	public OtherContractDetailEntity querySumNum(Long id) {
		return baseMapper.querySumNum(id);
	}
}
