/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.material.service.IStatisticsService;
import com.ejianc.business.material.vo.MaterialCostVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/statistics/"})
public class StatisticsController {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStatisticsService statisticsService;
    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value={"queryInStoreDetailsPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryInStoreDetailsPageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        fuzzyFields.add("materialSupplierName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        return CommonResponse.success(this.statisticsService.queryInStoreDetailsPageList(param));
    }

    @RequestMapping(value={"excelExportInStoreDetailsList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportInStoreDetailsList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(10000000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryInStoreDetailsPageList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        if (ListUtil.isNotEmpty((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                Map vo = (Map)list.get(i);
                vo.put("instoreDate", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((Date)vo.get("instoreDate"))));
                vo.put("amount", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("amount"))));
                vo.put("unitPrice", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("unitPrice"))));
                vo.put("instoreNumber", ComputeUtil.scale(ComputeUtil.toBigDecimal(vo.get("instoreNumber")), 4));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("inStoreDetailListStatisticsExport.xlsx", beans, response);
    }

    @RequestMapping(value={"queryOutStoreDetailsPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryOutStoreDetailsPageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("useFor");
        fuzzyFields.add("memo");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialUnit");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialSupplierName");
        fuzzyFields.add("billCode");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        return CommonResponse.success(this.statisticsService.queryOutStoreDetailsPageList(param));
    }

    @RequestMapping(value={"excelExportOutStoreDetailsList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportOutStoreDetailsList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(10000000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryOutStoreDetailsPageList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        if (ListUtil.isNotEmpty((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                Map vo = (Map)list.get(i);
                vo.put("outDate", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((Date)vo.get("outDate"))));
                vo.put("amount", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("amount"))));
                vo.put("unitPrice", ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(vo.get("unitPrice"))));
                vo.put("outStoreNumber", ComputeUtil.scale(ComputeUtil.toBigDecimal(vo.get("outStoreNumber")), 4));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outStoreDetailListStatisticsExport.xlsx", beans, response);
    }

    @RequestMapping(value={"queryInOutStorePageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryInOutStorePageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("m.useFor");
        fuzzyFields.add("m.memo");
        fuzzyFields.add("m.orgName");
        fuzzyFields.add("m.supplierName");
        fuzzyFields.add("m.storeName");
        fuzzyFields.add("s.materialCategoryName");
        fuzzyFields.add("s.materialSpec");
        fuzzyFields.add("s.materialName");
        fuzzyFields.add("s.materialUnit");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        return CommonResponse.success(this.statisticsService.queryInOutStorePageList(param));
    }

    @RequestMapping(value={"queryInOutStoreMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryInOutStoreMaterialList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("m.useFor");
        fuzzyFields.add("m.memo");
        fuzzyFields.add("m.orgName");
        fuzzyFields.add("m.supplierName");
        fuzzyFields.add("m.storeName");
        fuzzyFields.add("s.materialCategoryName");
        fuzzyFields.add("s.materialSpec");
        fuzzyFields.add("s.materialName");
        fuzzyFields.add("s.materialUnit");
        return CommonResponse.success(this.statisticsService.queryInOutStoreMaterialList(param));
    }

    @RequestMapping(value={"excelInOutStoreMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelInOutStoreMaterialList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryInOutStoreMaterialList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", ((IPage)voPage.getData()).getRecords());
        ExcelExport.getInstance().export("excelInOutStoreMaterialList.xlsx", beans, response);
    }

    @RequestMapping(value={"excelExportInAndOutStoreList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryInOutStorePageList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        if (ListUtil.isNotEmpty((List)list)) {
            int i;
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 10));
            XSSFRow row = sheet.createRow(0);
            XSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u7269\u8d44\u51fa\u5165\u5e93\u6c47\u603b");
            cell.setCellStyle((CellStyle)style);
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("\u6240\u5c5e\u7ec4\u7ec7");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(1);
            cell.setCellValue("\u4ed3\u5e93");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellValue("\u7269\u8d44\u5206\u7c7b");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(3);
            cell.setCellValue("\u7269\u8d44\u540d\u79f0");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u89c4\u683c\u578b\u53f7");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(5);
            cell.setCellValue("\u8ba1\u91cf\u5355\u4f4d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(6);
            cell.setCellValue("\u4f9b\u5e94\u5546");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(7);
            cell.setCellValue("\u91c7\u8d2d\u4ef7");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(8);
            cell.setCellValue("\u5165\u5e93\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(9);
            cell.setCellValue("\u51fa\u5e93\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(10);
            cell.setCellValue("\u7ed3\u5b58\u91cf");
            cell.setCellStyle((CellStyle)style);
            for (i = 0; i < 11; ++i) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
            }
            for (i = 0; i < list.size(); ++i) {
                Map vo = (Map)list.get(i);
                row = sheet.createRow(i + 2);
                if ((Integer)vo.get("newKeyRowSpan") > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.get("orgName") == null ? "" : vo.get("orgName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 0, 0));
                    cell = row.createCell(1);
                    cell.setCellValue(vo.get("storeName") == null ? "" : vo.get("storeName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 1, 1));
                    cell = row.createCell(2);
                    cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 2, 2));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 3, 3));
                    cell = row.createCell(4);
                    cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 4, 4));
                    cell = row.createCell(5);
                    cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 5, 5));
                    cell = row.createCell(9);
                    cell.setCellValue(vo.get("outStoreNumber") == null ? "" : vo.get("outStoreNumber").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 9, 9));
                    cell = row.createCell(10);
                    cell.setCellValue(vo.get("surplusNumber") == null ? "" : vo.get("surplusNumber").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("newKeyRowSpan") - 1, 10, 10));
                }
                cell = row.createCell(6);
                cell.setCellValue(vo.get("supplierName") != null ? vo.get("supplierName").toString() : null);
                if (null != vo.get("supplyRowSpan") && (Integer)vo.get("supplyRowSpan") > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("supplyRowSpan") - 1, 6, 6));
                }
                cell = row.createCell(7);
                cell.setCellValue(vo.get("unitPrice") != null ? vo.get("unitPrice").toString() : null);
                cell = row.createCell(8);
                cell.setCellValue(vo.get("instoreNumber") != null ? vo.get("instoreNumber").toString() : null);
                if (null == vo.get("priceRowSpan") || (Integer)vo.get("priceRowSpan") <= 0) continue;
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("priceRowSpan") - 1, 7, 7));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("priceRowSpan") - 1, 8, 8));
            }
            workbook.write((OutputStream)outputStream);
        }
    }

    @RequestMapping(value={"queryPlanInOutStorePageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryPlanInOutStorePageList(@RequestBody QueryParam param) {
        return CommonResponse.success(this.statisticsService.queryPlanInOutStorePageList(param));
    }

    @RequestMapping(value={"queryPlanInOutStorePageListSum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPlanInOutStorePageListSum(@RequestBody QueryParam param) {
        return CommonResponse.success((Object)this.statisticsService.queryPlanInOutStorePageListSum(param));
    }

    @RequestMapping(value={"excelExportDosageComparisonList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDosageComparisonList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryPlanInOutStorePageList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        if (ListUtil.isNotEmpty((List)list)) {
            int i;
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 3, 0, 3);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
            XSSFRow row = sheet.createRow(0);
            XSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
            style.setBorderBottom((short)1);
            style.setBorderTop((short)1);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u9879\u76ee\u6750\u6599\u7528\u91cf\u5bf9\u6bd4");
            cell.setCellStyle((CellStyle)style);
            for (i = 1; i < 8; ++i) {
                cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style);
            }
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("\u7269\u8d44");
            cell.setCellStyle((CellStyle)style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 3));
            cell = row.createCell(1);
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(3);
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u603b\u8ba1\u5212");
            cell.setCellStyle((CellStyle)style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 4));
            cell = row.createCell(5);
            cell.setCellValue("\u7528\u6599\u7533\u8bf7");
            cell.setCellStyle((CellStyle)style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 5, 5));
            cell = row.createCell(6);
            cell.setCellValue("\u6750\u6599\u5165\u5e93");
            cell.setCellStyle((CellStyle)style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 6));
            cell = row.createCell(7);
            cell.setCellValue("\u6750\u6599\u51fa\u5e93");
            cell.setCellStyle((CellStyle)style);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 7));
            row = sheet.createRow(2);
            cell = row.createCell(0);
            cell.setCellValue("\u5206\u7c7b");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(1);
            cell.setCellValue("\u7269\u8d44\u540d\u79f0");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellValue("\u89c4\u683c\u578b\u53f7");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(3);
            cell.setCellValue("\u8ba1\u91cf\u5355\u4f4d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u8ba1\u5212\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(5);
            cell.setCellValue("\u7533\u8bf7\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(6);
            cell.setCellValue("\u5165\u5e93\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(7);
            cell.setCellValue("\u51fa\u5e93\u6570\u91cf");
            cell.setCellStyle((CellStyle)style);
            for (i = 0; i < 8; ++i) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 8);
            }
            for (i = 0; i < list.size(); ++i) {
                Map vo = (Map)list.get(i);
                row = sheet.createRow(i + 3);
                if ((Integer)vo.get("materialRowSpan") > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 0, 0));
                    cell = row.createCell(1);
                    cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 1, 1));
                    cell = row.createCell(2);
                    cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 2, 2));
                    cell = row.createCell(3);
                    cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 3, 3));
                    if (vo.get("pNum") != null) {
                        cell = row.createCell(4);
                        cell.setCellValue(Double.parseDouble(vo.get("pNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 4, 4));
                    } else {
                        cell = row.createCell(4);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 4, 4));
                    }
                    if (vo.get("aNum") != null) {
                        cell = row.createCell(5);
                        cell.setCellValue(Double.parseDouble(vo.get("aNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 5, 5));
                    } else {
                        cell = row.createCell(5);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 5, 5));
                    }
                    if (vo.get("oNum") != null) {
                        cell = row.createCell(7);
                        cell.setCellValue(Double.parseDouble(vo.get("oNum").toString()));
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 7, 7));
                    } else {
                        cell = row.createCell(7);
                        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 7, 7));
                    }
                }
                if ((Integer)vo.get("iUnitPriceRowSpan") <= 0) continue;
                if (vo.get("iNum") != null) {
                    cell = row.createCell(6);
                    cell.setCellValue(Double.parseDouble(vo.get("iNum").toString()));
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 6, 6));
                    continue;
                }
                cell = row.createCell(6);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 6, 6));
            }
            workbook.write((OutputStream)outputStream);
        }
    }

    @RequestMapping(value={"excelExportPlanInAndOutStoreList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportPlanInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        int i;
        param.setPageSize(100000);
        param.setPageIndex(1);
        CommonResponse<IPage<JSONObject>> voPage = this.queryPlanInOutStorePageList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 3, 0, 3);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 15));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("\u8ba1\u5212\u4e0e\u51fa\u5165\u5e93\u5bf9\u6bd4");
        cell.setCellStyle((CellStyle)style);
        for (i = 1; i < 16; ++i) {
            cell = row.createCell(i);
            cell.setCellStyle((CellStyle)style);
        }
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("\u7269\u8d44");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 3));
        cell = row.createCell(1);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(4);
        cell.setCellValue("\u603b\u8ba1\u5212");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 6));
        cell = row.createCell(5);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(6);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(7);
        cell.setCellValue("\u7528\u6599\u7533\u8bf7");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 8));
        cell = row.createCell(8);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(9);
        cell.setCellValue("\u91c7\u8d2d\u5408\u540c");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 9, 10));
        cell = row.createCell(10);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(11);
        cell.setCellValue("\u6750\u6599\u5165\u5e93");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 11, 13));
        cell = row.createCell(12);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(13);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(14);
        cell.setCellValue("\u6750\u6599\u51fa\u5e93");
        cell.setCellStyle((CellStyle)style);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 14, 15));
        cell = row.createCell(15);
        cell.setCellStyle((CellStyle)style);
        row = sheet.createRow(2);
        cell = row.createCell(0);
        cell.setCellValue("\u5206\u7c7b");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(1);
        cell.setCellValue("\u7269\u8d44\u540d\u79f0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellValue("\u89c4\u683c\u578b\u53f7");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(3);
        cell.setCellValue("\u8ba1\u91cf\u5355\u4f4d");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(4);
        cell.setCellValue("\u8ba1\u5212\u6570\u91cf");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(5);
        cell.setCellValue("\u6682\u4f30\u5355\u4ef7");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(6);
        cell.setCellValue("\u6682\u4f30\u91d1\u989d");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(7);
        cell.setCellValue("\u7533\u8bf7\u6570\u91cf");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(8);
        cell.setCellValue("\u7533\u8bf7\u91d1\u989d");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(9);
        cell.setCellValue("\u7533\u8bf7\u6570\u91cf");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(10);
        cell.setCellValue("\u7533\u8bf7\u91d1\u989d");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(11);
        cell.setCellValue("\u5165\u5e93\u6570\u91cf");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(12);
        cell.setCellValue("\u5165\u5e93\u5355\u4ef7");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(13);
        cell.setCellValue("\u5165\u5e93\u91d1\u989d");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(14);
        cell.setCellValue("\u51fa\u5e93\u6570\u91cf");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(15);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue("\u51fa\u5e93\u91d1\u989d");
        for (i = 0; i < 13; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 13);
        }
        for (i = 0; i < list.size(); ++i) {
            Map vo = (Map)list.get(i);
            row = sheet.createRow(i + 3);
            if ((Integer)vo.get("materialRowSpan") <= 0) continue;
            cell = row.createCell(0);
            cell.setCellValue(vo.get("materialCategoryName") == null ? "" : vo.get("materialCategoryName").toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 0, 0));
            cell = row.createCell(1);
            cell.setCellValue(vo.get("materialName") == null ? "" : vo.get("materialName").toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 1, 1));
            cell = row.createCell(2);
            cell.setCellValue(vo.get("materialSpec") == null ? "" : vo.get("materialSpec").toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 2, 2));
            cell = row.createCell(3);
            cell.setCellValue(vo.get("materialUnit") == null ? "" : vo.get("materialUnit").toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 3, 3));
            if (vo.get("pNum") != null) {
                cell = row.createCell(4);
                cell.setCellValue(vo.get("pNum").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 4, 4));
                cell = row.createCell(5);
                cell.setCellValue(vo.get("pPrice") != null ? vo.get("pPrice").toString() : null);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 5, 5));
                cell = row.createCell(6);
                cell.setCellValue(vo.get("pAmount").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 6, 6));
            } else {
                cell = row.createCell(4);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 4, 4));
                cell = row.createCell(5);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 5, 5));
                cell = row.createCell(6);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 6, 6));
            }
            if (vo.get("aNum") != null) {
                cell = row.createCell(7);
                cell.setCellValue(vo.get("aNum").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 7, 7));
                cell = row.createCell(8);
                cell.setCellValue(vo.get("aAmount").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 8, 8));
            } else {
                cell = row.createCell(7);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 7, 7));
                cell = row.createCell(8);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 8, 8));
            }
            if (vo.get("cNum") != null) {
                cell = row.createCell(9);
                cell.setCellValue(vo.get("cNum").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 9, 9));
                cell = row.createCell(10);
                cell.setCellValue(vo.get("cAmount").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 10, 10));
            } else {
                cell = row.createCell(9);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 9, 9));
                cell = row.createCell(10);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 10, 10));
            }
            if ((Integer)vo.get("iUnitPriceRowSpan") <= 0) continue;
            if (vo.get("iNum") != null) {
                cell = row.createCell(11);
                cell.setCellValue(vo.get("iNum").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 11, 11));
                cell = row.createCell(12);
                cell.setCellValue(vo.get("iUnitPrice") != null ? vo.get("iUnitPrice").toString() : null);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 12, 12));
                cell = row.createCell(13);
                cell.setCellValue(vo.get("iAmount").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 13, 13));
            } else {
                cell = row.createCell(11);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 11, 11));
                cell = row.createCell(12);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 12, 12));
                cell = row.createCell(13);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("iUnitPriceRowSpan") - 1, 13, 13));
            }
            if (vo.get("oNum") != null) {
                cell = row.createCell(14);
                cell.setCellValue(vo.get("oNum").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 12, 12));
                cell = row.createCell(15);
                cell.setCellValue(vo.get("oAmount").toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 13, 13));
                continue;
            }
            cell = row.createCell(14);
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 12, 12));
            cell = row.createCell(15);
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (Integer)vo.get("materialRowSpan") - 1, 13, 13));
        }
        workbook.write((OutputStream)outputStream);
    }

    @RequestMapping(value={"queryMaterialViewBoardByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryMaterialViewBoardByProjectId(@RequestParam Long projectId) {
        return this.statisticsService.queryMaterialViewBoardByProjectId(projectId);
    }

    @RequestMapping(value={"queryMaterialCostByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialCostVO> queryMaterialCostByProjectId(@RequestParam Long projectId) {
        return this.statisticsService.queryMaterialCostByProjectId(projectId);
    }
}

