package com.ejianc.business.market.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.market.vo.PermitSafeDetailVO;
import com.ejianc.business.market.vo.PermitAirDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 有限空间作业许可证
 * 
 * @author generator
 * 
 */
public class SpacePermitVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date beginDate; // 开工时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endDate; // 结束时间
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Long employeeId; // 验收人
    private String employeeName; // 验收人
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String applyTeam; // 申请班组
    private String applyPeople; // 申请人员(现场负责人员)
    private String teamPhone; // 班组联系电话
    private String overseePeople; // 监护人员
    private String overseePhone; // 监护人电话
    private String workPeople; // 作业人员
    private String managerPhone; // 项目负责人或安全员联系电话
    private String memo; // 作业区域、内容
    private String remark; // 作业主要危险因素
    private String employeeMemo; // 验收人(现场负责人)意见
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date employeeDate; // 验收日期
    
    private List<PermitSafeDetailVO> permitSafeDetailList = new ArrayList<>(); // 有限空间作业许可证-作业安全措施确认
    private List<PermitAirDetailVO> permitAirDetailList = new ArrayList<>(); // 有限空间作业许可证-作业人员气体检测

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getApplyTeam() {
        return applyTeam;
    }

    public void setApplyTeam(String applyTeam) {
        this.applyTeam = applyTeam;
    }
    public String getApplyPeople() {
        return applyPeople;
    }

    public void setApplyPeople(String applyPeople) {
        this.applyPeople = applyPeople;
    }
    public String getTeamPhone() {
        return teamPhone;
    }

    public void setTeamPhone(String teamPhone) {
        this.teamPhone = teamPhone;
    }
    public String getOverseePeople() {
        return overseePeople;
    }

    public void setOverseePeople(String overseePeople) {
        this.overseePeople = overseePeople;
    }
    public String getOverseePhone() {
        return overseePhone;
    }

    public void setOverseePhone(String overseePhone) {
        this.overseePhone = overseePhone;
    }
    public String getWorkPeople() {
        return workPeople;
    }

    public void setWorkPeople(String workPeople) {
        this.workPeople = workPeople;
    }
    public String getManagerPhone() {
        return managerPhone;
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getEmployeeMemo() {
        return employeeMemo;
    }

    public void setEmployeeMemo(String employeeMemo) {
        this.employeeMemo = employeeMemo;
    }
    public Date getEmployeeDate() {
        return employeeDate;
    }

    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }
    
     public List<PermitSafeDetailVO> getPermitSafeDetailList() {
        return permitSafeDetailList;
     }

     public void setPermitSafeDetailList(List<PermitSafeDetailVO> permitSafeDetailList) {
        this.permitSafeDetailList = permitSafeDetailList;
     }
     public List<PermitAirDetailVO> getPermitAirDetailList() {
        return permitAirDetailList;
     }

     public void setPermitAirDetailList(List<PermitAirDetailVO> permitAirDetailList) {
        this.permitAirDetailList = permitAirDetailList;
     }
}
