/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subSettle")
public class SubSettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BigDecimal sumOffsetMnys;
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        SubSettleEntity settlementEntity = (SubSettleEntity)((Object)this.settleService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal sumPayMnys = settlementEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settlementEntity.getSumPrepayMny();
        BigDecimal bigDecimal = sumOffsetMnys = settlementEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getSumOffsetMny();
        if (offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys)) > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SubSettleVO settleEntity = this.settleService.queryDetail(billId, true);
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SubContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(SubContractEntity::getSumSettleMny, (Object)sumSettleMny.add(settleMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(SubContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(SubContractEntity::getSumOtherMny, (Object)sumOtherMny.add(otherMny));
        updateWrapper.set(SubContractEntity::getSumOffsetMny, (Object)sumOffsetMny.add(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        this.settleService.costPush((SubSettleEntity)((Object)BeanMapper.map((Object)((Object)settleEntity), SubSettleEntity.class)));
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SubSettleEntity settlementEntity = (SubSettleEntity)((Object)this.settleService.selectById(billId));
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.selectById(settlementEntity.getContractId()));
        if (contractEntity.getFinishFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u56de\u9000!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(SubSettleEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange.eq(SubSettleEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange.gt(BaseEntity::getCreateTime, (Object)settlementEntity.getCreateTime());
            lambdachange.ne(BaseEntity::getId, (Object)billId);
            lambdachange.in(SubSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            int num = this.settleService.count((Wrapper)lambdachange);
            if (num > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u4e0d\u662f\u6700\u65b0\u7684\u7ed3\u7b97\u65e5\u671f\uff0c\u4e0d\u80fd\u56de\u9000!");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SubSettleVO settleEntity = this.settleService.queryDetail(billId, true);
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SubContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(SubContractEntity::getSumSettleMny, (Object)sumSettleMny.subtract(settleMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(SubContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(SubContractEntity::getSumOtherMny, (Object)sumOtherMny.subtract(otherMny));
        updateWrapper.set(SubContractEntity::getSumOffsetMny, (Object)sumOffsetMny.subtract(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        this.settleService.pullCost(billId);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }
}

