/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.history.ClaimHistoryVo;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.vo.ClaimVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/claim"})
public class ClaimController {
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClaimEntity>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("changeSummary");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage claimEntityIPage = this.claimService.queryPage(param, false);
        claimEntityIPage.getRecords();
        for (ClaimEntity ce : claimEntityIPage.getRecords()) {
            if (null != ce.getChangeType()) {
                if (1 == ce.getChangeType()) {
                    ce.setChangeTypeName("\u73b0\u573a\u7b7e\u8bc1");
                    continue;
                }
                if (2 == ce.getChangeType()) {
                    ce.setChangeTypeName("\u53d8\u66f4\u6d3d\u5546");
                    continue;
                }
                if (3 != ce.getChangeType()) continue;
                ce.setChangeTypeName("\u7d22\u8d54");
                continue;
            }
            ce.setChangeTypeName("");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)claimEntityIPage);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimVo> saveOrUpdate(@RequestBody ClaimVo claimVo) {
        CommonResponse<ClaimVo> response = this.claimService.saveOrUpdate(claimVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimVo> queryDetail(@RequestParam Long id) {
        ClaimVo vo = this.claimService.queryDetail(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVo> vos) {
        this.claimService.deleteClaim(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ClaimEntity>> queryRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        IPage iPage;
        List records;
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("changeSummary");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap2 = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap2.get("contractId")) {
                queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap2.get("contractId")));
            }
            if (null != conditionMap2.get("projectId")) {
                queryParam.getParams().put("projectId", new Parameter("eq", conditionMap2.get("projectId")));
            }
        }
        queryParam.getOrderMap().put("occurDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("type")) {
            if (conditionMap.get("type").equals("production")) {
                wrapper.apply("(reply_mny > sum_production_mny or reply_mny < 0)", new Object[0]);
            }
            if (conditionMap.get("type").equals("quote")) {
                wrapper.apply("(reply_mny > sum_quote_mny or reply_mny < 0)", new Object[0]);
            }
        }
        if (null != (records = (iPage = this.claimService.selectPage((Page<ClaimEntity>)page, wrapper)).getRecords()) && records.size() > 0) {
            for (ClaimEntity ce : records) {
                if (null != ce.getChangeType()) {
                    if (1 == ce.getChangeType()) {
                        ce.setChangeTypeName("\u73b0\u573a\u7b7e\u8bc1");
                        continue;
                    }
                    if (2 == ce.getChangeType()) {
                        ce.setChangeTypeName("\u53d8\u66f4\u6d3d\u5546");
                        continue;
                    }
                    if (3 != ce.getChangeType()) continue;
                    ce.setChangeTypeName("\u7d22\u8d54");
                    continue;
                }
                ce.setChangeTypeName("");
            }
            iPage.setRecords(records);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)iPage);
    }

    @RequestMapping(value={"/queryClaimHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimHistoryVo> queryClaimHistory(@RequestParam Long id) {
        ClaimHistoryVo vo = this.claimService.queryClaimHistory(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("changeSummary");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.claimService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ClaimVo.class);
            list.forEach(vo -> {
                if (null != vo.getChangeType()) {
                    if (1 == vo.getChangeType()) {
                        vo.setChangeTypeName("\u73b0\u573a\u7b7e\u8bc1");
                    } else if (2 == vo.getChangeType()) {
                        vo.setChangeTypeName("\u53d8\u66f4\u6d3d\u5546");
                    } else if (3 == vo.getChangeType()) {
                        vo.setChangeTypeName("\u7d22\u8d54");
                    } else if (4 == vo.getChangeType()) {
                        vo.setChangeTypeName("\u5546\u52a1\u7b56\u5212");
                    }
                } else {
                    vo.setChangeTypeName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("claim-export.xlsx", beans, response);
    }
}

