/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractDetailRefVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contract/detail"})
public class ContractDetailController {
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService contractService;

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contract-detail-import.xlsx", (String)"\u5408\u540c\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.contractDetailService.excelImport(request, response);
    }

    @RequestMapping(value={"/detailRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractDetailVo>> detailRef(@RequestParam(value="contractId") Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", this.contractDetailService.detailRef(contractId));
    }

    @RequestMapping(value={"/refContractMaterialDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractDetailRefVo>> refContractMaterialDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(ContractEntity::getProjectId, (Object)projectId);
                List list = this.contractService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    List contractIds = list.stream().map(t2 -> t2.getId()).collect(Collectors.toList());
                    param.getParams().put("contractId", new Parameter("in", contractIds));
                } else {
                    param.getParams().put("contractId", new Parameter("eq", (Object)1L));
                }
            } else {
                throw new BusinessException("\u9879\u76eeid\u662f\u5fc5\u4f20\u6761\u4ef6\uff01");
            }
        }
        param.getParams().put("materialId", new Parameter("ne", null));
        param.getParams().put("changeType", new Parameter("ne", (Object)5));
        param.getOrderMap().put("detailIndex", "asc");
        IPage page = this.contractDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractDetailRefVo.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u65bd\u5de5\u5408\u540c\u7269\u8d44\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

