/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.othprice.bean.OtherApplyEntity;
import com.ejianc.business.othprice.bean.OtherApplySubEntity;
import com.ejianc.business.othprice.service.IOtherApplyService;
import com.ejianc.business.othprice.vo.OtherApplySubVO;
import com.ejianc.business.othprice.vo.OtherApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"otherApply"})
public class OtherApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "OTHER_APPLY";
    @Autowired
    private IOtherApplyService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherApplyVO> saveOrUpdate(@RequestBody OtherApplyVO saveOrUpdateVO) {
        OtherApplyEntity entity = (OtherApplyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), OtherApplyEntity.class));
        String billCode = entity.getBillCode();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billCode)) {
            Long id = entity.getId();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.eq(OtherApplyEntity::getBillCode, (Object)billCode);
            queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
            int count = this.service.count((Wrapper)queryWrapper);
            if (count > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\u91cd\u590d");
            }
        } else {
            CommonResponse billCodeRes = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCodeRes.isSuccess()) {
                entity.setBillCode((String)billCodeRes.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<OtherApplySubEntity> materialDetailList = entity.getOtherApplySubList();
        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            String materialTypeNames = "";
            HashSet<String> materialTypeNamesSet = new HashSet<String>();
            for (OtherApplySubEntity materialContractDetailSubVO : materialDetailList) {
                if ("del".equals(materialContractDetailSubVO.getRowState())) continue;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)materialTypeNames)) {
                    if (materialTypeNamesSet.contains(materialContractDetailSubVO.getDetailName())) continue;
                    materialTypeNames = materialTypeNames + "\u3001" + materialContractDetailSubVO.getDetailName();
                    materialTypeNamesSet.add(materialContractDetailSubVO.getDetailName());
                    continue;
                }
                materialTypeNames = materialTypeNames + materialContractDetailSubVO.getDetailName();
                materialTypeNamesSet.add(materialContractDetailSubVO.getDetailName());
            }
            entity.setDetailNames(materialTypeNames);
        }
        this.service.saveOrUpdate((Object)entity, false);
        OtherApplyVO vo = (OtherApplyVO)((Object)BeanMapper.map((Object)((Object)entity), OtherApplyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherApplyVO> queryDetail(Long id) {
        OtherApplyEntity entity = (OtherApplyEntity)((Object)this.service.selectById(id));
        OtherApplyVO vo = (OtherApplyVO)((Object)BeanMapper.map((Object)((Object)entity), OtherApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OtherApplyVO otherApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OtherApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "applyTitle", "name", "projectName", "detailNames", "applyPerson"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "applyTitle", "name", "projectName", "detailNames", "applyPerson"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("OtherApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"other-apply-import.xlsx", (String)"\u5176\u4ed6\u8be2\u4ef7\u7533\u8bf7\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<OtherApplySubVO> successList = new ArrayList<OtherApplySubVO>();
        ArrayList<OtherApplySubVO> errorList = new ArrayList<OtherApplySubVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 6) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                OtherApplySubVO otherApplySubVO = new OtherApplySubVO();
                otherApplySubVO.setCode(((String)datas.get(0)).trim());
                otherApplySubVO.setDetailName(((String)datas.get(1)).trim());
                otherApplySubVO.setModel(((String)datas.get(2)).trim());
                otherApplySubVO.setUnit(((String)datas.get(3)).trim());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    try {
                        otherApplySubVO.setApplyNum(ComputeUtil.scale((BigDecimal)new BigDecimal((String)datas.get(4)), (int)8));
                    }
                    catch (Exception e) {
                        otherApplySubVO.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                otherApplySubVO.setRemark((String)datas.get(5));
                if (StringUtils.isNotEmpty((String)otherApplySubVO.getErrorMessage())) {
                    errorList.add(otherApplySubVO);
                    continue;
                }
                successList.add(otherApplySubVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (StringUtils.isEmpty((String)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "applyTitle", "name", "projectName", "detailNames", "applyPerson"));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (OtherApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List<OtherApplySubVO> subVOList = this.service.queryApplySubList(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(subVOList)) continue;
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherApplySubVO>> refdata(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map param = queryParam.getParams();
        boolean queryAllFlag = false;
        if (!StringUtils.isEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter("eq", (Object)pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<OtherApplySubVO> list = null;
        if (queryAllFlag) {
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
            Long projectId = conditionJson.getLong("projectId");
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter("gt", (Object)0));
            list = this.service.queryAllApplyData((IPage<OtherApplySubVO>)pageData, queryParam, projectId);
        } else {
            list = this.service.queryApplySubList((IPage<OtherApplySubVO>)pageData, queryParam);
        }
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/refOtherApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherApplyVO>> refOtherApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

