package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:10
 */
@Service(value = "materialMasterPlanService")
public class MaterialMasterPlanServiceImpl extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity> implements IMaterialMasterPlanService {

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;

    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741"; // 【预算材料费总金额】 控 【物资总计划金额】
    private static final String PARAM_NUM = "P-uFOcn644"; // 预算材料清单量控
    private static final String PARAM_TAX_MNY = "P-14dTg745"; // 预算材料清单金额控
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if (null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        //更新子表信息
        if (null != saveEntity.getId()) {
            materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate(saveEntity, false);
        return saveEntity;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    /**
     * 参数控制
     *
     * @param vo 物资总计划vo
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        // 【预算材料费总金额】 控 【物资总计划金额】
        // 预算材料费总金额
        // 没有预算不控制，预算不包含不控制

        // 预算材料清单量控、预算材料清单金额控
        List<PlanControlSubVO> materialSubList = vo.getPlanControlSubVOList();
        // 物资总计划没有物资明细，不控制直接返回
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            // 没有预算清单不控制
            List<Long> subIds = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
            // 预算材料清单量
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

}
