package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.PreBidCostCalcDetailEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcDetailService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.cost.vo.PreBidCostCalcVO;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 同步数据
 * 
 * @author generator
 * 
 */
@Service("syncService")
public class SyncServiceImpl implements ISyncService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IPreBidCostCalcDetailService preBidCostCalcDetailService;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;

    @Override
    public void syncProject(SyncProjectVO projectVO) {

        QueryWrapper<PreBidCostCalcEntity> preBidCostCalcWrapper = new QueryWrapper<>();
        preBidCostCalcWrapper.eq("source_id", projectVO.getProjectId());
        PreBidCostCalcEntity preBidCostCalc = preBidCostCalcService.getOne(preBidCostCalcWrapper);
        if(preBidCostCalc == null) {
            preBidCostCalc = new PreBidCostCalcEntity();
            preBidCostCalc.setId(IdWorker.getId());
        }
        //先查询合同信息
        QueryWrapper<ContractEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_id", projectVO.getProjectContractCode());
        List<ContractEntity> contractList = contractService.list(wrapper);
        ContractEntity contract = null;
        if(contractList!=null && contractList.size()>0){
            contract = contractList.get(0);
            contract.setContractName(projectVO.getProjectContractName());
            contract.setSignDate(projectVO.getSignDate());
            contract.setContractMny(projectVO.getContractMny());
        }else{
            contract = new ContractEntity();
            contract.setId(IdWorker.getId());
            contract.setBillCode(projectVO.getProjectContractCode());
            contract.setContractName(projectVO.getProjectContractName());
            contract.setSignDate(projectVO.getSignDate());
            contract.setContractMny(projectVO.getContractMny());
            contract.setSourceId(projectVO.getProjectContractCode());
        }
        CommonResponse<List<DefdocDetailVO>> defAssetTypeList = defdocApi.getDefDocByDefCode("zydx_project_type");
        Map<String, DefdocDetailVO> defdocMap = new HashMap<>();
        if(defAssetTypeList.isSuccess() && defAssetTypeList.getData()!=null && defAssetTypeList.getData().size()>0){
            for (DefdocDetailVO datum : defAssetTypeList.getData()) {
                defdocMap.put(datum.getName(), datum);
            }
        }
        CommonResponse<OrgVO> orgResponse = iOrgApi.findBySourceId(projectVO.getProjectOrgId());
        OrgVO orgVO = null;
        if(orgResponse.isSuccess() && orgResponse.getData()!=null){
            orgVO = orgResponse.getData();
        }else{
            throw new BusinessException("未获取到项目所属组织信息，请先确认组织是否同步");
        }
        ProjectRegisterVO project = new ProjectRegisterVO();
        project.setSourceId(projectVO.getProjectId());
        project.setOrgId(orgVO.getId());
        project.setOrgName(orgVO.getName());
        project.setCode(projectVO.getProjectCode());
        project.setName(projectVO.getProjectCode());
        project.setProjectType(defdocMap.get(projectVO.getProjectType())!=null?defdocMap.get(projectVO.getProjectType()).getId():null);
        project.setProjectTypeName(projectVO.getProjectType());
        project.setProjectSource(projectVO.getProjectSource());
        project.setInternalCooperationProject(projectVO.getInternalCooperationProject());
        project.setFirstBusiness(projectVO.getFirstBusiness());
        project.setSecondBusiness(projectVO.getSecondBusiness());
        project.setProjectOverview(projectVO.getProjectOverview());
        project.setAddress(projectVO.getProjectAddress());
        project.setIncomeArea(projectVO.getProjectAddress());
        project.setContractId(contract.getId());
        project.setSignDate(projectVO.getSignDate());
        project.setContractMny(projectVO.getContractMny());
        project.setStatus(projectVO.getState()!=null?projectVO.getState().toString():"0");
        project.setBillState(1);
        //同步客户数据
        CommonResponse<List<DefdocDetailVO>> taxTypeList = defdocApi.getDefDocByDefCode("tax_payer_type");
        Map<String, DefdocDetailVO> taxTypecMap = new HashMap<>();
        if(taxTypeList.isSuccess() && taxTypeList.getData()!=null && taxTypeList.getData().size()>0){
            for (DefdocDetailVO datum : taxTypeList.getData()) {
                taxTypecMap.put(datum.getName(), datum);
            }
        }
        CustomerVO customerVO = new CustomerVO();
        customerVO.setSourceId(projectVO.getCustomerId());
        customerVO.setCode(projectVO.getCustomerCode());
        customerVO.setName(projectVO.getCustomerName());
        customerVO.setSocialCreditCode(projectVO.getSocialCreditCode());
        customerVO.setTaxPayerTypeName(projectVO.getTaxType());
        customerVO.setTaxPayerType(taxTypecMap.get(projectVO.getTaxType())!=null?taxTypecMap.get(projectVO.getTaxType()).getId():null);
        customerVO.setAddress(projectVO.getCustomerAddress());
        customerVO.setBankAccount(projectVO.getBankAccount());
        customerVO.setBankCode(projectVO.getBankCode());
        customerVO.setBankName(projectVO.getBankName());
        customerVO.setLegal(projectVO.getLinker());
        customerVO.setTelephone(projectVO.getCellphone());
        CommonResponse<CustomerVO> customerResponse = customerApi.syncCustomer(customerVO);
        if(customerResponse.isSuccess()){
            customerVO = customerResponse.getData();
        }else{
            logger.info("同步客户数据失败：{}",customerResponse.getMsg());
        }
        project.setPubUnit(customerVO.getId());
        project.setPubUnitName(projectVO.getCustomerName());
        project.setBidCostId(preBidCostCalc.getId());

        CommonResponse<ProjectRegisterVO> pro = projectApi.syncProject(project);
        if(pro.isSuccess()){
            contract.setProjectId(pro.getData().getId());
            contract.setProjectName(pro.getData().getName());
            contract.setOrgId(pro.getData().getProjectDepartmentId());
            preBidCostCalc.setProjectId(pro.getData().getId());
            preBidCostCalc.setProjectDepartmentId(pro.getData().getProjectDepartmentId());
            preBidCostCalc.setOrgId(pro.getData().getOrgId());
        }else{
            throw new BusinessException(pro.getMsg());
        }
        contractService.saveOrUpdate(contract, false);

        if(preBidCostCalc.getSourceId() == null){
            preBidCostCalc.setProjectName(project.getName());
            preBidCostCalc.setPubUnitName(projectVO.getCustomerName());
            preBidCostCalc.setSourceId(projectVO.getProjectId());
            BillCodeParam billCodeParam = BillCodeParam.build("PreBidCostCalc", InvocationInfoProxy.getTenantid(), BeanMapper.map(preBidCostCalc, PreBidCostCalcVO.class));
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                preBidCostCalc.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            List<PreBidCostCalcDetailVO> detailList = projectVO.getPreBidCostCalcDetailList();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                preBidCostCalcDetailVO.setRowState("add");
            }
            preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
        }else{
            QueryWrapper<PreBidCostCalcDetailEntity> deWrapper = new QueryWrapper<>();
            deWrapper.eq("pid", preBidCostCalc.getId());
            List<PreBidCostCalcDetailEntity> deList = preBidCostCalcDetailService.list(deWrapper);

            List<PreBidCostCalcDetailVO> detailList = projectVO.getPreBidCostCalcDetailList();
            Map<String, PreBidCostCalcDetailVO> detailMap = new HashMap<>();
            for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                detailMap.put(preBidCostCalcDetailVO.getCostCode(), preBidCostCalcDetailVO);
            }
            if (deList != null && deList.size()>0) {
                List<PreBidCostCalcDetailEntity> preBidCostCalcDetailList = new ArrayList<>();
                List<String> codeList = new ArrayList<>();
                for (PreBidCostCalcDetailEntity en : deList) {
                    if(detailMap.get(en.getCostCode())!=null){
                        PreBidCostCalcDetailVO d = detailMap.get(en.getCostCode());
                        en.setCostCode(d.getCostCode());
                        en.setMemo(d.getMemo());
                        en.setMny(d.getMny());
                        en.setCostStructure(d.getCostStructure());
                        en.setCostType(d.getCostType());
                        en.setRevenueShare(d.getRevenueShare());
                        en.setRowState("edit");
                        codeList.add(d.getCostCode());
                        preBidCostCalcDetailList.add(en);
                    }else{
                        en.setRowState("del");
                        preBidCostCalcDetailList.add(en);
                    }
                }
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    if(!codeList.contains(preBidCostCalcDetailVO.getCostCode())){
                        preBidCostCalcDetailVO.setRowState("add");
                        preBidCostCalcDetailList.add(BeanMapper.map(preBidCostCalcDetailVO, PreBidCostCalcDetailEntity.class));
                    }
                }
                preBidCostCalc.setPreBidCostCalcDetailList(preBidCostCalcDetailList);
            }else{
                for (PreBidCostCalcDetailVO preBidCostCalcDetailVO : detailList) {
                    preBidCostCalcDetailVO.setRowState("add");
                }
                preBidCostCalc.setPreBidCostCalcDetailList(BeanMapper.mapList(detailList, PreBidCostCalcDetailEntity.class));
            }
        }
        List<PreBidCostCalcDetailEntity> detailList = preBidCostCalc.getPreBidCostCalcDetailList();
        Map<String, BigDecimal> m = new HashMap<>();

        BigDecimal costNotaxTotal = new BigDecimal(0);
        BigDecimal costTaxTotal = new BigDecimal(0);
        BigDecimal dynamicCostTotal = new BigDecimal(0);
        BigDecimal projectProfitRate = new BigDecimal(0);
        for (PreBidCostCalcDetailEntity en : detailList) {
            if("del".equals(en.getRowState())){
                continue;
            }
            if("直接人工费".equals(en.getCostType())){
                preBidCostCalc.setLaborCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("直接材料费".equals(en.getCostType())){
                preBidCostCalc.setMaterialCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("机械使用费".equals(en.getCostType())){
                preBidCostCalc.setEquipmentCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("其他直接费".equals(en.getCostType())){
                preBidCostCalc.setDirectCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("外协成本".equals(en.getCostType())){
                preBidCostCalc.setCoalitionCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("其他费用支出".equals(en.getCostType())){
                preBidCostCalc.setOtherCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                    costNotaxTotal = costNotaxTotal.add(en.getMny());
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }else if("增值税及附加".equals(en.getCostType())){
                preBidCostCalc.setTaxCost(en.getMny());
                if(en.getMny()!=null){
                    costTaxTotal = costTaxTotal.add(en.getMny());
                }
            }else if("不含税收入".equals(en.getCostType())){
                preBidCostCalc.setIncomeNotax(en.getMny());
            }else if("capitalCost".equals(en.getCostType())){
                preBidCostCalc.setCapitalCost(en.getMny());
                if(en.getMny()!=null){
                    dynamicCostTotal = dynamicCostTotal.add(en.getMny());
                }
            }
        }
        if(preBidCostCalc.getIncomeNotax()==null){
            preBidCostCalc.setIncomeNotax(new BigDecimal(0));
            preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
        }else {
            if (preBidCostCalc.getIncomeNotax().compareTo(new BigDecimal(0)) != 0) {
                MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
                projectProfitRate = preBidCostCalc.getIncomeNotax().subtract(dynamicCostTotal).divide(preBidCostCalc.getIncomeNotax(), mc).multiply(new BigDecimal(100));
                preBidCostCalc.setProjectProfitRate(projectProfitRate);
            } else {
                preBidCostCalc.setProjectProfitRate(new BigDecimal(0));
            }
        }
        preBidCostCalc.setBillState(1);
        preBidCostCalcService.saveOrUpdate(preBidCostCalc);
    }
}
