/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AssetInEntity;
import com.ejianc.business.asset.bean.AssetOutDetailEntity;
import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.pub.ReceiveState;
import com.ejianc.business.asset.service.IAssetInService;
import com.ejianc.business.asset.service.IAssetOutService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetInVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetIn"})
public class AssetInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZY_ASSET_IN";
    @Autowired
    private IAssetInService service;
    @Autowired
    private IAssetOutService outService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetInVO> saveOrUpdate(@RequestBody AssetInVO saveOrUpdateVO) {
        AssetInEntity entity = (AssetInEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), AssetInEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        AssetInVO vo = (AssetInVO)((Object)BeanMapper.map((Object)((Object)entity), AssetInVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetInVO> queryDetail(Long id) {
        AssetInEntity entity = (AssetInEntity)((Object)this.service.selectById(id));
        AssetInVO vo = (AssetInVO)((Object)BeanMapper.map((Object)((Object)entity), AssetInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetInVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetInVO assetInVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetInVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("outOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("outOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, AssetInVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            if (null != e.getReceiveState()) {
                switch (e.getReceiveState()) {
                    case "1": {
                        e.setReceiveStateName(ReceiveState.TO_RECEIVING.getDescription());
                        break;
                    }
                    case "2": {
                        e.setReceiveStateName(ReceiveState.RECEIVED.getDescription());
                        break;
                    }
                    case "3": {
                        e.setReceiveStateName(ReceiveState.REJECT.getDescription());
                    }
                }
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("AssetIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAssetInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetInVO>> refAssetInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"sureToReceive"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReceive(@RequestBody AssetInVO vo) {
        AssetInEntity entity = (AssetInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setReceivePersonId(vo.getReceivePersonId());
        entity.setReceivePersonName(vo.getReceivePersonName());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setReceiveState(ReceiveState.RECEIVED.getCode());
        this.service.saveOrUpdate((Object)entity, false);
        AssetOutEntity outEntity = (AssetOutEntity)((Object)this.outService.selectById(entity.getOutId()));
        if (outEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u56fa\u5b9a\u8d44\u4ea7\u8c03\u51fa\u5355\uff0c\u786e\u8ba4\u6536\u6599\u5931\u8d25\uff01");
        }
        outEntity.setReceiveState(entity.getReceiveState());
        outEntity.setReceivePersonId(entity.getReceivePersonId());
        outEntity.setReceivePersonName(entity.getReceivePersonName());
        this.outService.saveOrUpdate((Object)outEntity, false);
        List<Long> assetIdList = outEntity.getDetailList().stream().map(AssetOutDetailEntity::getAssetId).collect(Collectors.toList());
        this.assetService.updateAssetRecord(assetIdList, outEntity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"sureToReturn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReturn(@RequestBody AssetInVO vo) {
        AssetInEntity entity = (AssetInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setPickReturnPerson(vo.getPickReturnPerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setReceiveState(ReceiveState.REJECT.getCode());
        entity.setPickReturnReason(vo.getPickReturnReason());
        this.service.saveOrUpdate((Object)entity, false);
        AssetOutEntity outEntity = (AssetOutEntity)((Object)this.outService.selectById(entity.getOutId()));
        if (outEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u56fa\u5b9a\u8d44\u4ea7\u8c03\u51fa\u5355\uff0c\u9000\u6599\u5931\u8d25\uff01");
        }
        outEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outEntity.setReceiveState(entity.getReceiveState());
        outEntity.setReceivePersonId(entity.getReceivePersonId());
        outEntity.setReceivePersonName(entity.getReceivePersonName());
        this.outService.saveOrUpdate((Object)outEntity, false);
        return CommonResponse.success((String)"\u9000\u6599\u6210\u529f\uff01");
    }
}

