package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.AssetInDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 固定资产调入
 * 
 * @author generator
 * 
 */
public class AssetInVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Long receivePersonId; // 收料人
    private String receivePersonName; // 收料人
    private String receiveState; // 收料状态 1-待收料 2-已收料 3-已退回
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate; // 调拨入库时候，记录收料日期
    private Long outId; // 调拨入库时候，记录调拨出库主表id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出日期
    private Long outOrgId; // 调拨入库时候，记录调拨出库主表调出组织id
    private String outOrgName; // 调拨入库时候，记录调拨出库主表调出组织
    private Long outProjectId; // 调拨入库时候，记录调拨出库主表调出项目id
    private String outProjectName; // 调拨入库时候，记录调拨出库主表调出项目名称
    private String outProjectCode; // 调拨入库时候，记录调拨出库主表调出项目编码
    private BigDecimal outMny; // 调出金额
    private String memo; // 备注
    private Integer outDependOnProject; // 是否属于项目: 默认为true
    private Integer dependOnProject; // 是否属于项目: 默认为true
    private String projectName; // 调入项目名称
    private String projectCode; // 调入项目编码
    private Long projectId; // 调入项目id
    private Long orgId; // 调入组织id
    private String orgName; // 调入组织名称
    private String note; // 备注
    private String pickReturnPerson; // 退料人
    private String pickReturnReason; // 退料原因

    private String receiveStateName; // 调入组织收料状态 1-待收料 2-已收料 3-已退回
    private String billStateName; //单据编码名称
    private List<AssetInDetailVO> detailList = new ArrayList<>(); // 固定资产调入-子实体

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getReceivePersonId() {
        return receivePersonId;
    }
    @ReferDeserialTransfer
    public void setReceivePersonId(Long receivePersonId) {
        this.receivePersonId = receivePersonId;
    }
    public String getReceivePersonName() {
        return receivePersonName;
    }

    public void setReceivePersonName(String receivePersonName) {
        this.receivePersonName = receivePersonName;
    }
    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Long getOutId() {
        return outId;
    }

    public void setOutId(Long outId) {
        this.outId = outId;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOutOrgId() {
        return outOrgId;
    }

    @ReferDeserialTransfer
    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getOutProjectId() {
        return outProjectId;
    }
    @ReferDeserialTransfer
    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public String getOutProjectCode() {
        return outProjectCode;
    }

    public void setOutProjectCode(String outProjectCode) {
        this.outProjectCode = outProjectCode;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getOutDependOnProject() {
        return outDependOnProject;
    }

    public void setOutDependOnProject(Integer outDependOnProject) {
        this.outDependOnProject = outDependOnProject;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }
    public String getPickReturnPerson() {
        return pickReturnPerson;
    }

    public void setPickReturnPerson(String pickReturnPerson) {
        this.pickReturnPerson = pickReturnPerson;
    }
    public String getPickReturnReason() {
        return pickReturnReason;
    }

    public void setPickReturnReason(String pickReturnReason) {
        this.pickReturnReason = pickReturnReason;
    }

    public List<AssetInDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetInDetailVO> detailList) {
        this.detailList = detailList;
    }
}
