package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.mapper.InstoreBillMapper;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreBillService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.InstoreBillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Service
public class InstoreBillService extends BaseServiceImpl<InstoreBillMapper, InstoreBillEntity> implements IInstoreBillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;

    @Autowired
    private IInstoreService instoreService;
    @Autowired
    private IAttachmentApi attachmentApi;


    @Override
    public IPage<InstoreBillVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<InstoreBillVO> voPage = null;
        IPage<InstoreBillEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),InstoreBillVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReceive(InstoreBillEntity entity) {
        entity.getInstoreMaterialList().forEach(e->{
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.USED.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReturn(InstoreBillEntity entity) {
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    public void processCost(InstoreBillEntity entity) {
        String factor = "1";
        if(MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())){
            factor = "-1";
        }
    }

    @Override
    public List<InstoreBillMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return instoreBillMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreBillVO> amountSum(List<Long> projectIds) {
        return instoreBillMaterialMapper.amountSum(projectIds);
    }

    /**
     * 向直入直出管理中推送数据
     * @param billId
     */
    @Override
    public void pushInstoreManage(Long billId) {
        if(billId != null){
            InstoreBillEntity instoreBillEntity = this.selectById(billId);
            if(instoreBillEntity != null){
                InstoreEntity instoreEntity = BeanMapper.map(instoreBillEntity, InstoreEntity.class);
                instoreEntity.setId(null);
                instoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                instoreEntity.getInstoreMaterialList().forEach((item)->{
                    item.setId(null);
                });
                //复制直入直出单到直入直出管理
                instoreService.saveOrUpdate(instoreEntity,false);
                //复制附件  从直入直出单复制到直入直出管理
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(instoreBillEntity.getId()), "BT211105000000001", "straightInoutBill", String.valueOf(instoreEntity.getId()), "BT200616000000005", "straightInout");

                //直入直出单保存直入直出管理的id
                LambdaUpdateWrapper<InstoreBillEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(InstoreBillEntity::getId,instoreBillEntity.getId());
                wrapper.set(InstoreBillEntity::getInstoreBillId,instoreEntity.getId());
                this.update(wrapper);

            }
        }

    }

    /**
     * 判断直入直出单是否能弃审
     * @param billId
     * @return
     */
    @Override
    public boolean instoreIsRevoke(Long billId) {
        boolean flag = false;
        if(billId != null){
            //根据单据id 查询直入直出单
            InstoreBillEntity instoreBillEntity = this.selectById(billId);
            //直入直出单不为空，查询直入直出管理
            if(instoreBillEntity != null){
                InstoreEntity instoreEntity = instoreService.selectById(instoreBillEntity.getInstoreBillId());
                //如果直入直出管理 单据为自由态，返回true 可删除
                if(instoreEntity == null || (instoreEntity.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode())){
                    flag = true;
                }
            }
        }
        return flag;
    }

    /**
     * 删除直入直出管理 单据
     * @param billId
     */
    @Override
    public void deleteInstoreBill(Long billId) {
        if(billId != null){
            //根据单据id 查询直入直出单
            InstoreBillEntity instoreBillEntity = this.selectById(billId);
            //直入直出单不为空，查询直入直出管理
            if(instoreBillEntity != null && instoreBillEntity.getInstoreBillId()!= null){
                instoreService.removeById(instoreBillEntity.getInstoreBillId(),false);
            }
        }
    }
}
