package com.ejianc.business.sync.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.business.market.bean.SpacePermitEntity;
import com.ejianc.business.market.service.ISpacePermitService;
import com.ejianc.business.market.vo.SpacePermitVO;
import com.ejianc.business.sync.service.ISyncService;
import com.ejianc.business.sync.vo.SyncProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 同步数据
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sync")
public class SyncController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISyncService syncService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/syncProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncProject(@RequestBody SyncProjectVO projectVO) {
        syncService.syncProject(projectVO);
    	return CommonResponse.success("数据同步成功！");
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/testSyncProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> testSyncProject(@RequestParam(required = false) Integer type,
            @RequestParam(required = false) Integer state) {
        SyncProjectVO vo = new SyncProjectVO();
        vo.setProjectId("111111111");
        vo.setProjectCode("测试同步项目");
        vo.setProjectOrgId("77625");
        vo.setProjectOrgName("测试分部");
        vo.setProjectType("询比价");
        vo.setProjectSource("搜索引擎推广");
        vo.setInternalCooperationProject("是");
        vo.setFirstBusiness("一级业务");
        vo.setSecondBusiness("二级业务");
        vo.setProjectOverview("项目简介");
        vo.setProjectAddress("项目所在地");
        vo.setProjectContractCode("3245546343");
        vo.setProjectContractName("测试同步合同");
        vo.setSignDate(new Date());
        vo.setContractMny(new BigDecimal(122));
        vo.setCustomerId("3453546534342");
        vo.setCustomerCode("客户编码");
        vo.setCustomerName("测试同步客户");
        vo.setSocialCreditCode("ewe4354rer34");
        vo.setTaxType("一般纳税人");
        vo.setCustomerType("党政机关");
        vo.setCustomerAddress("客户地址");
        vo.setBankAccount("账户名");
        vo.setBankCode("银行账号");
        vo.setBankName("开户行名称");
        vo.setLinker("联系人姓名");
        vo.setCellphone("12322");
        vo.setState(state!=null?state:1);
        List<PreBidCostCalcDetailVO> list = new ArrayList<>();
        PreBidCostCalcDetailVO dvo = new PreBidCostCalcDetailVO();
        dvo.setCostCode("01");
        dvo.setCostType("直接人工费");
        dvo.setMny(new BigDecimal(10));
        dvo.setRevenueShare(new BigDecimal(20));
        dvo.setMemo("直接人工费-备注");
        list.add(dvo);
        PreBidCostCalcDetailVO dvo2 = new PreBidCostCalcDetailVO();
        dvo2.setCostCode("02");
        dvo2.setCostType("直接材料费");
        dvo2.setMny(new BigDecimal(10));
        dvo2.setRevenueShare(new BigDecimal(30));
        dvo2.setMemo("直接材料费-备注");
        list.add(dvo2);
        PreBidCostCalcDetailVO dvo3 = new PreBidCostCalcDetailVO();
        dvo3.setCostCode("02");
        dvo3.setCostType("机械使用费");
        dvo3.setMny(new BigDecimal(10));
        dvo3.setRevenueShare(new BigDecimal(40));
        dvo3.setMemo("机械使用费-备注");
        list.add(dvo3);

        vo.setPreBidCostCalcDetailList(list);
        syncService.syncProject(vo);
    	return CommonResponse.success("数据同步成功！");
    }

}
