package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.mapper.ContractDetailMapper;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@Service("ContractDetailService")
public class ContractDetailServiceImpl extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity> implements IContractDetailService {

    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<ContractDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ContractDetailVo> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ContractDetailVo vo = new ContractDetailVo();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"清单编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setUnit(datas.get(3));//计量单位

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setNum(null);
                        warnType = warnType+"工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

                    // 修改由合价计算综合单价
//                    if (StringUtils.isEmpty(datas.get(5))) {
//                        vo.setPrice(null);
//                        warnType = warnType+"综合单价为空,";
//                        flag = true;
//                    } else {
//                        try {
//                            vo.setPrice(new BigDecimal(datas.get(5)));
//                        } catch (Exception e) {
//                            vo.setPrice(null);
//                            warnType = warnType+"综合单价只能为数字或小数,";
//                            flag = true;
//                        }
//                    }

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setMny(null);
                        warnType = warnType+"合价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setMny(ComputeUtil.scaleTwo(new BigDecimal(datas.get(6))));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType+"合价只能为数字或小数,";
                            flag = true;
                        }
                    }

                    if (null == vo.getNum() || null == vo.getMny()) {
                        vo.setPrice(null);
                    } else {
                        vo.setPrice(ComputeUtil.safeDiv(vo.getMny(), vo.getNum()));
                    }
                    // end

                    vo.setMemo(datas.get(7));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for(ContractDetailVo tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList",allList.get(0));
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }
    //清单参照
    @Override
    public List<ContractDetailVo> detailRef(Long contractId) {
        QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.ne("change_type",5);//中止不显示
        wrapper.orderBy(true,true,"detail_index");
        List<ContractDetailEntity> entities = baseMapper.selectList(wrapper);
        if(entities != null && entities.size() > 0) {
            for(ContractDetailEntity cdEntity:entities){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
        }
        List<ContractDetailVo> detailVos = BeanMapper.mapList(entities, ContractDetailVo.class);
        //实现排序
        Collections.sort(detailVos,new ContractDetailComparatorVo());
        return TreeNodeBUtil.buildTree(detailVos);
    }


}
