package com.ejianc.business.income.utils;

import com.ejianc.business.income.vo.SqlParam;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: list分隔工具
 * @author songlx
 * @date 2023/5/30
 * @version 1.0
 */
public class ListSplitUtil {


    public static int DEFAULT_SIZE = 200;

    public static List<List<SqlParam>> splitList(List<SqlParam> list) {
        return splitList(list, DEFAULT_SIZE);
    }

    /**
     * 将集合按len数量分成若干个list
     * @param list
     * @param len 每个集合的数量
     * @return
     */
    public static List<List<SqlParam>> splitList(List<SqlParam> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        List<List<SqlParam>> result = new ArrayList<>();

        int size = list.size();
        int count = (size + len - 1) / len;

        for (int i = 0; i < count; i++) {
            List<SqlParam> subList = list.subList(i * len, ((i + 1) * len > size ? size : len * (i + 1)));
            result.add(subList);
        }
        return result;
    }

}
