package com.ejianc.business.material.pub;
/**
 * @Author mrsir_wxp
 * @Date 2020/6/12  出库物资占用库存状态枚举
 * @Description MaterialStoreType
 */

public enum MaterialStoreState {

    /** 占用态 ，此状态用于计算【可用库存】，表示出库单已提交和已通过的物资*/
    OCCUPY(0,"占用态"),
    /** 扣减库存态，此状态用于计算【实际库存】,表示出库单新增和审批中的物资*/
    USED(1,"已领用"),
    /** 入库物资正在入库态，此状态不参与任何计算*/
    STORING(2,"入库中"),
    /** 入库物资已存储态，此状态用于计算【实际库存】,表示入库单入库已提交和已通过的物资*/
    STORED(3,"已入库");

    private Integer code;

    private String description;

    //构造方法
    private MaterialStoreState(Integer code, String description ){
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
