/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.EngdepartRespcostDetailEntity;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.service.IProjectTargetcostRecordService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.ProjectTargetcostDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostRecordVO;
import com.ejianc.business.cost.vo.ProjectTargetcostVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectTargetcost"})
public class ProjectTargetcostController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxProjectTargetcost";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IProjectTargetcostService service;
    @Autowired
    private IProjectTargetcostRecordService recordService;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;
    @Autowired
    private ProjectUtils projectUtils;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> saveOrUpdate(@RequestBody ProjectTargetcostVO saveOrUpdateVO) {
        BigDecimal contractMny;
        ProjectTargetcostEntity entity = (ProjectTargetcostEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectTargetcostEntity.class));
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeState("1");
        } else {
            checkWrapper.ne((Object)"id", (Object)entity.getId());
        }
        List check = this.service.list((Wrapper)checkWrapper);
        if (check.size() > 0) {
            throw new BusinessException("\u9879\u76ee\u3010" + entity.getProjectName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u9879\u76ee\u76ee\u6807\u6210\u672c");
        }
        BigDecimal bigDecimal = contractMny = saveOrUpdateVO.getContractTaxMny() != null ? saveOrUpdateVO.getContractTaxMny() : new BigDecimal(0);
        if ("\u5b50\u9879\u76ee".equals(saveOrUpdateVO.getProjectProperty())) {
            List<Long> projectIds = this.projectUtils.getProjectList(saveOrUpdateVO.getProjectId());
            if (projectIds != null && projectIds.size() > 0) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.in((Object)"project_id", projectIds);
                List lsit = this.service.list((Wrapper)wrapper);
                if (lsit != null && lsit.size() > 0) {
                    BigDecimal amont = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                    for (ProjectTargetcostEntity vo : lsit) {
                        BigDecimal allocateContractMny = vo.getAllocateContractMny() != null ? vo.getAllocateContractMny() : new BigDecimal(0);
                        amont = amont.add(allocateContractMny);
                    }
                    if (amont.compareTo(contractMny) > 0) {
                        throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + amont.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
                    }
                }
            } else {
                BigDecimal allocateContractMny;
                BigDecimal bigDecimal2 = allocateContractMny = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                if (allocateContractMny.compareTo(contractMny) > 0) {
                    throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + allocateContractMny.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
                }
            }
        } else {
            BigDecimal allocateContractMny;
            BigDecimal bigDecimal3 = allocateContractMny = saveOrUpdateVO.getAllocateContractMny() != null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
            if (allocateContractMny.compareTo(contractMny) > 0) {
                throw new BusinessException("\u5b50\u9879\u76ee\u7d2f\u8ba1\u5206\u914d\u989d\u3010" + allocateContractMny.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u5408\u540c\u989d\u3010" + contractMny.setScale(2, 4) + "\u3011");
            }
        }
        this.engdepartRespcostService.checkAmount(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getProjectProperty(), saveOrUpdateVO.getTargetcostTotal());
        if (entity.getProjectTargetcostDetailList() != null && entity.getProjectTargetcostDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getProjectTargetcostDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setTargetcostId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTargetcostDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectTargetcostVO vo = (ProjectTargetcostVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTargetcostVO.class));
        if (CollectionUtils.isNotEmpty(vo.getProjectTargetcostDetailList())) {
            ProjectTargetcostController.sortIntMethod(vo.getProjectTargetcostDetailList());
            List<ProjectTargetcostDetailVO> detailVOS = ProjectTargetcostController.createTreeData(vo.getProjectTargetcostDetailList());
            vo.setProjectTargetcostDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> queryDetail(Long id) {
        ProjectTargetcostEntity entity = (ProjectTargetcostEntity)((Object)this.service.selectById(id));
        ProjectTargetcostVO vo = (ProjectTargetcostVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTargetcostVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"taskcost_id", (Object)vo.getId());
        List records = this.recordService.list((Wrapper)queryWrapper);
        if (records != null && records.size() > 0) {
            vo.setRecordList(BeanMapper.mapList((Iterable)records, ProjectTargetcostRecordVO.class));
        }
        if (CollectionUtils.isNotEmpty(vo.getProjectTargetcostDetailList())) {
            ProjectTargetcostController.sortIntMethod(vo.getProjectTargetcostDetailList());
            List<ProjectTargetcostDetailVO> detailVOS = ProjectTargetcostController.createTreeData(vo.getProjectTargetcostDetailList());
            vo.setProjectTargetcostDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private static void sortIntMethod(List<ProjectTargetcostDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTargetcostDetailVO o1Detail = (ProjectTargetcostDetailVO)((Object)objectMapper.convertValue(o1, ProjectTargetcostDetailVO.class));
                ProjectTargetcostDetailVO o2Detail = (ProjectTargetcostDetailVO)((Object)objectMapper.convertValue(o2, ProjectTargetcostDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTargetcostDetailVO> createTreeData(List<ProjectTargetcostDetailVO> list) {
        ArrayList<ProjectTargetcostDetailVO> resp = new ArrayList<ProjectTargetcostDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProjectTargetcostDetailVO> listMap = new HashMap<String, ProjectTargetcostDetailVO>();
        for (ProjectTargetcostDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProjectTargetcostDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ProjectTargetcostDetailVO parent = (ProjectTargetcostDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProjectTargetcostDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ProjectTargetcostDetailVO> children = new ArrayList<ProjectTargetcostDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProjectTargetcostDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTargetcostVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> departmentIds.add(org.getId()));
        param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTargetcostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> departmentIds.add(org.getId()));
        param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectTargetcost-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectTargetcostData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostVO>> refProjectTargetcostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTargetcostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryEngdepartRespCostById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTargetcostVO> queryEngdepartRespCostById(Long id) {
        EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)this.engdepartRespcostService.selectById(id));
        ProjectTargetcostVO vo = new ProjectTargetcostVO();
        vo.setRespcostId(id);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectDepartmentId(entity.getProjectDepartmentId());
        vo.setProjectName(entity.getProjectName());
        vo.setOrgId(entity.getOrgId());
        vo.setPubUnitName(entity.getPubUnitName());
        vo.setContractUnitName(entity.getContractUnitName());
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setFinishDate(entity.getFinishDate());
        if (CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList())) {
            ArrayList<ProjectTargetcostDetailVO> projectTargetcostDetailList = new ArrayList<ProjectTargetcostDetailVO>();
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (EngdepartRespcostDetailEntity detail : entity.getEngdepartRespcostDetailList()) {
                ProjectTargetcostDetailVO d = new ProjectTargetcostDetailVO();
                d.setCode(detail.getCode());
                d.setAddState(false);
                d.setCostAmount(detail.getAmount());
                d.setFeeType(detail.getFeeType());
                d.setRespcostDetailId(detail.getId());
                d.setSubjectCode(detail.getSubjectCode());
                d.setSubjectId(detail.getSubjectId());
                d.setSubjectName(detail.getSubjectName());
                d.setRowState("add");
                d.setId(IdWorker.getId());
                map.put(detail.getCode(), d.getId());
                projectTargetcostDetailList.add(d);
            }
            projectTargetcostDetailList.forEach(item -> {
                if (item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
            ProjectTargetcostController.sortIntMethod(projectTargetcostDetailList);
            List<ProjectTargetcostDetailVO> detailVOS = ProjectTargetcostController.createTreeData(projectTargetcostDetailList);
            vo.setProjectTargetcostDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/checkBillParam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectTargetcostVO vo) {
        JSONArray list = new JSONArray();
        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
        PreBidCostCalcEntity preBidCostCalcEntity = this.preBidCostCalcService.queryDataByProjectId(vo.getProjectId());
        if (preBidCostCalcEntity == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8be5\u9879\u76ee\u6807\u524d\u6d4b\u7b97\u6570\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6807\u524d\u6d4b\u7b97");
        }
        BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal() != null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);
        CommonResponse dataResponse = this.paramConfigApi.getBillParamByCode("P-m69ri60308");
        if (dataResponse.isSuccess()) {
            BigDecimal roleValue = ((BillParamVO)dataResponse.getData()).getRoleValue();
            if ("\u5b50\u9879\u76ee".equals(vo.getProjectProperty())) {
                List<Long> projectIds = this.projectUtils.getProjectList(vo.getProjectId());
                if (projectIds != null && projectIds.size() > 0) {
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.in((Object)"project_id", projectIds);
                    List lsit = this.service.list((Wrapper)wrapper);
                    if (lsit != null && lsit.size() > 0) {
                        BigDecimal amont = vo.getTargetcostTotal() != null ? vo.getTargetcostTotal() : new BigDecimal(0);
                        for (ProjectTargetcostEntity pr : lsit) {
                            BigDecimal targetcostTotal = pr.getTargetcostTotal() != null ? pr.getTargetcostTotal() : new BigDecimal(0);
                            amont = amont.add(targetcostTotal);
                        }
                        BigDecimal absoluteValue = amont.subtract(costTaxTotal);
                        BigDecimal da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                        if (da.compareTo(roleValue) > 0) {
                            JSONObject item = new JSONObject();
                            item.put("type", (Object)"1");
                            item.put("warnItem", (Object)"1");
                            item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                            item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + amont.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                            list.add((Object)item);
                        }
                    }
                } else {
                    BigDecimal targetcostTotal = vo.getTargetcostTotal() != null ? vo.getTargetcostTotal() : new BigDecimal(0);
                    BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                    BigDecimal da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                    if (da.compareTo(roleValue) > 0) {
                        JSONObject item = new JSONObject();
                        item.put("type", (Object)"1");
                        item.put("warnItem", (Object)"1");
                        item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                        item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + targetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                        list.add((Object)item);
                    }
                }
            } else {
                BigDecimal targetcostTotal = vo.getTargetcostTotal() != null ? vo.getTargetcostTotal() : new BigDecimal(0);
                BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                BigDecimal da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                if (da.compareTo(roleValue) > 0) {
                    JSONObject item = new JSONObject();
                    item.put("type", (Object)"1");
                    item.put("warnItem", (Object)"1");
                    item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                    item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + targetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                    list.add((Object)item);
                }
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        return CommonResponse.success((Object)list);
    }

    @RequestMapping(value={"/queryDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDataByProjectId(Long projectId) {
        JSONObject data = this.service.queryDataByProjectId(projectId);
        return CommonResponse.success((Object)data);
    }
}

