package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ProjectTaskBookDetailEntity;
import com.ejianc.business.cost.service.IProjectTaskBookDetailService;
import com.ejianc.business.cost.vo.ProjectTaskBookDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ProjectTaskBookEntity;
import com.ejianc.business.cost.service.IProjectTaskBookService;
import com.ejianc.business.cost.vo.ProjectTaskBookVO;

/**
 * 项目任务书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTaskBook")
public class ProjectTaskBookController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxProjectTaskBook";//此处需要根据实际修改

    @Autowired
    private IProjectTaskBookService service;
    @Autowired
    private IProjectTaskBookDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> saveOrUpdate(@RequestBody ProjectTaskBookVO saveOrUpdateVO) {
    	ProjectTaskBookEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTaskBookEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getProjectTaskBookDetailList()!=null && entity.getProjectTaskBookDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getProjectTaskBookDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setTaskbookId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTaskBookDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
    	service.saveOrUpdate(entity, false);
    	ProjectTaskBookVO vo = BeanMapper.map(entity, ProjectTaskBookVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTaskBookDetailList())) {
            sortIntMethod(vo.getProjectTaskBookDetailList());
            List<ProjectTaskBookDetailVO> detailVOS = createTreeData(vo.getProjectTaskBookDetailList());
            vo.setProjectTaskBookDetailList(detailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> queryDetail(Long id) {
    	ProjectTaskBookEntity entity = service.selectById(id);
    	ProjectTaskBookVO vo = BeanMapper.map(entity, ProjectTaskBookVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTaskBookDetailList())) {
            sortIntMethod(vo.getProjectTaskBookDetailList());
            List<ProjectTaskBookDetailVO> detailVOS = createTreeData(vo.getProjectTaskBookDetailList());
            vo.setProjectTaskBookDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @RequestMapping(value = "/queryDetail4ProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> queryDetail4ProjectId(Long projectId) {
        ProjectTaskBookVO vo = new ProjectTaskBookVO();
        LambdaQueryWrapper<ProjectTaskBookEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ProjectTaskBookEntity::getProjectId,projectId)
                .eq(ProjectTaskBookEntity::getDr,0)
                .orderByDesc(ProjectTaskBookEntity::getCreateTime)
                .in(ProjectTaskBookEntity::getBillState,Arrays.asList(1,3));
        List<ProjectTaskBookEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
             vo = BeanMapper.map(list.get(0), ProjectTaskBookVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTaskBookVO> vos) {
        service.removeByIds(vos.stream().map(ProjectTaskBookVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectTaskBookEntity> page = service.queryPage(param,false);
        IPage<ProjectTaskBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTaskBookVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectTaskBookEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectTaskBook-export.xlsx", beans, response);
    }

    private static void sortIntMethod(List<ProjectTaskBookDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTaskBookDetailVO o1Detail = objectMapper.convertValue(o1, ProjectTaskBookDetailVO.class);
                ProjectTaskBookDetailVO o2Detail = objectMapper.convertValue(o2, ProjectTaskBookDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTaskBookDetailVO> createTreeData(List<ProjectTaskBookDetailVO> list) {
        List<ProjectTaskBookDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectTaskBookDetailVO> listMap = new HashMap<>();
        for(ProjectTaskBookDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectTaskBookDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectTaskBookDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectTaskBookDetailVO> child = (List<ProjectTaskBookDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectTaskBookDetailVO> children = new ArrayList<ProjectTaskBookDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectTaskBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookVO>> refProjectTaskBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectTaskBookEntity> page = service.queryPage(param,false);
        IPage<ProjectTaskBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTaskBookVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/refProjectTaskBookDataTree", method = RequestMethod.GET)
    @ResponseBody
    public List<ProjectTaskBookVO> refProjectTaskBookDataTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Boolean productionFlag=false;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }else{
//                return CommonResponse.error("缺少项目参数",new ArrayList<>());
            }
            if(_con.get("productionFlag")!=null){
                productionFlag=true;
            }
        }
        List<ProjectTaskBookEntity> page = service.queryList(param,false);
        List<ProjectTaskBookVO> list = new ArrayList<>();
        List<Long> haveSurNumIds = new ArrayList<>();
        if (productionFlag) {

            if (CollectionUtils.isNotEmpty(page)) {
                QueryParam queryApplySubParam = new QueryParam();
                queryApplySubParam.getParams().put("taskbookId", new Parameter(QueryParam.IN, page.stream().map(ProjectTaskBookEntity::getId).collect(Collectors.toList())));
                queryApplySubParam.getParams().put("sql", new Parameter(QueryParam.SQL, " id not in (" +
                        "SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
                List<ProjectTaskBookDetailVO> detailList =service.queryApplySubCount(queryApplySubParam);
                haveSurNumIds = detailList.stream().map(ProjectTaskBookDetailVO::getTaskbookId).collect(Collectors.toList());
            }
        }
        if(page!=null && page.size()>0){
            for(ProjectTaskBookEntity entity : page){
                if (productionFlag&&!haveSurNumIds.contains(entity.getId())){
                    continue;
                }
                ProjectTaskBookVO vo = BeanMapper.map(entity, ProjectTaskBookVO.class);
                vo.setProduceContent(null);
                vo.setQualityContent(null);
                vo.setSafeContent(null);
                vo.setCostConent(null);
                vo.setOtherContent(null);
                vo.setRemark(null);
                list.add(vo);
            }
        }
        return list;
     }

    @RequestMapping(value = "/refProjectTaskBookDataDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookDetailVO>> refProjectTaskBookDataDetail(
            @RequestParam(defaultValue = "1") int pageNumber,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required=false) String relyCondition,
            @RequestParam(required=false) String relyNode,
            @RequestParam(required=false) String searchText,
            @RequestParam(required=false) String condition,
            @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> haveSurNumIds = new ArrayList<>();
        Boolean productionFlag=false;
        if(StringUtils.isNotBlank(relyCondition)){
            Long projectTaskBookId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("taskbookId", new Parameter(QueryParam.EQ, projectTaskBookId));
            if(StringUtils.isNotEmpty(condition)){
                /** 处理condition */
                JSONObject _con = JSONObject.parseObject(condition);
                if(_con.get("productionFlag")!=null){
                    productionFlag=true;
                }
            }
            if (productionFlag) {
                QueryParam queryApplySubParam = new QueryParam();
                queryApplySubParam.getParams().put("taskbookId", new Parameter(QueryParam.EQ, projectTaskBookId));

                queryApplySubParam.getParams().put("detailsql", new Parameter(QueryParam.SQL, " id not in (" +
                        "SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
                List<ProjectTaskBookDetailVO> detailList = service.queryApplySubCount(queryApplySubParam);
                haveSurNumIds = detailList.stream().map(ProjectTaskBookDetailVO::getId).collect(Collectors.toList());
            }
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        param.getParams().put("sql", new Parameter(QueryParam.SQL, " id not in (" +
                "SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
        if (productionFlag){
            param.getParams().put("id", new Parameter(QueryParam.IN,haveSurNumIds ));
        }
        IPage<ProjectTaskBookDetailEntity> page = detailService.queryPage(param,false);
        List<ProjectTaskBookDetailVO> detailVOS = new ArrayList<>();

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(page.getRecords())) {
            detailVOS = BeanMapper.mapList(page.getRecords(), ProjectTaskBookDetailVO.class);
            for(ProjectTaskBookDetailVO vo : detailVOS){
                vo.setChildren(null);
            }
        }
//        IPage<ProjectTaskBookDetailVO> pageData = new Page<>(pageNumber, pageSize, detailVOS.size());
//        Integer start = (pageNumber - 1) * pageSize;
//        Integer end = ((start+pageSize)>detailVOS.size())?detailVOS.size():(start+pageSize);
        IPage<ProjectTaskBookDetailVO> pageData = new Page<>(pageNumber, pageSize, page.getTotal());
        pageData.setRecords(detailVOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


}
