package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.QuoteDetailEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 甲方报量 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/quote")
public class QuoteController {
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 新增或编辑
     * @param
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuoteVo> saveOrUpdate(@RequestBody QuoteVo vo) {
        CommonResponse<QuoteVo> response = quoteService.saveOrUpdate(vo);
        return response;
    }
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVo>  queryDetail(@RequestParam Long id) {
        QuoteVo vo= quoteService.queryDetail(id);
        return CommonResponse.success(vo);
    }
    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuoteEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人、描述
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime","desc");
        return CommonResponse.success("查询列表数据成功！",quoteService.queryPage(param,false));
    }
    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVo> vos) {
        quoteService.deleteQuote(vos);
        return CommonResponse.success("删除成功");
    }
    /**
     * 历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryQuoteHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteHistoryVo> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVo vo = quoteService.queryQuoteHistory(id);
        return CommonResponse.success(vo);
    }
    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<QuoteEntity> pageData = quoteService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<QuoteVo> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), QuoteVo.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    /**
     * 甲方报量子表物资导出
     *
     * @param
     * @param response
     */
    @PostMapping("excelExportCheckList")
    public void excelExportCheckList(@RequestBody QuoteVo quoteVo, HttpServletResponse response) {
        QuoteEntity entity = quoteService.selectById(quoteVo.getId());
        Map<String, Object> beans = new HashMap();
        List<QuoteDetailEntity> data = entity.getCheckList();
        beans.put("records", data);
        ExcelExport.getInstance().export("quote-detail-export .xlsx", beans, response);
    }

    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计工程量
     * @param
     * @param
     * @return
     */
    @RequestMapping(value = "/queryQuoteDetailHistory" , method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryQuoteDetailHistory (@RequestBody QuoteDetailVo quoteDetailVo){
        JSONObject page = quoteService.queryQuoteDetailHistory(quoteDetailVo);
        return CommonResponse.success("查询成功",page);
    }

    /**
     * 查询合同内的历史数据集合，修改含本期累计报量和不含本期累计报量
     * @return
     */
    @RequestMapping(value = "updateQuoteDetailHistory" ,method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateQuoteDetailHistory(){
        quoteService.updateQuoteDetailHistory();
        return CommonResponse.success("保存或修改单据成功！");
    }
    /**
     * 甲方报量参照
     * @return
     */
    @RequestMapping(value = "/refQuoteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuoteVo>> refDeductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStatus.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(org.apache.commons.lang3.StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")){
                String contractId = (String)_con.get("contractId");
                if (StringUtils.isNotEmpty(contractId)){
                    param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
                }
            }
            if (_con.containsKey("projectId")){
                String projectId = (String) _con.get("projectId");
                if (StringUtils.isNotEmpty(projectId)){
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                }
            }
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        List<QuoteEntity> quoteEntities = quoteService.queryList(param, false);

        IPage<QuoteEntity> page = quoteService.queryPage(param,false);
        IPage<QuoteVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuoteVo.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quote-detail-import .xlsx", "甲方报量导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return quoteService.excelImport(request,response);
    }

}
