package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.OutProductionEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.vo.OutProductionDetailVo;
import com.ejianc.business.income.vo.OutProductionVo;
import com.ejianc.business.income.vo.report.ProductionReportVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 产值进度 服务类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public interface IOutProductionService extends IBaseService<OutProductionEntity> {

    CommonResponse<OutProductionVo> saveOrUpdate(OutProductionVo productionVo);

    OutProductionVo queryDetail(Long id);

    void deleteProduction(List<OutProductionVo> vos);

    ProductionHistoryVo queryProductionHistory(Long id);

    List<OutProductionDetailVo> detailRef(Long id);
    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计完成量，完成产值
     * @param
     * @param
     * @return
     */
    Map<Long, OutProductionDetailVo> queryProductionDetailHistory(OutProductionDetailVo productionDetailVo);

    OutProductionVo queryInfoProjectId(Long projectId);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    List<ProjectRegisterVO> queryNoProductionProject(List<Long> tenantIds);

    JSONObject queryProductionReport(QueryParam param,Boolean excelBoolean);

    List<ProductionReportVO> excelExportProductionReport(QueryParam queryParam);
}
