package com.ejianc.business.other.controller;

import java.io.Serializable;

import com.ejianc.foundation.support.api.IBillCodeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;

import com.ejianc.business.other.service.IOtherContractHistoryService;
import com.ejianc.business.other.vo.OtherContractHistoryVO;

/**
 * 其他支出合同记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherContractHistory")
public class OtherContractHistoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOtherContractHistoryService service;

    @RequestMapping(value = "/queryDetailByChangeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractHistoryVO> queryDetailByChangeId(@RequestParam Long id) {
        OtherContractHistoryVO historyVo = service.queryDetailByChangeId(id);
        return CommonResponse.success(historyVo);
    }
}
