package com.ejianc.business.sub.vo;

import com.ejianc.business.sub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 过程结算明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SubSettleReportDetailVO extends BaseVO implements ITreeNodeB {

    private static final long serialVersionUID = 1L;

    /**
     * 结算ID
     */
    private Long settleId;


    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同明细ID
     */
    private Long contractDetailId;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 清单编码
     */
    private String code;

    /**
     * 清单名称
     */
    private String name;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 工程量
     */
    private BigDecimal num;

    /**
     * 合同单价
     */
    private BigDecimal price;

    /**
     * 本期结算工程量
     */
    private BigDecimal settleNum;

    /**
     * 本期结算金额
     */
    private BigDecimal settleMny;

    /**
     * 结算单价
     */
    private BigDecimal settlePrice;

    /**
     * 累计结算工程量(含本期)
     */
    private BigDecimal sumSettleNum;

    /**
     * 累计结算金额(含本期)
     */
    private BigDecimal sumSettleMny;

    /**
     * 来源类型(1:合同内，2:合同外)
     */
    private Integer sourceType;

    /**
     * 来源类型(1:合同内，2:合同外)
     */
    private String sourceTypeName;

    /**
     * 备注
     */
    private String memo;

    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    private List<ITreeNodeB> children;

    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;


    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSettlePrice() {
        return settlePrice;
    }

    public void setSettlePrice(BigDecimal settlePrice) {
        this.settlePrice = settlePrice;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public BigDecimal getSumSettleNum() {
        return sumSettleNum;
    }

    public void setSumSettleNum(BigDecimal sumSettleNum) {
        this.sumSettleNum = sumSettleNum;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
