/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="claim")
public class ClaimBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.claimService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(claimEntity.getContractId()));
        BigDecimal replyMny = claimEntity.getReplyMny() == null ? BigDecimal.ZERO : claimEntity.getReplyMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        contractEntity.setSumClaimMny(sumClaimMny.add(replyMny));
        this.contractService.updateById((Object)contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

