/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labprice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.labprice.bean.LaborInquiryEntity;
import com.ejianc.business.labprice.mapper.LaborInquiryMapper;
import com.ejianc.business.labprice.service.ILaborInquiryService;
import com.ejianc.business.labprice.vo.LaborInquiryVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service(value="laborInquiryService")
public class LaborInquiryServiceImpl
extends BaseServiceImpl<LaborInquiryMapper, LaborInquiryEntity>
implements ILaborInquiryService {
    @Override
    public LaborInquiryVO updateInquiry(LaborInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        LaborInquiryEntity entity = (LaborInquiryEntity)((Object)super.selectById((Serializable)id));
        if (entity != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(LaborInquiryEntity::getQuoteEndDate, (Object)quoteEndDate);
            if (quoteEndFlag.booleanValue()) {
                updateWrapper.set(LaborInquiryEntity::getInquiryState, (Object)InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            if (InquiryStateEnum.EXPIRATION_STATE.getCode().equals(entity.getInquiryState()) && quoteEndDate.compareTo(new Date()) > 0) {
                updateWrapper.set(LaborInquiryEntity::getInquiryState, (Object)InquiryStateEnum.QUOTATION_STATE.getCode());
            }
            super.update((Wrapper)updateWrapper);
        }
        return updateVo;
    }

    @Override
    public void updateInquiry(Long inquiryId, Integer inquiryState) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)inquiryId);
        updateWrapper.set(LaborInquiryEntity::getInquiryState, (Object)inquiryState);
        super.update((Wrapper)updateWrapper);
    }
}

