package com.ejianc.business.labprice.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.labprice.vo.LaborInquiryVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labprice.mapper.LaborInquiryMapper;
import com.ejianc.business.labprice.bean.LaborInquiryEntity;
import com.ejianc.business.labprice.service.ILaborInquiryService;

import java.util.Date;

/**
 * 劳务询价
 * 
 * @author generator
 * 
 */
@Service("laborInquiryService")
public class LaborInquiryServiceImpl extends BaseServiceImpl<LaborInquiryMapper, LaborInquiryEntity> implements ILaborInquiryService{
    @Override
    public LaborInquiryVO updateInquiry(LaborInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        //是否截止标志
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        LaborInquiryEntity entity = super.selectById(id);
        if(entity != null){
            LambdaUpdateWrapper<LaborInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(LaborInquiryEntity::getId,id);
            updateWrapper.set(LaborInquiryEntity::getQuoteEndDate,quoteEndDate);
            //如果截止，修改询价状态为已截止
            if(quoteEndFlag){
                updateWrapper.set(LaborInquiryEntity::getInquiryState, InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            //如果已截止，但截止时间大于当前时间，修改询价状态为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(entity.getInquiryState()) && quoteEndDate.compareTo(new Date()) > 0){
                updateWrapper.set(LaborInquiryEntity::getInquiryState, InquiryStateEnum.QUOTATION_STATE.getCode());
            }
            super.update(updateWrapper);
        }
        return updateVo;
    }


    @Override
    public void updateInquiry(Long inquiryId,Integer inquiryState){
        LambdaUpdateWrapper<LaborInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(LaborInquiryEntity::getId,inquiryId);
        updateWrapper.set(LaborInquiryEntity::getInquiryState, inquiryState);
        super.update(updateWrapper);
    }
}
