package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("purchaseSettlement")
public class PurchaseSettlementBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    IOutStoreService iOutStoreService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMaterialContractService materialContractService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     *
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 提交完回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核前回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 终审审核完回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())){
            List<InstoreMaterialVO> list = new ArrayList<>();
            List<PurchaseSettlementMaterialDetailEntity> materialDetails = purchaseSettlementEntity.getMaterialDetails();
            for (PurchaseSettlementMaterialDetailEntity e:materialDetails){
                if ("2".equals(e.getSourceType())){
                    InstoreMaterialVO materialVO = new InstoreMaterialVO();
                    materialVO.setId(Long.valueOf(e.getSourceSubId()));
                    materialVO.setInstoreId(Long.valueOf(e.getSourceMainId()));
                    materialVO.setSettleFlag("1");
                    list.add(materialVO);
                }
            }
            if (CollectionUtils.isNotEmpty(list)){
                iInstoreService.updateInStoreSettleFlag(list);
            }
            List<String> outStoreIds = new ArrayList<>();
            List<String> inStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p->{
                //入库单
                if(Objects.equals("2",p.getSourceType())){
                    if(!inStoreIds.contains(p.getSourceMainId())){
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if(Objects.equals("4",p.getSourceType())){
                    if(!outStoreIds.contains(p.getSourceMainId())){
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    if (CollectionUtils.isNotEmpty(entity.getInstoreMaterialList())){
                        List<InstoreMaterialEntity> inStoreMaterialList = entity.getInstoreMaterialList();
                        List<InstoreMaterialEntity> collect2 = inStoreMaterialList.stream().filter(e -> "1".equals(e.getSettleFlag())).collect(Collectors.toList());
                        if (inStoreMaterialList.size()==collect2.size()){
                            entity.setSettlementFlag(1);
                        }else {
                            entity.setSettlementFlag(0);
                        }
                    }else {
                        entity.setSettlementFlag(0);

                    }
                    iInstoreService.saveOrUpdate(entity,false);

                }else {
                    msg.append("1");
                }
            });
            if(msg.length()>0){
                 return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(1);
                    iOutStoreService.saveOrUpdate(entity,false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        iPurchaseSettlementService.processCost(purchaseSettlementEntity);
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);
        if ("1".equals(purchaseSettlementEntity.getSettleType())) {
            LambdaUpdateWrapper<MaterialContractEntity> wrapper = Wrappers.<MaterialContractEntity>lambdaUpdate()
                    .set(MaterialContractEntity::getState, 3)
                    .set(MaterialContractEntity::getStateName, "已封账")
                    .eq(MaterialContractEntity::getId, purchaseSettlementEntity.getContractId());
            materialContractService.update(wrapper);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审前事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getContractId()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,purchaseSettlementEntity.getOrgId()));
        param.getParams().put("createTime", new Parameter(QueryParam.GT, purchaseSettlementEntity.getCreateTime()));
        List<PurchaseSettlementEntity> entities = iPurchaseSettlementService.queryList(param, false);
        if (ListUtil.isNotEmpty(entities)) {
            return CommonResponse.error("该结算单结算之后存在单据编号为【" + entities.get(0).getBillCode() + "】的相同合同和组织的结算单，无法撤回！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            logger.info("物资合同结算单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", billId, billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }

        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("结算 弃审后事件回调 billId="+ billId+" state="+ state+" billTypeCode="+  billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = iPurchaseSettlementService.selectById(billId);
        if(purchaseSettlementEntity==null){
            return CommonResponse.error("没有找到相关结算单！");
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())){
            List<InstoreMaterialVO> list = new ArrayList<>();
            List<PurchaseSettlementMaterialDetailEntity> materialDetails = purchaseSettlementEntity.getMaterialDetails();
            for (PurchaseSettlementMaterialDetailEntity e:materialDetails){
                if ("2".equals(e.getSourceType())){
                    InstoreMaterialVO materialVO = new InstoreMaterialVO();
                    materialVO.setId(Long.valueOf(e.getSourceSubId()));
                    materialVO.setInstoreId(Long.valueOf(e.getSourceMainId()));
                    materialVO.setSettleFlag("0");
                    list.add(materialVO);
                }
            }
            if (CollectionUtils.isNotEmpty(list)){
                iInstoreService.updateInStoreSettleFlag(list);
            }
            List<String> inStoreIds = new ArrayList<>();
            List<String> outStoreIds = new ArrayList<>();
            purchaseSettlementEntity.getMaterialDetails().forEach(p->{
                //入库单
                if(Objects.equals("2",p.getSourceType())){
                    if(!inStoreIds.contains(p.getSourceMainId())){
                        inStoreIds.add(p.getSourceMainId());
                    }
                }
                //出库单
                if(Objects.equals("4",p.getSourceType())){
                    if(!outStoreIds.contains(p.getSourceMainId())){
                        outStoreIds.add(p.getSourceMainId());
                    }
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = iInstoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iInstoreService.saveOrUpdate(entity,false);
                }else {
                    msg.append("1");
                }
            });
            if(msg.length()>0){
                return CommonResponse.error("没有找到结算单中入库单信息！");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = iOutStoreService.selectById(Long.parseLong(s));
                if(entity!=null){
                    entity.setSettlementFlag(0);
                    iOutStoreService.saveOrUpdate(entity,false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error("没有找到结算单中退货单信息！");
            }
        }
        purchaseSettlementEntity.setRelationFlag("0");
        iPurchaseSettlementService.saveOrUpdate(purchaseSettlementEntity);
        if ("1".equals(purchaseSettlementEntity.getSettleType())) {
            LambdaUpdateWrapper<MaterialContractEntity> wrapper = Wrappers.<MaterialContractEntity>lambdaUpdate()
                    .set(MaterialContractEntity::getState, 2)
                    .set(MaterialContractEntity::getStateName, "履约中")
                    .eq(MaterialContractEntity::getId, purchaseSettlementEntity.getContractId());
            materialContractService.update(wrapper);
        }
        return CommonResponse.success();
    }
}
