package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContractVo extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private Integer contractStatus;

    /**
     * 发包单位
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 承包单位,
     */
    @TableField("contractor_unit")
    private Long contractorUnit;

    /**
     * 经营方式：1-自营，2-联营
     */
    @TableField("type")
    private Integer type;

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    @TableField("manage_charge_rate")
    private BigDecimal manageChargeRate;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同计价形式，档案
     */
    @TableField("contract_valuation_type")
    private Long contractValuationType;

    /**
     * 合同计价形式名称
     */
    @TableField("contract_valuation_type_name")
    private String contractValuationTypeName;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 开工日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 竣工日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 总工期
     */
    @TableField("term")
    private Integer term;

    /**
     * 合同是否浮动单价 0-否，1-是
     */
    private Integer floatFlag;
    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;
    /**
     * 质保金
     */
    @TableField("quality_assurance_mny")
    private BigDecimal qualityAssuranceMny;
    /**
     * 质保金到期日期
     */
    @TableField("quality_assurance_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualityAssuranceEndDate;
    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更中金额（含税）
     */
    @TableField("changing_tax_mny")
    private BigDecimal changingTaxMny;

    /**
     * 变更中金额
     */
    @TableField("changing_mny")
    private BigDecimal changingMny;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    @TableField("change_status")
    private Integer changeStatus;

    /**
     * 变更单号
     */
    @TableField("change_code")
    private String changeCode;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 发包单位名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 承包单位名称
     */
    @TableField("contractor_unit_name")
    private String contractorUnitName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 累计产值报量
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;

    /**
     * 累计产值报量
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;

    /**
     * 累计甲方报量（含税）
     */
    @TableField("sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny;

    /**
     * 累计甲方报量
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 累计收款
     */
    @TableField("sum_collect_mny")
    private BigDecimal sumCollectMny;

    /**
     * 累计开票（含税）
     */
    @TableField("sum_invoicing_tax_mny")
    private BigDecimal sumInvoicingTaxMny;

    /**
     * 累计开票
     */
    @TableField("sum_invoicing_mny")
    private BigDecimal sumInvoicingMny;

    private String contractStatusName;
    private String billStateName;
    /**
     * 累计变更洽商
     */
    @TableField("sum_claim_mny")
    private BigDecimal sumClaimMny;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 项目负责人
     */
    private Long projectManager;

    /**
     * 项目负责人名称
     */
    private String projectManagerName;

    /**
     * 项目所属人
     */
    private String projectOwner;

    /**
     * 对方单位负责人
     */
    private String otherPartyManager;

    /**
     * 对方单位负责人联系方式
     */
    private String otherPartyManagerPhone;

    /**
     * 合同类型
     */
    private Long contractType;

    /**
     * 合同类型名称
     */
    private String contractTypeName;
    /**
     * 创建时间 字符
     */
    private String createTimeStr;

    /**
     * 签约时间 字符 临时字段
     */
    private String signDateStr;

    /**
     * 项目详细地址
     */
    private String address;

    /**
     * 信息来源名称
     */
    private String infoSourceName;
    private String sourceId;

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getProjectManager() {
        return projectManager;
    }
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProjectOwner() {
        return projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public String getOtherPartyManager() {
        return otherPartyManager;
    }

    public void setOtherPartyManager(String otherPartyManager) {
        this.otherPartyManager = otherPartyManager;
    }

    public String getOtherPartyManagerPhone() {
        return otherPartyManagerPhone;
    }

    public void setOtherPartyManagerPhone(String otherPartyManagerPhone) {
        this.otherPartyManagerPhone = otherPartyManagerPhone;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public String getSignDateStr() {
        return signDateStr;
    }

    public void setSignDateStr(String signDateStr) {
        this.signDateStr = signDateStr;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    private List<ContractDetailVo> checkList = new ArrayList<>();
    private List<ContractClauseVo> clauseList = new ArrayList<>();

    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode="zydx-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getContractorUnit() {
        return contractorUnit;
    }
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public String getContractValuationTypeName() {
        return contractValuationTypeName;
    }

    public void setContractValuationTypeName(String contractValuationTypeName) {
        this.contractValuationTypeName = contractValuationTypeName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getFloatFlag() {
        return floatFlag;
    }

    public void setFloatFlag(Integer floatFlag) {
        this.floatFlag = floatFlag;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public BigDecimal getQualityAssuranceMny() {
        return qualityAssuranceMny;
    }

    public void setQualityAssuranceMny(BigDecimal qualityAssuranceMny) {
        this.qualityAssuranceMny = qualityAssuranceMny;
    }

    public Date getQualityAssuranceEndDate() {
        return qualityAssuranceEndDate;
    }

    public void setQualityAssuranceEndDate(Date qualityAssuranceEndDate) {
        this.qualityAssuranceEndDate = qualityAssuranceEndDate;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public List<ContractDetailVo> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ContractDetailVo> checkList) {
        this.checkList = checkList;
    }

    public List<ContractClauseVo> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseVo> clauseList) {
        this.clauseList = clauseList;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
