package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 甲方扣款实体
 *
 * @author generator
 *
 */
public class DeductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @TableField("project_id")
    private Long projectId; // 项目
    @TableField("project_name")
    private String projectName; // 项目名称
    @TableField("theme")
    private String theme; // 主题
    @TableField("deduction")
    private java.math.BigDecimal deduction; // 扣款金额
    @TableField("sum_deduction")
    private java.math.BigDecimal sumDeduction; // 扣款总金额
    @TableField(value = "handle_time", fill = FieldFill.INSERT)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date handleTime; // 办理日期
    @TableField("employee_id")
    private Long employeeId; // 经办人
    @TableField("project_id")
    private String employeeName; // 经办人名称
    @TableField("subject_matter")
    private String subjectMatter; // 扣款事由
    @TableField("contract_id")
    private Long contractId; // 合同ID
    @TableField("contract_name")
    private String contractName; // 合同名称
    @TableField("bill_code")
    private String billCode; // 单据编号
    @TableField("bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "commit_date", fill = FieldFill.INSERT)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date commitDate; // 提交日期
    @TableField("commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField("commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date", fill = FieldFill.INSERT)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date effectiveDate; // 生效日期
    private Integer contractVersion;

    @TableField(value="org_id")
    private Long orgId; // 组织

    @TableField(value="org_name")
    private String orgName; // 组织名称

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }
    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }


    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 主题
     */
    public String getTheme() {
        return theme;
    }

    /**
     * 主题
     */
    public void setTheme(String theme) {
        this.theme = theme;
    }
    /**
     * 扣款金额
     */
    public java.math.BigDecimal getDeduction() {
        return deduction;
    }

    /**
     * 扣款金额
     */
    public void setDeduction(java.math.BigDecimal deduction) {
        this.deduction = deduction;
    }
    /**
     * 扣款总金额
     */
    public java.math.BigDecimal getSumDeduction() {
        return sumDeduction;
    }

    /**
     * 扣款总金额
     */
    public void setSumDeduction(java.math.BigDecimal sumDeduction) {
        this.sumDeduction = sumDeduction;
    }
    /**
     * 办理日期
     */
    public java.util.Date getHandleTime() {
        return handleTime;
    }

    /**
     * 办理日期
     */
    public void setHandleTime(java.util.Date handleTime) {
        this.handleTime = handleTime;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 扣款事由
     */
    public String getSubjectMatter() {
        return subjectMatter;
    }

    /**
     * 扣款事由
     */
    public void setSubjectMatter(String subjectMatter) {
        this.subjectMatter = subjectMatter;
    }
    /**
     * 合同ID
     */
    @ReferSerialTransfer(referCode = "zy-income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public java.util.Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(java.util.Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

}
