package com.ejianc.business.labprice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labprice.bean.*;
import com.ejianc.business.labprice.vo.LaborInquiryDetailVO;
import com.ejianc.business.labprice.vo.LaborInquiryVO;
import com.ejianc.business.labprice.vo.LaborQuoteDetailVO;
import com.ejianc.business.labprice.vo.LaborQuoteVO;
import com.ejianc.business.labprice.common.vo.InquiryCommonVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 询价公共服务
 * @date 2023/2/8
 */

@Service("laborInquiryCommonService")
public class LaborInquiryCommonService {

    @Autowired
    private ILaborInquiryService laborInquiryService;

    @Autowired
    private ILaborQuoteService laborQuoteService;


    @Autowired
    private ILaborQuoteDetailService laborQuoteDetailService;

//    @Autowired
//    private ISubContractApi subContractApi;
//    @Autowired
//    private IOtherContractApi otherContractApi;
//    @Autowired
//    private IEquipmentContractApi equipmentContractApi;


    @Autowired
    private ILaborResultService resultService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ILaborPicketageService picketageService;
    @Autowired
    private ILaborPicketageQuoteDetailService picketageQuoteDetailService;

    /**
     * @param inquiryId
     * @param inquiryState
     * @param inquiryType
     * @param picketageFlag
     * @return {@link InquiryCommonVO}
     * @description: 查询各个阶段的询价详情
     * @author songlx
     * @date: 2023/2/8
     */
    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType, Boolean picketageFlag) {
        LaborInquiryEntity inquiryEntity = laborInquiryService.selectById(inquiryId);
        LaborInquiryVO materialInquiryVO = BeanMapper.map(inquiryEntity, LaborInquiryVO.class);

        InquiryCommonVO inquiryCommonVO = BeanMapper.map(materialInquiryVO, InquiryCommonVO.class);

        LambdaQueryWrapper<LaborQuoteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(LaborQuoteEntity::getInquiryId, inquiryId);
        queryWrapper.in(LaborQuoteEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<LaborQuoteEntity> list = laborQuoteService.list(queryWrapper);
        List<LaborQuoteVO> otherQuoteVOS = BeanMapper.mapList(list, LaborQuoteVO.class);
        inquiryCommonVO.setLaborQuoteVOList(otherQuoteVOS);

        //填充询价单信息
        Map<Long, List<LaborPicketageQuoteDetailEntity>> purchaseListMap = new HashMap<>();
        QueryWrapper<LaborPicketageQuoteDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
        quotePurchaseWrapper.eq("inquiry_id", inquiryId);
        List<LaborPicketageQuoteDetailEntity> purchaseDetailEntities = picketageQuoteDetailService.list(quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty(purchaseDetailEntities)) {
            purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(LaborPicketageQuoteDetailEntity::getQuoteId));
        }

        if (CollectionUtils.isNotEmpty(otherQuoteVOS)) {
            List<Long> quoteIds = otherQuoteVOS.stream().map(LaborQuoteVO::getId).collect(Collectors.toList());

            //补充报价附件
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add("quote");
            fileParam.put("sourceTypeList", JSONObject.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            Map<Long, AttachmentVO> fileMap = new HashMap<>();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }
            if (!fileMap.isEmpty()) {
                for (LaborQuoteVO quoteVO : otherQuoteVOS) {
                    AttachmentVO attachmentVO = fileMap.get(quoteVO.getId());
                    if (attachmentVO != null) {
                        quoteVO.setQuoteFileId(attachmentVO.getId());
                        quoteVO.setQuoteFileName(attachmentVO.getFileName());
                    }
                }
            }
            //根据供应商识别号给供应商报价加方案编号
            Map<String, List<LaborQuoteVO>> supplierQuoteMap = otherQuoteVOS.stream().collect(Collectors.groupingBy(LaborQuoteVO::getSocialCreditCode));

            HashMap<Long, String> supplierNameMap = new HashMap<>();
            for (String key : supplierQuoteMap.keySet()) {
                List<LaborQuoteVO> valueList = supplierQuoteMap.get(key);
                if (valueList.size() > 1) {
                    int i = 1;
                    for (LaborQuoteVO materialQuoteVO : valueList) {
                        String biewVersion = " (方案" + i++ + ")";
                        String _supplierNameView = materialQuoteVO.getSupplierName() + biewVersion;
                        materialQuoteVO.setSupplierNameView(_supplierNameView);
                        materialQuoteVO.setViewVersion(biewVersion);
                        supplierNameMap.put(materialQuoteVO.getId(), _supplierNameView);
                    }
                } else {
                    LaborQuoteVO quoteVO = valueList.get(0);
                    quoteVO.setSupplierNameView(quoteVO.getSupplierName());
                    supplierNameMap.put(quoteVO.getId(), quoteVO.getSupplierName());
                }
            }

            if (picketageFlag != null && picketageFlag.booleanValue()) {
                LambdaQueryWrapper<LaborPicketageEntity> picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                picketageEntityLambdaQueryWrapper.eq(LaborPicketageEntity::getInquiryId, inquiryId);
                List<LaborPicketageEntity> picketageEntities = picketageService.list(picketageEntityLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty(picketageEntities)) {
                    LaborPicketageEntity picketageEntity = picketageEntities.get(0);
                    inquiryCommonVO.setId(picketageEntity.getId());
                    inquiryCommonVO.setInquiryDate(picketageEntity.getHandleDate());
                    inquiryCommonVO.setMemo(picketageEntity.getMemo());
                }

                LambdaQueryWrapper<LaborResultEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.in(LaborResultEntity::getQuoteId, quoteIds);
                List<LaborResultEntity> resultEntityList = resultService.list(wrapper);
                if (CollectionUtils.isNotEmpty(resultEntityList)) {
                    BigDecimal sumBidMny = BigDecimal.ZERO;
                    Map<Long, LaborResultEntity> resultEntityMap = resultEntityList.stream().collect(Collectors.toMap(LaborResultEntity::getQuoteId, e -> e, (e1, e2) -> e1));
                    for (LaborQuoteVO otherQuoteVO : otherQuoteVOS) {
                        Long quoteVOId = otherQuoteVO.getId();
                        LaborResultEntity resultEntity = resultEntityMap.get(quoteVOId);
                        if (resultEntity != null) {
                            otherQuoteVO.setSupplierName(resultEntity.getSupplierName());
                            otherQuoteVO.setSupplierNameView(supplierNameMap.get(resultEntity.getQuoteId()));
                            otherQuoteVO.setBidFlag(resultEntity.getBidFlag());
                            otherQuoteVO.setBidMny(resultEntity.getBidMny());
                            otherQuoteVO.setBidMemo(resultEntity.getBidMemo());
                            sumBidMny = ComputeUtil.safeAdd(sumBidMny, resultEntity.getBidMny());
                            if (CollectionUtils.isNotEmpty(purchaseDetailEntities) && CollectionUtils.isNotEmpty(purchaseListMap.get(otherQuoteVO.getId()))) {
                                otherQuoteVO.setLaborQuoteDetailList(BeanMapper.mapList(purchaseListMap.get(otherQuoteVO.getId()), LaborQuoteDetailVO.class));
                            }
                        } else {
                            otherQuoteVO.setBidFlag(0);
                        }
                    }
                    inquiryCommonVO.setSumBidMny(sumBidMny);
                }
            }
            LambdaQueryWrapper<LaborQuoteDetailEntity> purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            purchaseDetailEntityLambdaQueryWrapper.in(LaborQuoteDetailEntity::getQuoteId, quoteIds);
            List<LaborQuoteDetailEntity> purchaseDetailEntityList = laborQuoteDetailService.list(purchaseDetailEntityLambdaQueryWrapper);
            List<LaborQuoteDetailVO> otherQuoteDetailVOS = BeanMapper.mapList(purchaseDetailEntityList, LaborQuoteDetailVO.class);

            if (CollectionUtils.isNotEmpty(otherQuoteDetailVOS)) {
                otherQuoteDetailVOS.forEach(t -> t.setSupplierName(supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<LaborQuoteDetailVO>> purchaseQuoteMap = otherQuoteDetailVOS.stream().collect(Collectors.groupingBy(LaborQuoteDetailVO::getSourceId));

                List<LaborInquiryDetailVO> otherInquiryDetailList = inquiryCommonVO.getLaborInquiryDetailList();

                for (LaborInquiryDetailVO otherInquiryDetailVO : otherInquiryDetailList) {
                    List<LaborQuoteDetailVO> otherQuoteDetailVOList = purchaseQuoteMap.get(otherInquiryDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(otherQuoteDetailVOList)) {
                        List<BigDecimal> quotePriceList = otherQuoteDetailVOList.stream().filter(t -> t.getPurchaseQuotePrice() != null).map(t -> t.getPurchaseQuotePrice()).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(quotePriceList)) {
                            BigDecimal maxPrice = Collections.max(quotePriceList);
                            BigDecimal minPrice = Collections.min(quotePriceList);
                            otherInquiryDetailVO.setMinBidPrice(minPrice);
                            otherInquiryDetailVO.setMaxBidPrice(maxPrice);
                        }
                    }

                    otherInquiryDetailVO.setLaborQuoteDetailVOList(otherQuoteDetailVOList);
                }
            }


        }

        return inquiryCommonVO;
    }

//    public JSONObject queryContractListByInquiry(Long inquiryId, Long picketageId, Integer inquiryState, String inquiryType) {
//        JSONObject resObj = new JSONObject();
//        LambdaQueryWrapper<LaborResultEntity> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(inquiryId != null, LaborResultEntity::getInquiryId, inquiryId);
//        wrapper.eq(picketageId != null, LaborResultEntity::getPicketageId, picketageId);
//        List<LaborResultEntity> list = resultService.list(wrapper);
//        if (CollectionUtils.isEmpty(list)) {
//            return resObj;
//        }
//
//        LambdaQueryWrapper<LaborPicketageEntity> picketageEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
//        picketageEntityLambdaQueryWrapper.eq(inquiryId != null, LaborPicketageEntity::getInquiryId, inquiryId);
//        picketageEntityLambdaQueryWrapper.eq(picketageId != null, LaborPicketageEntity::getId, picketageId);
//        List<LaborPicketageEntity> picketageEntities = picketageService.list(picketageEntityLambdaQueryWrapper);
//        LaborPicketageEntity picketageEntity = CollectionUtils.isNotEmpty(picketageEntities) ? picketageEntities.get(0) : null;
//
//        if (picketageEntity != null) {
//            resObj.put("picketageId", picketageEntity.getId());
//            resObj.put("bidWinnerId", picketageEntity.getBidWinnerId());
//            resObj.put("bidWinnerName", picketageEntity.getBidWinnerName());
//        }
//
//        inquiryId = inquiryId != null ? inquiryId : picketageEntity.getInquiryId();
//
//        if (inquiryId != null) {
//            LaborInquiryEntity byId = laborInquiryService.getById(inquiryId);
//            resObj.put("billCode", byId.getBillCode());
//            resObj.put("billState", byId.getBillState());
//        }
//
//        List<JSONObject> contractList = new ArrayList<>();
//        List<Long> ids = list.stream().map(LaborResultEntity::getId).collect(Collectors.toList());
//        //===================询价类型：1-劳务分包；2-专业分包；3-设备采购；4-设备租赁；5-其他====================================
//        if ("1".equals(inquiryType) || "2".equals(inquiryType)) {
//            CommonResponse<List<ContractVO>> resp = subContractApi.getContractByCondition(ids);
//            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
//                for (ContractVO contractVO : resp.getData()) {
//                    JSONObject obj = new JSONObject();
//                    obj.put("id", contractVO.getId());
//                    obj.put("code", contractVO.getBillCode());
//                    obj.put("contractName", contractVO.getContractName());
//                    obj.put("supplierName", contractVO.getSupplierName());
//                    obj.put("contractType", "分包合同");
//                    if ("1".equals(inquiryType)) {
//                        obj.put("inquiryType", "劳务分包");
//                    } else {
//                        obj.put("inquiryType", "专业分包");
//                    }
//                    obj.put("orgName", contractVO.getOrgName());
//                    obj.put("contractMny", contractVO.getContractTaxMny());
//                    if (contractVO.getSignDate() != null) {
//                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
//                        String signDate = format.format(contractVO.getSignDate());
//                        obj.put("signDate", signDate);
//                    }
//                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(contractVO.getBillState()).getDescription());
//                    obj.put("billState", contractVO.getBillState());
//                    obj.put("changeStatus", contractVO.getChangeStatus());
//                    obj.put("contractStatus", contractVO.getContractStatus());
//                    contractList.add(obj);
//                }
//            }
//        } else if ("3".equals(inquiryType)) {
//            CommonResponse<List<PurchaseContractVO>> resp = equipmentContractApi.getContractByConditionByPurchase(ids);
//            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
//                for (PurchaseContractVO contractVO : resp.getData()) {
//                    JSONObject obj = new JSONObject();
//                    obj.put("id", contractVO.getId());
//                    obj.put("code", contractVO.getBillCode());
//                    obj.put("contractName", contractVO.getContractName());
//                    obj.put("supplierName", contractVO.getSupplierName());
//                    obj.put("contractType", "设备采购合同");
//                    obj.put("inquiryType", "设备采购合同");
//                    obj.put("orgName", contractVO.getOrgName());
//                    obj.put("contractMny", contractVO.getContractTaxMny());
//                    if (contractVO.getSignDate() != null) {
//                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
//                        String signDate = format.format(contractVO.getSignDate());
//                        obj.put("signDate", signDate);
//                    }
//                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(contractVO.getBillState()).getDescription());
//                    obj.put("billState", contractVO.getBillState());
//                    obj.put("changeStatus", contractVO.getChangeStatus());
//                    obj.put("contractStatus", contractVO.getContractStatus());
//                    contractList.add(obj);
//                }
//            }
//        } else if ("4".equals(inquiryType)) {
//            CommonResponse<List<RentContractVO>> resp = equipmentContractApi.getContractByConditionByRent(ids);
//            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
//                for (RentContractVO contractVO : resp.getData()) {
//                    JSONObject obj = new JSONObject();
//                    obj.put("id", contractVO.getId());
//                    obj.put("code", contractVO.getBillCode());
//                    obj.put("contractName", contractVO.getContractName());
//                    obj.put("supplierName", contractVO.getSupplierName());
//                    obj.put("contractType", "设备租赁合同");
//                    obj.put("inquiryType", "设备租赁合同");
//                    obj.put("orgName", contractVO.getOrgName());
//                    obj.put("contractMny", contractVO.getContractTaxMny());
//                    if (contractVO.getSignDate() != null) {
//                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
//                        String signDate = format.format(contractVO.getSignDate());
//                        obj.put("signDate", signDate);
//                    }
//                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(contractVO.getBillState()).getDescription());
//                    obj.put("billState", contractVO.getBillState());
//                    obj.put("changeStatus", contractVO.getChangeStatus());
//                    obj.put("contractStatus", contractVO.getContractStatus());
//                    contractList.add(obj);
//                }
//            }
//        } else if ("5".equals(inquiryType)) {
//            CommonResponse<List<OtherContractVO>> resp = otherContractApi.getContractByCondition(ids);
//            if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
//                for (OtherContractVO contractVO : resp.getData()) {
//                    JSONObject obj = new JSONObject();
//                    obj.put("id", contractVO.getId());
//                    obj.put("code", contractVO.getBillCode());
//                    obj.put("contractName", contractVO.getContractName());
//                    obj.put("supplierName", contractVO.getSupplierName());
//                    obj.put("contractType", "其他合同");
//                    obj.put("inquiryType", "其他合同");
//                    obj.put("orgName", contractVO.getOrgName());
//                    obj.put("contractMny", contractVO.getContractTaxMny());
//                    if (contractVO.getSignDate() != null) {
//                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
//                        String signDate = format.format(contractVO.getSignDate());
//                        obj.put("signDate", signDate);
//                    }
//                    obj.put("billStateName", BillStateEnum.getEnumByStateCode(contractVO.getBillState()).getDescription());
//                    obj.put("billState", contractVO.getBillState());
//                    obj.put("changeStatus", contractVO.getChangeStatus());
//                    obj.put("contractStatus", contractVO.getContractStatus());
//                    contractList.add(obj);
//                }
//            }
//        }
//        resObj.put("contractList", contractList);
//        return resObj;
//    }
}
