package com.ejianc.business.labprice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labprice.vo.LaborQuoteDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 劳务询价报价
 * 
 * @author generator
 * 
 */
public class LaborQuoteVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态 0-自由态，1-已提交
    private String billCode; // 单据编码
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date quoteTime; // 报价时间
    private Long inquiryId; // 询价单id
    private Long supplierId; // 供应商Id
    private String supplierName; // 供应商名称
    private String socialCreditCode; // 纳税人识别号
    private String legal; // 联系人
    private String telephone; // 联系电话
    private BigDecimal totalMny; // 投标总金额
    private BigDecimal totalMnyNoTax; // 投标总金额(无税)
    private String quoteMemo; // 备注
    private String quotePhone; // 报价手机号（登录的手机号）
    //冗余显示
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    private BigDecimal bidMny; // 中标金额
    private String bidMemo; // 中标说明

    //报价附件
    private Long quoteFileId;

    private String quoteFileName;
    @ApiModelProperty(value = "供应商名称")
    private String supplierNameView;


    @ApiModelProperty(value = "方案版本号")
    private String viewVersion;

    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }

    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }

    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }

    public String getSupplierNameView() {
        return supplierNameView;
    }

    public void setSupplierNameView(String supplierNameView) {
        this.supplierNameView = supplierNameView;
    }

    public String getViewVersion() {
        return viewVersion;
    }

    public void setViewVersion(String viewVersion) {
        this.viewVersion = viewVersion;
    }

    private List<LaborQuoteDetailVO> laborQuoteDetailList = new ArrayList<>(); // 劳务询价-报价详情

    public Long getQuoteFileId() {
        return quoteFileId;
    }

    public void setQuoteFileId(Long quoteFileId) {
        this.quoteFileId = quoteFileId;
    }

    public String getQuoteFileName() {
        return quoteFileName;
    }

    public void setQuoteFileName(String quoteFileName) {
        this.quoteFileName = quoteFileName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getTotalMnyNoTax() {
        return totalMnyNoTax;
    }

    public void setTotalMnyNoTax(BigDecimal totalMnyNoTax) {
        this.totalMnyNoTax = totalMnyNoTax;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public String getQuotePhone() {
        return quotePhone;
    }

    public void setQuotePhone(String quotePhone) {
        this.quotePhone = quotePhone;
    }
    
     public List<LaborQuoteDetailVO> getLaborQuoteDetailList() {
        return laborQuoteDetailList;
     }

     public void setLaborQuoteDetailList(List<LaborQuoteDetailVO> laborQuoteDetailList) {
        this.laborQuoteDetailList = laborQuoteDetailList;
     }
}
