/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreBillMaterialService;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreBillMaterialService")
public class InstoreBillMaterialService
extends BaseServiceImpl<InstoreBillMaterialMapper, InstoreBillMaterialEntity>
implements IInstoreBillMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    @Autowired
    private MaterialContractMapper materialContractMapper;

    @Override
    public List<InstoreBillMaterialVO> querylist(QueryWrapper<InstoreBillMaterialEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InstoreBillMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.eq((Object)"dr", (Object)0);
        return this.instoreBillMaterialMapper.countAmount((QueryWrapper<InstoreBillEntity>)queryWrapper);
    }

    @Override
    public IPage<InstoreBillMaterialVO> queryStoreCanUseNumPageData(String searchText, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setCurrent((long)pageNum.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreBillMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId);
        page.setTotal(count.longValue());
        List<InstoreBillMaterialVO> records = this.instoreBillMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreBillMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        Page page = new Page();
        Long count = this.instoreBillMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0L) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent((long)pageNumber.intValue());
                page.setSize((long)pageSize.intValue());
            }
            List<InstoreBillMaterialVO> list = this.instoreBillMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public InstoreBillMaterialVO censusStorematerial(Long storeIid) {
        return this.instoreBillMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreBillMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        Page page = new Page();
        page.setCurrent((long)pageNumber.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreBillMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count.longValue());
        List<InstoreBillMaterialVO> records = this.instoreBillMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreBillMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return this.instoreBillMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        ArrayList<ParamsCheckDsVO> checkDsVOS;
        List<MaterialPriceVO> detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        detailList.forEach(detail -> {
            MaterialPriceVO materialPriceVO = (MaterialPriceVO)((Object)((Object)numMap.get(detail.getMaterialId())));
            if (materialPriceVO != null) {
                materialPriceVO.setNum(ComputeUtil.safeAdd(materialPriceVO.getNum(), detail.getNum()));
            } else {
                numMap.put(detail.getMaterialId(), detail);
            }
        });
        vo.setDetail(new ArrayList<MaterialPriceVO>(numMap.values()));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<MaterialPriceVO> detail2 = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty(detail2)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                List<MaterialPriceVO> vos = this.instoreBillMaterialMapper.queryMaterialInstoreCount(vo.getProjectId(), materialIds);
                List<MaterialPriceVO> materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail2) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null == p) continue;
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                detail2.forEach(d -> {
                    BigDecimal _planNum;
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? (BigDecimal)numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    if (allNum.compareTo(_planNum = planNum.multiply(divide)) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("\u6750\u6599\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u5165\u5e93\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                });
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

